//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WceWrapShell.h
 * @brief		shell ֌Wbv֐Q t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WceWrapShell_H_
#define INCG_IRIS_WceWrapShell_H_

//======================================================================
// include
#include "iris_inchead.h"
#include <shlobj.h>

#if	defined(IRIS_WIN32_WCE)

//======================================================================
// define
#define BROWSEINFOA		BROWSEINFO
#define LPBROWSEINFOA	LPBROWSEINFO
#define BROWSEINFOW		BROWSEINFO
#define LPBROWSEINFOW	LPBROWSEINFO

#define CHOOSECOLORA	CHOOSECOLOR
#define LPCHOOSECOLORA	LPCHOOSECOLOR
#define CHOOSECOLORW	CHOOSECOLOR
#define LPCHOOSECOLORW	LPCHOOSECOLOR
#define ChooseColorA	ChooseColor
#define ChooseColorW	ChooseColor

#define PIDLIST_ABSOLUTE			LPITEMIDLIST
#define PCIDLIST_ABSOLUTE			LPCITEMIDLIST
#define PCUIDLIST_ABSOLUTE			LPCITEMIDLIST
#define PIDLIST_RELATIVE			LPITEMIDLIST
#define PCIDLIST_RELATIVE			LPCITEMIDLIST
#define PUIDLIST_RELATIVE			LPITEMIDLIST
#define PCUIDLIST_RELATIVE			LPCITEMIDLIST
#define PITEMID_CHILD				LPITEMIDLIST
#define PCITEMID_CHILD				LPCITEMIDLIST
#define PUITEMID_CHILD				LPITEMIDLIST
#define PCUITEMID_CHILD				LPCITEMIDLIST
#define PCUITEMID_CHILD_ARRAY		LPCITEMIDLIST *
#define PCUIDLIST_RELATIVE_ARRAY	LPCITEMIDLIST *
#define PCIDLIST_ABSOLUTE_ARRAY		LPCITEMIDLIST *
#define PCUIDLIST_ABSOLUTE_ARRAY	LPCITEMIDLIST *

#ifdef UNICODE
#  define SHGetPathFromIDList	SHGetPathFromIDListW
#else
#  define SHGetPathFromIDList	SHGetPathFromIDListA
#endif

#ifndef SEE_MASK_DOENVSUBST
#  define SEE_MASK_DOENVSUBST	0x00000000
#endif

#ifndef BFFM_SETSELECTION
#  define BFFM_SETSELECTION		BFFM_SELCHANGED
#endif

//======================================================================
// function
EXTERN_C PIDLIST_ABSOLUTE SHBrowseForFolderA(LPBROWSEINFOA lpbi);
EXTERN_C PIDLIST_ABSOLUTE SHBrowseForFolderW(LPBROWSEINFOW lpbi);

EXTERN_C HRESULT STDAPICALLTYPE SHGetFolderPathA(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, __out_ecount(MAX_PATH) LPSTR pszPath);
EXTERN_C HRESULT STDAPICALLTYPE SHGetFolderPathW(HWND hwnd, int csidl, HANDLE hToken, DWORD dwFlags, __out_ecount(MAX_PATH) LPWSTR pszPath);

EXTERN_C BOOL STDAPICALLTYPE SHGetPathFromIDListA(PCIDLIST_ABSOLUTE pidl, __out_ecount(MAX_PATH) LPSTR pszPath);
EXTERN_C BOOL STDAPICALLTYPE SHGetPathFromIDListW(PCIDLIST_ABSOLUTE pidl, __out_ecount(MAX_PATH) LPWSTR pszPath);

EXTERN_C DWORD_PTR STDAPICALLTYPE SHGetFileInfoA(LPCSTR pszPath, DWORD dwFileAttributes, __inout_bcount_opt(cbFileInfo) SHFILEINFOA *psfi,
    UINT cbFileInfo, UINT uFlags);
EXTERN_C DWORD_PTR STDAPICALLTYPE SHGetFileInfoW(LPCWSTR pszPath, DWORD dwFileAttributes, __inout_bcount_opt(cbFileInfo) SHFILEINFOW *psfi,
    UINT cbFileInfo, UINT uFlags);


//======================================================================
// ShellExecute
#ifdef UNICODE
typedef struct _SHELLEXECUTEINFOA
{
        DWORD cbSize;
        ULONG fMask;
        HWND hwnd;
        LPCSTR lpVerb;
        LPCSTR lpFile;
        LPCSTR lpParameters;
        LPCSTR lpDirectory;
        int nShow;
        HINSTANCE hInstApp;
        // Optional fields
        LPVOID lpIDList;
        LPCSTR lpClass;
        HKEY hkeyClass;
        DWORD dwHotKey;
        HANDLE hIcon;
        HANDLE hProcess;
} SHELLEXECUTEINFOA, FAR *LPSHELLEXECUTEINFOA;
typedef SHELLEXECUTEINFO	SHELLEXECUTEINFOW;
typedef LPSHELLEXECUTEINFO	LPSHELLEXECUTEINFOW;
#else
typedef struct _SHELLEXECUTEINFOW
{
        DWORD cbSize;
        ULONG fMask;
        HWND hwnd;
        LPCWSTR lpVerb;
        LPCWSTR lpFile;
        LPCWSTR lpParameters;
        LPCWSTR lpDirectory;
        int nShow;
        HINSTANCE hInstApp;
        // Optional fields
        LPVOID lpIDList;
        LPCWSTR lpClass;
        HKEY hkeyClass;
        DWORD dwHotKey;
        HANDLE hIcon;
        HANDLE hProcess;
} SHELLEXECUTEINFOW, FAR *LPSHELLEXECUTEINFOW;
typedef SHELLEXECUTEINFO	SHELLEXECUTEINFOA;
typedef LPSHELLEXECUTEINFO	LPSHELLEXECUTEINFOA;
#endif

EXTERN_C BOOL STDAPICALLTYPE ShellExecuteExA(__inout LPSHELLEXECUTEINFOA lpExecInfo);
EXTERN_C BOOL STDAPICALLTYPE ShellExecuteExW(__inout LPSHELLEXECUTEINFOW lpExecInfo);

EXTERN_C HINSTANCE STDAPICALLTYPE ShellExecuteA(HWND hwnd, LPCSTR lpOperation, LPCSTR lpFile, LPCSTR lpParameters,
    LPCSTR lpDirectory, INT nShowCmd);
EXTERN_C HINSTANCE STDAPICALLTYPE ShellExecuteW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters,
    LPCWSTR lpDirectory, INT nShowCmd);

#ifdef UNICODE
#  define ShellExecute	ShellExecuteW
#else
#  define ShellExecute	ShellExecuteA
#endif

#endif

#endif
