//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDirectInput.h
 * @brief		DirectInput t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXDirectInput_H_
#define INCG_IRIS_DXDirectInput_H_

//======================================================================
// include
#include "dx_inchead.h"
#include "../win/os/WXModule.h"
#include "fnd/container/FndSingleton.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	DirectInput NX
*/
class CDirectInput : public fnd::CSingleton<CDirectInput>
{
private:
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPDIRECTINPUT8	m_lpDI8;
	wx::CModule		m_Module;	//!< W[
#endif

public:
	// RXgN^
	CDirectInput(void);
	// fXgN^
	~CDirectInput(void);

public:
	/**
	 * @name	operator
	 * @{
	*/
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	LPDIRECTINPUT8			operator -> (void)			{ return m_lpDI8; }
	const LPDIRECTINPUT8	operator -> (void)	const	{ return m_lpDI8; }
#endif
	/**
	 * @}
	*/
public:
	// [h
	bool	Load(void);
	// 
	void	Unload(void);

public:
	/// Lǂ
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	bool			IsValid(void)	const	{ return m_lpDI8 != nullptr; }
#else
	bool			IsValid(void)	const	{ return false; }
#endif

public:
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	/// LPDIRECTInput 擾
			LPDIRECTINPUT8	GetDirectInput(void)			{ return m_lpDI8; }
	const	LPDIRECTINPUT8	GetDirectInput(void)	const	{ return m_lpDI8; }
#endif
};

}	// end of namespace dx
}	// end of namespace iris

#endif
