//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXLib_.cpp
 * @brief		directX lib[ht@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXLib_CPP_

//======================================================================
// include
#include "DXLib.h"
#include "DXError.h"
#include "DXDirect3D.h"
#include "DXDirectInput.h"

namespace iris {
namespace dx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * Cu
 *
*//***********************************************************************/
void ReleaseDxLibAll(void)
{
	ReleaseDInputLib();
	ReleaseDxLib();
}

/**********************************************************************//**
 *
 * d3dx9.dllǂݍ
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool	LoadDxLib(void)
{
	return iris::dx::CDirect3D::GetInstance().Load();
}

/**********************************************************************//**
 *
 * d3dx9.dll
 *
*//***********************************************************************/
void	ReleaseDxLib(void)
{
	iris::dx::CDirect3D::GetInstance().Unload();
}

/**********************************************************************//**
 *
 * dinput8.dllǂݍ
 *
 ----------------------------------------------------------------------
 * @return 
*//***********************************************************************/
bool	LoadDInputLib(void)
{
	return iris::dx::CDirectInput::GetInstance().Load();
}

/**********************************************************************//**
 *
 * dinput8.dll
 *
*//***********************************************************************/
void	ReleaseDInputLib(void)
{
	iris::dx::CDirectInput::GetInstance().Unload();
}

}	// end of namespace dx
}	// end of namespace iris
