//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDebugUnitTest.h
 * @brief		directX P̃eXg⏕NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXDebugUnitTest_H_
#define INCG_IRIS_DXDebugUnitTest_H_

//======================================================================
// include
#include "../../win/debug/unittest/WXDebugUnitTest.h"

namespace iris {
namespace dx {

//======================================================================
// declare
class CDXDevice;

namespace dbg {

//======================================================================
// class
class CDXUnitTestBase : public iris::wx::dbg::CUnitTest<CDXUnitTestBase>
{
public:
	CDXDevice* m_pDevice;
public:
	CDXUnitTestBase() : m_pDevice(nullptr) {}
	void SetDevice(CDXDevice* p)	{ m_pDevice = p; }
	virtual void OnPaint(HWND hWnd)
	{
		IRIS_UNUSED_VAR(hWnd);
		if( m_pDevice != nullptr )
		{
			if( m_pDevice->BeginScene() )
			{
				m_pDevice->Draw();
				m_pDevice->EndScene();
				m_pDevice->Present();
			}
		}
	}
};

}	// end of namespace dbg
}	// end of namespace dx
}	// end of namespace iris

#endif
