//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXDevice.cpp
 * @brief		DirectXfoCXǗt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXDevice_CPP_

//======================================================================
// include
#include "DXDevice.h"
#include "DXObject.h"
#include "light/DXLight.h"
#include "../DXDirect3D.h"
#include "../DXCoordinates.h"
#include "../DXError.h"

#include "../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXDevice::CDXDevice(void)
: m_hWnd(nullptr)
, m_pDevice(nullptr)
, m_pBackBufferSurface(nullptr)
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
, m_pSprite(nullptr)
, m_State(0)
#endif
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CDXDevice::CDXDevice(HWND hWnd)
: m_hWnd(hWnd)
, m_pDevice(nullptr)
, m_pBackBufferSurface(nullptr)
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
, m_pSprite(nullptr)
, m_State(0)
#endif
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXDevice::~CDXDevice(void)
{
	Release();
}

/**********************************************************************//**
 *
 * foCX
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= EBhE
 * @param [in]	height	= EBhE
 * @param [in]	uFlag	= tO
 * @return	
*//***********************************************************************/
bool CDXDevice::CreateDevice(UINT width, UINT height, u32 uFlag)
{
	return CreateDevice(width, height
		, (uFlag & DXCF_FULLSCREEN) != 0
		, (uFlag & DXCF_ANTIALIAS) != 0
		, (uFlag & DXCF_STENCIL) != 0
		, (uFlag & DXCF_HIGH_FPU) != 0
		, (uFlag & DXCF_PURE_SOFTWARTE) != 0
		, (uFlag & DXCF_MULTI_THREAD) != 0
	);
}
/**********************************************************************//**
 *
 * foCX
 *
 ----------------------------------------------------------------------
 * @param [in]	width			= EBhE
 * @param [in]	height			= EBhE
 * @param [in]	fullscreen		= tXN[[ĥƂtrue
 * @param [in]	antialias		= A`GCAX̗L
 * @param [in]	stencilbuffer	= XeVobt@̗L
 * @param [in]	highPrecisionFPU= 
 * @param [in]	pureSoftware	=
 * @param [in]	bMultiThread	= }`XbhZ[t
 * @return	
*//***********************************************************************/
bool CDXDevice::CreateDevice(UINT width, UINT height
							 , bool fullscreen, bool antialias, bool stencilbuffer
							 , bool highPrecisionFPU, bool pureSoftware, bool bMultiThread)
{
	HRESULT hr;
	CDirect3D& d3d = CDirect3D::GetInstance();
	if( !d3d.Load() ) return false;
	//D3DADAPTER_IDENTIFIER9 dai;
	//if(SUCCEEDED(pID3D->GetAdapterIdentifier(D3DADAPTER_DEFAULT, 0, &dai)))
	//{
	//}

	DXDEVTYPE devtype = pureSoftware ? DXDEVTYPE_REF : DXDEVTYPE_HAL;
	// A_v^ƃfoCX^Cv
	UINT adapterToUse = D3DADAPTER_DEFAULT;
#ifdef _IRIS_DEBUG
	// 'NVIDIA PerfHUD'A_v^TĂ΃A_v^ɒu
	for(UINT adapter = 0; adapter < d3d->GetAdapterCount(); ++adapter)
	{
		DXADAPTER_IDENTIFIER identifier;
		hr = d3d->GetAdapterIdentifier(adapter, 0, &identifier);
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
		dprintfA(identifier.Description);
		dprintfA("\n");
		if(strstr(identifier.Description, "PerfHUD") != nullptr)
#else
		dprintfW(identifier.Description);
		dprintfW(L"\n");
		if(wcsstr(identifier.Description, L"PerfHUD") != nullptr)
#endif
		{
			adapterToUse = adapter;
			devtype = DXDEVTYPE_REF;
			IRIS_LOG("PerfHUD");
			break;
		}
	}
#endif

	D3DDISPLAYMODE d3ddm;
	hr = d3d->GetAdapterDisplayMode(adapterToUse, &d3ddm);
	if(FAILED(hr)) { DX_ERROR2( hr, TEXT("GetAdapterDisplayMode") ); return false; }

	// ݒ
	ZeroMemory(&m_Present, sizeof(m_Present));
	m_Present.BackBufferCount			= 1;
	m_Present.EnableAutoDepthStencil	= TRUE;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	m_Present.hDeviceWindow				= m_hWnd;
	m_Present.PresentationInterval		= D3DPRESENT_INTERVAL_DEFAULT;
#endif
	m_Present.Flags						= D3DPRESENTFLAG_LOCKABLE_BACKBUFFER;	// foCXReLXgg

	if( fullscreen )
	{
		m_Present.Windowed			= FALSE;
		m_Present.BackBufferWidth	= width;
		m_Present.BackBufferHeight	= height;
		m_Present.BackBufferFormat	= D3DFMT_X8R8G8B8;
		m_Present.SwapEffect		= D3DSWAPEFFECT_FLIP;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
		m_Present.FullScreen_RefreshRateInHz = D3DPRESENT_RATE_DEFAULT;
#endif
	}
	else
	{
		m_Present.Windowed			= TRUE;
		m_Present.BackBufferFormat	= d3ddm.Format;
		m_Present.SwapEffect		= D3DSWAPEFFECT_COPY;
	}

	// A`GCAX
	if( antialias )
	{
		DWORD qualityLevels = 0;

		if(SUCCEEDED(d3d.CheckDeviceMultiSampleType(adapterToUse,
				devtype, m_Present.BackBufferFormat, !fullscreen,
				D3DMULTISAMPLE_4_SAMPLES, &qualityLevels)))
		{
			// enable multi sampling
			m_Present.SwapEffect         = D3DSWAPEFFECT_DISCARD;
			m_Present.MultiSampleType    = D3DMULTISAMPLE_4_SAMPLES;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
			m_Present.MultiSampleQuality = qualityLevels-1;
#endif
		}
		else
		if(SUCCEEDED(d3d.CheckDeviceMultiSampleType(adapterToUse,
				devtype, m_Present.BackBufferFormat, !fullscreen,
				D3DMULTISAMPLE_2_SAMPLES, &qualityLevels)))
		{
			// enable multi sampling
			m_Present.SwapEffect         = D3DSWAPEFFECT_DISCARD;
			m_Present.MultiSampleType    = D3DMULTISAMPLE_2_SAMPLES;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
			m_Present.MultiSampleQuality = qualityLevels-1;
#endif
		}
		else
		if (SUCCEEDED(d3d.CheckDeviceMultiSampleType(adapterToUse,
					devtype, m_Present.BackBufferFormat, !fullscreen,
					D3DMULTISAMPLE_NONMASKABLE, &qualityLevels)))
		{
			// enable non maskable multi sampling
			m_Present.SwapEffect         = D3DSWAPEFFECT_DISCARD;
			m_Present.MultiSampleType    = D3DMULTISAMPLE_NONMASKABLE;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
			m_Present.MultiSampleQuality = qualityLevels-1;
#endif
		}
		else
		{
			antialias = false;
		}
	}

	// XeVobt@
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( stencilbuffer )
	{
		m_Present.AutoDepthStencilFormat = D3DFMT_D24S8;
		if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
			m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
			D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
		{
			m_Present.AutoDepthStencilFormat = D3DFMT_D24X4S4;
			if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
				m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
				D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
			{
				m_Present.AutoDepthStencilFormat = D3DFMT_D15S1;
				if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
					m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
					D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
				{
					stencilbuffer = false;
				}
			}
		}
		else
		if(FAILED(d3d->CheckDepthStencilMatch(adapterToUse, devtype,
			m_Present.BackBufferFormat, m_Present.BackBufferFormat, m_Present.AutoDepthStencilFormat)))
		{
			stencilbuffer = false;
		}
	}

	if( !stencilbuffer )
	{
		m_Present.AutoDepthStencilFormat = D3DFMT_D32;
		if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
			m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
			D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
		{
			m_Present.AutoDepthStencilFormat = D3DFMT_D24X8;
			if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
				m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
				D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
			{
				m_Present.AutoDepthStencilFormat = D3DFMT_D16;
				if(FAILED(d3d->CheckDeviceFormat(adapterToUse, devtype,
					m_Present.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL,
					D3DRTYPE_SURFACE, m_Present.AutoDepthStencilFormat)))
				{
					IRIS_WARNING( "failed CheckDeviceFormat (D3DRTYPE_SURFACE)." );
					return false;
				}
			}
		}
	}
#endif

	DWORD BehaviorFlag = 0;
	if( bMultiThread )		BehaviorFlag |= D3DCREATE_MULTITHREADED;
	if( highPrecisionFPU )	BehaviorFlag |= D3DCREATE_FPU_PRESERVE;
	if(pureSoftware)
	{
		hr = d3d.CreateDevice(adapterToUse, devtype, m_hWnd,
				BehaviorFlag | D3DCREATE_SOFTWARE_VERTEXPROCESSING, &m_Present, &m_pDevice);
	}
	else
	{
		hr = d3d.CreateDevice(adapterToUse, devtype, m_hWnd,
				BehaviorFlag | D3DCREATE_HARDWARE_VERTEXPROCESSING, &m_Present, &m_pDevice);

		if(FAILED(hr))
			hr = d3d.CreateDevice(adapterToUse, devtype, m_hWnd,
					BehaviorFlag | D3DCREATE_MIXED_VERTEXPROCESSING , &m_Present, &m_pDevice);

		if(FAILED(hr))
			hr = d3d.CreateDevice(adapterToUse, devtype, m_hWnd,
					BehaviorFlag | D3DCREATE_SOFTWARE_VERTEXPROCESSING, &m_Present, &m_pDevice);
	}

	if( m_pDevice == nullptr )
	{
		DX_ERROR2( hr, TEXT("CreateDevice") );
		return false;
	}

	m_pDevice->GetDeviceCaps(&m_Caps);
	if(stencilbuffer &&
		(
		!(m_Caps.StencilCaps & D3DSTENCILCAPS_DECRSAT) ||
		!(m_Caps.StencilCaps & D3DSTENCILCAPS_INCRSAT) ||
		!(m_Caps.StencilCaps & D3DSTENCILCAPS_KEEP)
		)
	)
	{
		stencilbuffer = false;
	}

	// ambient
	SetAmbient();

	EnableState(DXDS_RESTORED);
	SetState(DXDS_ANTIALIAS		, antialias);
	SetState(DXDS_STENCILBUFFER	, stencilbuffer);

	// set maximal anisotropy
	m_pDevice.SetSamplerState(0, D3DSAMP_MAXANISOTROPY, min(16ul, m_Caps.MaxAnisotropy));
	m_pDevice.SetSamplerState(1, D3DSAMP_MAXANISOTROPY, min(16ul, m_Caps.MaxAnisotropy));
	m_pDevice.SetSamplerState(2, D3DSAMP_MAXANISOTROPY, min(16ul, m_Caps.MaxAnisotropy));
	m_pDevice.SetSamplerState(3, D3DSAMP_MAXANISOTROPY, min(16ul, m_Caps.MaxAnisotropy));

	// _O̐ݒ
	SetDefaultRenderState();

	// obNobt@擾
	m_pDevice.GetRenderTarget(0, &m_pBackBufferSurface);

	//RegisterDeviceObject(&m_SwapChain);
	m_SwapChain.SetDevice(this, nullptr);
	m_SwapChain.Create();
	m_Objects.push_back(&m_SwapChain);

	return true;
}

/**********************************************************************//**
 *
 * XvCg쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXDevice::CreateSprite(void)
{
	if( m_pDevice == nullptr ) return false;
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite != nullptr ) return true;
	DX_DO_CHECK_RESULT( D3DXCreateSprite(m_pDevice, &m_pSprite), return false);
#endif
	return true;
}

/**********************************************************************//**
 *
 * foCXXV
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= EBhE
 * @param [in]	height	= EBhE
 * @return	
*//***********************************************************************/
bool CDXDevice::ReSize(UINT width, UINT height)
{
	if( width == 0 || height == 0 ) return false;
	if( m_Present.BackBufferWidth == width
		&& m_Present.BackBufferHeight == height ) return true;

	m_Present.BackBufferWidth = width;
	m_Present.BackBufferHeight= height;
	if( RebuildDevice() ) return true;
	IRIS_WARNING( "failed UpdateDevice." );
	return false;
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXDevice::Update(f32 time)
{
	m_SwapChain.Update(time);
}

/**********************************************************************//**
 *
 * `Jn
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= NAJ[
 * @param [in]	backbuffer	= trueȂD3DCLEAR_TARGET
 * @param [in]	zbuffer		= trueȂD3DCLEAR_ZBUFFER
 * @return	
*//***********************************************************************/
bool CDXDevice::BeginScene(D3DCOLOR color, bool backbuffer, bool zbuffer)
{
	if( m_pDevice == nullptr ) return false;
	if( m_Lock.IsLock() ) return false;
	if( IsState(DXDS_DEVICE_LOST) )
	{
		if( !RestoreDevice() ) return false;
	}
	DWORD flags = backbuffer ? D3DCLEAR_TARGET: 0u;
	if( zbuffer )						flags |= D3DCLEAR_ZBUFFER;
	if( IsState(DXDS_STENCILBUFFER) )	flags |= D3DCLEAR_STENCIL;
	m_pDevice.Clear(0, nullptr, flags, color, 1.0f, 0);
	DX_DO_CHECK_RESULT( m_pDevice.BeginScene(), return false );
	return true;
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXDevice::Draw(void)
{
	m_SwapChain.Draw();
}

/**********************************************************************//**
 *
 * `I
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXDevice::EndScene(void)
{
	IRIS_ASSERT( m_pDevice != nullptr );
	if( IsState(DXDS_DEVICE_LOST) ) return false;
	DX_DO_CHECK_RESULT( m_pDevice.EndScene(), return false );
	return true;
}

/**********************************************************************//**
 *
 * ]
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @return	
*//***********************************************************************/
bool CDXDevice::Present(const RECT* pSrcRect)
{
	return m_SwapChain.Present(pSrcRect);
}

/**********************************************************************//**
 *
 * ]
 *
 ----------------------------------------------------------------------
 * @param [in]	pSrcRect			= ]`
 * @param [in]	hDestWindowOverride	= ]EBhEnh
 * @return	
*//***********************************************************************/
bool CDXDevice::PresentOverride(const RECT* pSrcRect, HWND hDestWindowOverride)
{
	return m_SwapChain.PresentOverride(pSrcRect, hDestWindowOverride);
}

/**********************************************************************//**
 *
 * _OXe[g̐ݒ
 *
*//***********************************************************************/
void CDXDevice::SetDefaultRenderState(void)
{
	UpdateFogParam();

#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	m_pDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS, IsState(DXDS_ANTIALIAS));
#endif

	m_pDevice->SetRenderState(D3DRS_CULLMODE, DXCULL_FACE);	// JO
	m_pDevice->SetRenderState(D3DRS_ZENABLE	, TRUE);
	// At@ufBO̗L
	m_pDevice->SetRenderState(D3DRS_ALPHABLENDENABLE , TRUE);
	m_pDevice->SetRenderState(D3DRS_SRCBLEND , D3DBLEND_SRCALPHA);
	m_pDevice->SetRenderState(D3DRS_DESTBLEND , D3DBLEND_INVSRCALPHA);

	m_pDevice->SetRenderState(D3DRS_SPECULARENABLE, TRUE);

	//m_pDevice->SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 ) ;
	//m_pDevice->SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, 0 ) ;
	//m_pDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE ) ;
	//m_pDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP, D3DTOP_MODULATE ) ;
	//m_pDevice->SetTextureStageState( 1, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_COUNT2 ) ;
	//m_pDevice->SetTextureStageState( 1, D3DTSS_TEXCOORDINDEX, 0 ) ;
	//m_pDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_BLENDFACTORALPHA ) ;
	//m_pDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP, D3DTOP_BLENDFACTORALPHA ) ;
	//for ( int i = 0 ; i < 2 ; i ++ ) {
	//	m_pDevice->SetSamplerState( i, D3DSAMP_MAGFILTER, D3DTEXF_LINEAR ) ;
	//	m_pDevice->SetSamplerState( i, D3DSAMP_MINFILTER, D3DTEXF_LINEAR ) ;
	//	m_pDevice->SetSamplerState( i, D3DSAMP_MIPFILTER, D3DTEXF_LINEAR ) ;
	//	m_pDevice->SetSamplerState( i, D3DSAMP_ADDRESSU, D3DTADDRESS_WRAP ) ;
	//	m_pDevice->SetSamplerState( i, D3DSAMP_ADDRESSV, D3DTADDRESS_WRAP ) ;
	//}
	//m_pDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x00000000 );

	CDXRenderStateParam param;
	param.GetCurrentRenderState(m_pDevice);
	m_RenderState.Activate(m_pDevice, &param);
}

/**********************************************************************//**
 *
 * tHO̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	fog	= tHO
*//***********************************************************************/
void CDXDevice::UpdateFogParam(void)
{
	if( m_pDevice == nullptr )	return;

	m_pDevice->SetRenderState(D3DRS_FOGCOLOR, (DWORD)m_Fog.color);
	m_pDevice->SetRenderState(
		m_Fog.pixel ? D3DRS_FOGTABLEMODE : D3DRS_FOGVERTEXMODE,
		m_Fog.liner ? D3DFOG_LINEAR : D3DFOG_EXP);

	if(m_Fog.liner)
	{
		m_pDevice->SetRenderState(D3DRS_FOGSTART, *(DWORD*)(&m_Fog.start));
		m_pDevice->SetRenderState(D3DRS_FOGEND, *(DWORD*)(&m_Fog.end));
	}
	else
	{
		m_pDevice->SetRenderState(D3DRS_FOGDENSITY, *(DWORD*)(&m_Fog.density));
	}

	if(!m_Fog.pixel)
		m_pDevice->SetRenderState(D3DRS_RANGEFOGENABLE, m_Fog.range);

	m_pDevice->SetRenderState(D3DRS_FOGENABLE, m_Fog.enable);
}

//
// Object

/**********************************************************************//**
 *
 * IuWFNg̐
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
 * @return	
*//***********************************************************************/
bool CDXDevice::RegisterDeviceObject(IDXGXObject* obj)
{
	return m_SwapChain.RegisterDeviceObject(obj);
	//if( obj == nullptr || m_pDevice == nullptr ) return false;
	//if( obj->GetDXDevice() != nullptr ) return true;
	//obj->SetDevice(this, nullptr);
	//if( !obj->Create() ) return false;
	//m_Objects.push_back(obj);
	//return true;
}

/**********************************************************************//**
 *
 * IuWFNg̐
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
 * @return	
*//***********************************************************************/
bool CDXDevice::RegisterDeviceObject(IDXGXObject* obj, IDXSwapChain* pSwapChain)
{
	if( pSwapChain == nullptr ) return RegisterDeviceObject(obj);
	return pSwapChain->RegisterDeviceObject(obj);
}

/**********************************************************************//**
 *
 * IuWFNg̍폜
 *
 ----------------------------------------------------------------------
 * @param [in]	obj	= IuWFNgNX
 * @return	
*//***********************************************************************/
bool CDXDevice::EraseDeviceObject(IDXGXObject* obj)
{
	if( obj != nullptr )
	{
		for( vecObj::iterator it = m_Objects.begin(); it != m_Objects.end(); ++it )
		{
			if( *it == obj )
			{
				obj->SetDevice(nullptr, nullptr);
				m_Objects.erase(it);
				return true;
			}
		}
	}
	return false;
}


//
// Light
/**********************************************************************//**
 *
 * Cg̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	index	= CgCfbNX
 * @param [in]	light	= CgNX
*//***********************************************************************/
void CDXDevice::SetLight(DWORD index, CDXLight* light)
{
	if( m_pDevice == nullptr ) return;
	if( light == nullptr ) return;
	m_pDevice->LightEnable(index, light->GetEnable());
	m_pDevice.SetLight(index, &light->m_Light);
}

/**********************************************************************//**
 *
 * ݂̃Cgݒ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	index	= CgCfbNX
 * @param [in]	light	= CgNX
*//***********************************************************************/
void CDXDevice::GetCurrentLight(DWORD index, CDXLight* light) const
{
	if( m_pDevice == nullptr ) return;
	if( light == nullptr ) return;
	m_pDevice.GetLight(index, &light->m_Light);
}
/**********************************************************************//**
 *
 * ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	ambient	= J[
*//***********************************************************************/
void CDXDevice::SetAmbient(D3DCOLOR ambient)
{
	if( m_pDevice == nullptr ) return;
	m_pDevice->SetRenderState(D3DRS_AMBIENT , ambient);
}

/**********************************************************************//**
 *
 * EBhEnhݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @return	
*//***********************************************************************/
bool CDXDevice::SetHWND(HWND hWnd)
{
	if( m_pDevice != nullptr )
	{
		IRIS_WARNING("The change in the state that the device is created is prohibited.");
		return false;
	}
	m_hWnd = hWnd;
	return true;
}

/**********************************************************************//**
 *
 * foCXԂ̃eXg
 *
 ----------------------------------------------------------------------
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXDevice::TestCooperativeLevel(void)
{
	if( m_pDevice == nullptr ) return false;
	HRESULT hr = m_pDevice->TestCooperativeLevel();
	switch( hr )
	{
	case D3DERR_DEVICENOTRESET:
	case D3DERR_DEVICELOST:
		EnableState(DXDS_DEVICE_LOST);
		break;
	}
	return hr;
}

/**********************************************************************//**
 *
 * foCX̕
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXDevice::RestoreDevice(void)
{
	if( m_pDevice == nullptr ) return false;
	switch( m_pDevice->TestCooperativeLevel() )
	{
	case D3DERR_DEVICENOTRESET:
		if( RebuildDevice() ) break;
	case D3DERR_DEVICELOST:
	default:
		return false;
	}
	return true;
}

/**********************************************************************//**
 *
 * foCX̍č\z
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXDevice::RebuildDevice(void)
{
	HRESULT hr;
	if( m_pDevice == nullptr ) return false;
	m_Lock.Lock();

	// o^IuWFNg̃Zbg
	for( vecObj::iterator it = m_Objects.begin(), end = m_Objects.end(); it != end; ++it )
	{
		(*it)->Reset();
	}
	DX_SAFE_RELEASE( m_pBackBufferSurface );
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite != nullptr )
	{
		DX_DO_CHECK_RESULT(m_pSprite->OnLostDevice(), return false );		// Lock܂܂OK
	}
#endif

	hr = m_pDevice->Reset(&m_Present);
	if( FAILED(hr) )
	{
		if( hr == D3DERR_DEVICELOST ) EnableState(DXDS_DEVICE_LOST);
		//DX_ERROR(hr);
		return false;	// Lock܂܂OK
	}

	m_pDevice.GetRenderTarget(0, &m_pBackBufferSurface);

	// o^IuWFNg̃XgA
	for( vecObj::iterator it = m_Objects.begin(), end = m_Objects.end(); it != end; ++it )
	{
		(*it)->Restore();
	}
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite != nullptr )
	{
		m_pSprite->OnResetDevice();
	}
#endif

	m_RenderState.PrevClear();
	SetDefaultRenderState();

	DisableState(DXDS_DEVICE_LOST);

	//IRIS_WARNING("Restore Device.");

	m_Lock.Unlock();
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXDevice::Release(void)
{
	DX_SAFE_RELEASE( m_pBackBufferSurface );
#if !defined(_IRIS_SUPPORT_DXMOBILE)
	DX_SAFE_RELEASE( m_pSprite );
#endif
	DX_SAFE_RELEASE( m_pDevice );
	//for( vecObj::iterator it = m_Objects.begin(); it != m_Objects.end(); )
	//{
	//	(*it)->SetDevice(nullptr);
	//	it = m_Objects.erase(it);
	//}
}

/**********************************************************************//**
 *
 * obNobt@HDC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	phdc	= óBHDC̃|C^
 * @return	
*//***********************************************************************/
HRESULT CDXDevice::GetDC(HDC* phdc) const
{
	if( m_pBackBufferSurface == nullptr ) return S_FALSE;
	return ( m_pBackBufferSurface->GetDC(phdc) );
}

/**********************************************************************//**
 *
 * obNobt@HDCԋp
 *
 ----------------------------------------------------------------------
 * @param [in]	hdc	= HDC
 * @return	
*//***********************************************************************/
HRESULT CDXDevice::ReleaseDC(HDC hdc)
{
	if( m_pBackBufferSurface == nullptr ) return S_FALSE;
	return ( m_pBackBufferSurface->ReleaseDC(hdc) );
}

}	// end of namespace dx
}	// end of namespace iris
