//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSurface.h
 * @brief		directX T[tFCXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXSurface_H_
#define INCG_IRIS_DXSurface_H_

//======================================================================
// include
#include "layer/DXLayerObject.h"
#include "../../win/gdi/WXDeviceContext.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! eNX`NXC^[tFCX
class CDXSurfaceDC : public wx::CDeviceContext
{
protected:
	LPDXSURFACE	m_pSurface;
public:
	/// RXgN^
	CDXSurfaceDC(LPDXSURFACE pSurface)
		: m_pSurface(pSurface)
	{
		HDC hDC;
		pSurface->GetDC(&hDC);
		Attach(hDC);
	}
	/// fXgN^
	virtual ~CDXSurfaceDC(void)
	{
		HDC hDC = Detach();
		if( m_pSurface != nullptr )
		{
			m_pSurface->ReleaseDC(hDC);
		}
	}
};

}	// end of namespace dx
}	// end of namespace iris

#endif
