//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderState.cpp
 * @brief		_OXe[gNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXRenderState_CPP_

//======================================================================
// include
#include "DXRenderState.h"
#include "../../DXCoordinates.h"

namespace iris {
namespace dx
{

//======================================================================
// variable
static CDXRenderStateParamStore	s_Store;								//!< ޔpp[^
static CDXRenderStateParam*		s_pPrevParam = nullptr;					//!< OKƂ̃p[^
static fnd::CFlag				s_RSFlagPrev(CDXRenderState::RS_FLUSH);	//!< OKƂ̃tO

//======================================================================
// class
// CDXRenderStateParam
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderStateParam::CDXRenderStateParam(void)
: m_Ambient(0xFFFFFFFF)
, m_CullMode(D3DCULL_NONE)
, m_ZEnable(D3DZB_TRUE)
, m_ColorMask(D3DCOLORWRITEENABLE_ALPHA|D3DCOLORWRITEENABLE_RED|D3DCOLORWRITEENABLE_BLUE|D3DCOLORWRITEENABLE_GREEN)
, m_BlendOp(D3DBLENDOP_ADD)
, m_BlendSrc(D3DBLEND_SRCALPHA)
, m_BlendDst(D3DBLEND_INVSRCALPHA)
, m_Flags(RS_DEFAULT)
{
	for( int i=0; i < LIGHT_NUM; ++i ) m_LightEnable[i] = FALSE;
}

/**********************************************************************//**
 *
 * ݂̃_OXe[g擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderStateParam::GetCurrentRenderState(LPDXDEVICE pDevice)
{
	if( pDevice == nullptr ) return false;
	CDXDeviceX device = pDevice;
	// light
	for( DWORD i=0; i < LIGHT_NUM; ++i )
		device->GetLightEnable(i, m_LightEnable + i);
	device.GetRenderState(D3DRS_AMBIENT, &m_Ambient);

	DWORD tmp;
	// fog
	device.GetRenderState(D3DRS_FOGENABLE, &tmp);
	m_Flags.SetFlag(RS_FOGENABLE, tmp != 0);

	// cull mode
	device.GetRenderState(D3DRS_CULLMODE, &tmp);
	m_CullMode = (u8)tmp;

	// z buffer
	device.GetRenderState(D3DRS_ZENABLE, &tmp);
	m_ZEnable = (u8)tmp;
	device.GetRenderState(D3DRS_ZWRITEENABLE, &tmp);
	m_Flags.SetFlag(RS_ZWRITEENABLE, tmp != 0);

	// alpha
	device.GetRenderState(D3DRS_ALPHATESTENABLE, &tmp);
	m_Flags.SetFlag(RS_ALPHATESTENABLE, tmp != 0);
	device.GetRenderState(D3DRS_COLORWRITEENABLE, &tmp);
	m_ColorMask = (u8)tmp;

	// blend
	device.GetRenderState(D3DRS_ALPHABLENDENABLE, &tmp);
	m_Flags.SetFlag(RS_ALPHABLENDENABLE, tmp != 0);
	device.GetRenderState(D3DRS_BLENDOP, &tmp);
	m_BlendOp = (u8)tmp;
	device.GetRenderState(D3DRS_SRCBLEND, &tmp);
	m_BlendSrc = (u8)tmp;
	device.GetRenderState(D3DRS_DESTBLEND, &tmp);
	m_BlendDst = (u8)tmp;
	return true;
}

/**********************************************************************//**
 *
 * ݂̃_OXe[g擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderStateParam::SetCurrentRenderState(LPDXDEVICE pDevice)
{
	if( pDevice == nullptr ) return false;
	CDXDeviceX device = pDevice;
	// light
	for( int i=0; i < LIGHT_NUM; ++i )
		device->LightEnable(i, *(m_LightEnable + i));
	device.SetRenderState(D3DRS_AMBIENT, m_Ambient);

	// fog
	device.SetRenderState(D3DRS_FOGENABLE, m_Flags.IsFlag(RS_FOGENABLE) ? TRUE : FALSE);

	// cull mode
	device.SetRenderState(D3DRS_CULLMODE, (DWORD)m_CullMode);

	// z buffer
	device.SetRenderState(D3DRS_ZENABLE, (DWORD)m_ZEnable);
	device.SetRenderState(D3DRS_ZWRITEENABLE, m_Flags.IsFlag(RS_ZWRITEENABLE) ? TRUE : FALSE);

	// alpha
	device.SetRenderState(D3DRS_ALPHATESTENABLE, m_Flags.IsFlag(RS_ALPHATESTENABLE) ? TRUE : FALSE);
	device.SetRenderState(D3DRS_COLORWRITEENABLE, (DWORD)m_ColorMask);

	// blend
	device.SetRenderState(D3DRS_ALPHABLENDENABLE, m_Flags.IsFlag(RS_ALPHABLENDENABLE) ? TRUE : FALSE);
	device.SetRenderState(D3DRS_BLENDOP, m_BlendOp);
	device.SetRenderState(D3DRS_SRCBLEND, m_BlendSrc);
	device.SetRenderState(D3DRS_DESTBLEND, m_BlendDst);
	return true;
}

// CDXRenderStateParamStore
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderStateParamStore::CDXRenderStateParamStore(void)
{
}

/**********************************************************************//**
 *
 * _OXe[gޔ
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
 * @return	ޔǂ
*//***********************************************************************/
bool CDXRenderStateParamStore::Push(LPDXDEVICE pDevice)
{
	IRIS_ASSERT( pDevice != nullptr );
	int ref = GetRef();
	AddRef();
	if( ref != 0 ) return false;
	m_Param.GetCurrentRenderState(pDevice);
	return true;
}

/**********************************************************************//**
 *
 * _OXe[g𕜋A
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderStateParamStore::Pop(LPDXDEVICE pDevice)
{
	IRIS_ASSERT( pDevice != nullptr );
	IRIS_ASSERT( GetRef() != 0 );
//	if( GetRef() == 0 ) return false;
	SubRef();
	if( GetRef() != 0 ) return false;
	m_Param.SetCurrentRenderState(pDevice);
	return true;
}

// CDXRenderState
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderState::CDXRenderState(void)
: CFlag(RS_DEFAULT)
{
}

/**********************************************************************//**
 *
 * K
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
 * @param [in]	pParam	= p[^
*//***********************************************************************/
bool CDXRenderState::Activate(LPDXDEVICE pDevice, const CDXRenderStateParam* pParam)
{
	if( pDevice == nullptr ) return false;
	if( pParam == nullptr ) return false;
	CFlag tmp(s_RSFlagPrev.IsFlag(RS_FLUSH) ? ~0 : m_Flag ^ s_RSFlagPrev.GetFlag());

	CDXDeviceX device = pDevice;
	// light
	if( tmp.IsFlag(RS_LIGHTING) )
	{
		device.SetRenderState(D3DRS_LIGHTING, TRUE);
		if( IsFlag(RS_LIGHTING) )
		{
			device.SetRenderState(D3DRS_AMBIENT, pParam->GetAmbient());
			for( int i=0; i < CDXRenderStateParam::LIGHT_NUM; ++i )
				device->LightEnable(i, pParam->GetLightEnable(i));
		}
		else
		{
			device.SetRenderState(D3DRS_AMBIENT, 0xffffffff);
			for( int i=0; i < CDXRenderStateParam::LIGHT_NUM; ++i )
				device->LightEnable(i, FALSE);
		}
	}

	// fog
	if( tmp.IsFlag(RS_FOG) )
	{
		device.SetRenderState(D3DRS_FOGENABLE, IsFlag(RS_FOG) ? TRUE : FALSE);
	}

	// cull mode
	if( tmp.IsFlag(RS_CULL_FACE | RS_FLIP_FACE) )
	{
		DWORD mode = D3DCULL_NONE;
		if( IsFlag(RS_CULL_FACE) ) mode = IsFlag(RS_FLIP_FACE) ? DXCULL_BACK : DXCULL_FACE;
		device.SetRenderState(D3DRS_CULLMODE, mode);
	}

	// z buffer
	if( tmp.IsFlag(RS_DEPTH_TEST) )
	{
		device.SetRenderState(D3DRS_ZENABLE, IsFlag(RS_DEPTH_TEST) ? D3DZB_TRUE : D3DZB_FALSE);
	}
	if( tmp.IsFlag(RS_DEPTH_MASK) )
	{
		device.SetRenderState(D3DRS_ZWRITEENABLE, IsFlag(RS_DEPTH_MASK) ? TRUE : FALSE);
	}

	// alpha
	if( tmp.IsFlag(RS_ALPHA_TEST) )
	{
		device.SetRenderState(D3DRS_ALPHATESTENABLE, IsFlag(RS_ALPHA_TEST) ? TRUE : FALSE);
	}
	if( tmp.IsFlag(RS_ALPHA_MASK) )
	{
		DWORD mode = D3DCOLORWRITEENABLE_RED | D3DCOLORWRITEENABLE_BLUE | D3DCOLORWRITEENABLE_GREEN;
		if( IsFlag(RS_ALPHA_MASK) ) mode |= D3DCOLORWRITEENABLE_ALPHA;
		device.SetRenderState(D3DRS_COLORWRITEENABLE, mode);
	}

	// blend
	if( tmp.IsFlag(RS_BLEND) )
	{
		device.SetRenderState(D3DRS_ALPHABLENDENABLE, IsFlag(RS_BLEND) ? TRUE : FALSE);
	}
	if( tmp.IsFlag(RS_OUTPUT_BLEND_FUNC) )
	{
		if( IsFlag(RS_OUTPUT_BLEND_FUNC) )
		{
			device.SetRenderState(D3DRS_BLENDOP	, (DWORD)pParam->GetBlendOp());
			device.SetRenderState(D3DRS_SRCBLEND	, (DWORD)pParam->GetBlendSrc());
			device.SetRenderState(D3DRS_DESTBLEND	, (DWORD)pParam->GetBlendDst());
		}
		else
		{
			device.SetRenderState(D3DRS_BLENDOP	, D3DBLENDOP_ADD);
			device.SetRenderState(D3DRS_SRCBLEND	, D3DBLEND_SRCALPHA);
			device.SetRenderState(D3DRS_DESTBLEND	, D3DBLEND_INVSRCALPHA);
		}
	}

	s_RSFlagPrev.SetFlag( s_pPrevParam == pParam ? m_Flag : RS_FLUSH);
	return true;
}

/**********************************************************************//**
 *
 * K
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
 * @param [in]	pParam	= p[^
*//***********************************************************************/
bool CDXRenderState::Activate(LPDXDEVICE pDevice)
{
	return Activate(pDevice, &s_Store.GetParam());
}

/**********************************************************************//**
 *
 * K̊Jn
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderState::Begin(LPDXDEVICE pDevice)
{
	if( pDevice == nullptr ) return false;
	// ݂̏Ԃޔ
	s_Store.Push(pDevice);
	return Activate(pDevice);
}

/**********************************************************************//**
 *
 * K̏I
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderState::End(LPDXDEVICE pDevice)
{
	if( pDevice == nullptr ) return false;
	// ǂ
	if( s_Store.Pop(pDevice) )
	{
		s_RSFlagPrev.SetFlag(RS_FLUSH);
	}
	return true;
}

/**********************************************************************//**
 *
 * _OXe[gޔ
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
 * @return	ޔǂ
*//***********************************************************************/
bool CDXRenderState::Push(LPDXDEVICE pDevice)
{
	return s_Store.Push(pDevice);
}

/**********************************************************************//**
 *
 * _OXe[g𕜋A
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= foCX
*//***********************************************************************/
bool CDXRenderState::Pop(LPDXDEVICE pDevice)
{
	return s_Store.Pop(pDevice);
}

/**********************************************************************//**
 *
 * ÕtONA
 *
*//***********************************************************************/
void CDXRenderState::PrevClear(void)
{
	s_RSFlagPrev.SetFlag(RS_FLUSH);
}

}	// end of namespace dx
}	// end of namespace iris
