//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFontInfo.h
 * @brief		directX tHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFontInfo_H_
#define INCG_IRIS_DXFontInfo_H_

//======================================================================
// include
#include "iris_object.h"
#include "../../dx_inchead.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! tHgNX
class CDXFontInfo : public IIrisObject
{
	// LOGFONT
    //LONG	Height;
    LONG	Width;
    LONG	Escapement;
    LONG	Orientation;
    LONG	Weight;
    BYTE	Italic;
    BYTE	Underline;
    BYTE	StrikeOut;
    BYTE	CharSet;
    BYTE	OutPrecision;
    BYTE	ClipPrecision;
    BYTE	Quality;
    BYTE	PitchAndFamily;
    CHAR	FaceNameA[LF_FACESIZE];
	WCHAR	FaceNameW[LF_FACESIZE];

	// DXFONT_DESCA
    INT		Height;
    //UINT	Width;
    //UINT	Weight;
    UINT	MipLevels;
    //BOOL	Italic;
    //BYTE	CharSet;
    //BYTE	OutputPrecision;
    //BYTE	Quality;
    //BYTE	PitchAndFamily;
    //CHAR	FaceName[LF_FACESIZE];
public:
	// RXgN^
	CDXFontInfo(void);
	CDXFontInfo(const LOGFONTA& lf);
	CDXFontInfo(const LOGFONTW& lf);
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXFontInfo(const DXFONT_DESCA& lf);
	CDXFontInfo(const DXFONT_DESCW& lf);
#endif
	// fXgN^
	~CDXFontInfo(void);

public:
	// LOGFONT
	CDXFontInfo&	SetLogFontA(const LOGFONTA& lf);
	CDXFontInfo&	SetLogFontW(const LOGFONTW& lf);
	void			GetLogFontA(LOGFONTA& lf) const;
	void			GetLogFontW(LOGFONTW& lf) const;
	// DXFONT_DESCA
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXFontInfo&	SetFontDescaA(const DXFONT_DESCA& fd);
	CDXFontInfo&	SetFontDescaW(const DXFONT_DESCW& fd);
	void			GetFontDescaA(DXFONT_DESCA& fd) const;
	void			GetFontDescaW(DXFONT_DESCW& fd) const;
#endif

public:
	CDXFontInfo&	SetHeight(INT height)					{ Height = height;				return *this; }
	CDXFontInfo&	SetWidth(LONG width)					{ Width = width;				return *this; }
	CDXFontInfo&	SetEscapement(LONG escapement)			{ Escapement = escapement;		return *this; }
	CDXFontInfo&	SetOrientation(LONG orientation)		{ Orientation = orientation;	return *this; }
	CDXFontInfo&	SetWeight(LONG weight)					{ Weight = weight;				return *this; }
	CDXFontInfo&	SetItalic(BYTE italic)					{ Italic = italic;				return *this; }
	CDXFontInfo&	SetUnderline(BYTE underline)			{ Underline = underline;		return *this; }
	CDXFontInfo&	SetStrikeOut(BYTE strikeout)			{ StrikeOut = strikeout;		return *this; }
	CDXFontInfo&	SetCharSet(BYTE charset)				{ CharSet = charset;			return *this; }
	CDXFontInfo&	SetOutPrecision(BYTE outprecision)		{ OutPrecision = outprecision;	return *this; }
	CDXFontInfo&	SetClipPrecision(BYTE clipprecision)	{ ClipPrecision = clipprecision; return *this; }
	CDXFontInfo&	SetQuality(BYTE quality)				{ Quality = quality;			return *this; }
	CDXFontInfo&	SetPitchAndFamily(BYTE pitchandfamily)	{ PitchAndFamily = pitchandfamily; return *this; }
	CDXFontInfo&	SetMipLevels(UINT miplevels)			{ MipLevels = miplevels;		return *this; }
	CDXFontInfo&	SetFaceNameA(LPCSTR   facename);
	CDXFontInfo&	SetFaceNameW(LPCWSTR  facename);

public:
#ifdef UNICODE
	CDXFontInfo&	SetFaceName(LPCWSTR  facename)			{ return SetFaceNameW(facename); }
	CDXFontInfo&	SetLogFont(const LOGFONTW& lf)			{ return SetLogFontW(lf); }
	void			GetLogFont(LOGFONTW& lf) const			{ GetLogFontW(lf); }
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXFontInfo&	SetFontDesca(const DXFONT_DESCW& fd)	{ return SetFontDescaW(fd); }
	void			GetFontDesca(DXFONT_DESCW& fd) const	{ GetFontDescaW(fd); }
#endif
#else
	CDXFontInfo&	SetFaceName(LPCSTR   facename)			{ return SetFaceNameA(facename); }
	CDXFontInfo&	SetLogFont(const LOGFONTA& lf)			{ return SetLogFontA(lf); }
	void			GetLogFont(LOGFONTA& lf) const			{ GetLogFontA(lf); }
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXFontInfo&	SetFontDesca(const DXFONT_DESCA& fd)	{ return SetFontDescaA(fd); }
	void			GetFontDesca(DXFONT_DESCA& fd) const	{ GetFontDescaA(fd); }
#endif
#endif
};

}	// end of namespace dx
}	// end of namespace iris

#endif
