//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFontTexture.h
 * @brief		directX tHgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXFontTexture_H_
#define INCG_IRIS_DXFontTexture_H_

//======================================================================
// include
#include "DXFontInfo.h"
#include "../texture/DXTexture.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! tHgNXC^[tFCX
class IDXFontTexture : public CDXTexture
{
protected:
	intr::DXICOLOR	m_ClearColor;	//!< NAJ[
	intr::DXICOLOR	m_FontColor;	//!< F
	int				m_FontWidth;	//!< tHg
	int				m_FontHeight;	//!< tHg

public:
	// RXgN^
	IDXFontTexture(void) : m_FontColor(0xff000000), m_ClearColor(0x00000000)
		, m_FontWidth(-1), m_FontHeight(-1) {}

	//// fXgN^
	//virtual ~IDXFontTexture(void);

public:
	// eNX`쐬
	virtual bool	Create(UINT width, UINT height) = 0;
public:
	// ̈̃NA
	virtual void	Clear(void)	= 0;
	// 񏑂݁ieNX`ɕށj
	virtual bool	TextOutA( int x, int y, LPCSTR  pString, size_t size ) = 0;
	virtual bool	TextOutW( int x, int y, LPCWSTR pString, size_t size ) = 0;

public:
	// tHg쐬
	// 쐬ۂɃtHg̕ƍXV邱
	// łɍ쐬ς݂̏ꍇ́AfalseԂ
	virtual	bool	CreateFontA( int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCSTR  pszFaceName) = 0;
	virtual	bool	CreateFontW( int height, int width, int weight, DWORD bItalic, DWORD bUnderline, DWORD bStrikeOut
								, DWORD iCharSet, DWORD iOutputPrecision, DWORD iQuality, DWORD iPitchAndFamily
								, LPCWSTR pszFaceName) = 0;
	virtual bool	CreateFontFromInfoA( const CDXFontInfo* lpInfo ) = 0;
	virtual bool	CreateFontFromInfoW( const CDXFontInfo* lpInfo ) = 0;
#ifdef UNICODE
	bool	CreateFontFromInfo( const CDXFontInfo* lpInfo ) { return CreateFontFromInfoW(lpInfo); }
#else
	bool	CreateFontFromInfo( const CDXFontInfo* lpInfo ) { return CreateFontFromInfoA(lpInfo); }
#endif // !UNICODE

	// tHg폜
	virtual	void	DeleteFont(void) = 0;

protected:
	// Zbg
	virtual	void	Reset(void)		{}
	// XgA
	virtual	void	Restore(void)	{}

public:
	// NAJ[
	void			SetClearColor(const intr::DXICOLOR& color)	{ m_ClearColor = color; }
	intr::DXICOLOR	GetClearColor(void)	const					{ return m_ClearColor; }

	// tHgJ[
	void			SetFontColor(const intr::DXICOLOR& color)	{ m_FontColor = color; }
	intr::DXICOLOR	GetFontColor(void)	const					{ return m_FontColor; }

	// tHg̕擾
	int				GetFontWidth(void)	const				{ return m_FontWidth; }
	// tHg̍擾
	int				GetFontHeight(void)	const				{ return m_FontHeight; }

private:
	// B
	virtual bool	CreateTexture(UINT, UINT, UINT, DWORD, D3DFORMAT, D3DPOOL)	{ return false; }
	virtual	bool	Load(LPCSTR path, intr::DXICOLOR remColor=0xFF000000, UINT width=0, UINT height=0, UINT mipmaplevel=1, DWORD usage=0
							, DWORD filter = D3DX_FILTER_NONE, DWORD mipFilter=D3DX_DEFAULT
							, DXIMAGE_INFO* srcInfo=nullptr, PALETTEENTRY* pltEntry=nullptr)
	{
		IRIS_UNUSED_VARIABLE(path);			IRIS_UNUSED_VARIABLE(remColor);		IRIS_UNUSED_VARIABLE(width);
		IRIS_UNUSED_VARIABLE(height);		IRIS_UNUSED_VARIABLE(mipmaplevel);	IRIS_UNUSED_VARIABLE(usage);
		IRIS_UNUSED_VARIABLE(filter);		IRIS_UNUSED_VARIABLE(mipFilter);	IRIS_UNUSED_VARIABLE(srcInfo);
		IRIS_UNUSED_VARIABLE(pltEntry);
		return false;
	}
public:
	// }`oCgR[hɕϊ
	static int		mbtocode(LPCSTR mb, UINT& code)
	{
			if(IsDBCSLeadByte(static_cast<BYTE>(*mb)))
			{
				code = static_cast<UINT>(static_cast<BYTE>(mb[0])<<8 | static_cast<BYTE>(mb[1]));
				return 2;
			}
			else
			{
				code = static_cast<UINT>(static_cast<BYTE>(mb[0]));
				return 1;
			}
	}
};

}	// end of namespace dx
}	// end of namespace iris

#endif
