//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXIndexBuffer.cpp
 * @brief		IndexBuffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXIndexBuffer_CPP_

//======================================================================
// include
#include "DXIndexBuffer.h"
#include "../DXDevice.h"
#include "../../DXError.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXIndexBuffer::CDXIndexBuffer(void)
: m_lpIB(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXIndexBuffer::~CDXIndexBuffer(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	uLength		= _obt@TCY
 * @param [in]	dwUsage		= gp@
 * @param [in]	Format		= tH[}bg
 * @param [in]	Pool		= POOL
 * @return	
*//***********************************************************************/
bool CDXIndexBuffer::Create(UINT uLength, DWORD dwUsage, DXFORMAT Format, DXPOOL Pool)
{
	if( m_lpIB != nullptr ) return false;
	CDXDevice* pDevice = GetDXDevice();
	if( pDevice == nullptr ) return false;
	DX_DO_CHECK_RESULT(pDevice->GetDevice().CreateIndexBuffer(uLength, dwUsage, Format, Pool,
											&m_lpIB)
					, return false);
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXIndexBuffer::Release(void)
{
	DX_SAFE_RELEASE(m_lpIB);
}

/**********************************************************************//**
 *
 * foCXɊ֘At
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT CDXIndexBuffer::SetIndices(void)
{
	IRIS_VERIFYRETURN( m_lpIB != nullptr, E_POINTER );
	LPDXDEVICE pDevice = GetDevice();
	IRIS_VERIFYRETURN( pDevice != nullptr, E_POINTER );
	return pDevice->SetIndices(m_lpIB);
}

/**********************************************************************//**
 *
 * bN
 *
 ----------------------------------------------------------------------
 * @param [out]	ppbData	= o̓obt@
 * @param [in]	uOffset	= bNJnItZbg
 * @param [in]	uSize	= bNTCY(uOffset = 0 && uSize = 0 őS̃bN)
 * @param [in]	dwFlags	= bNtO
 * @return	
*//***********************************************************************/
HRESULT CDXIndexBuffer::Lock(void** ppbData, UINT uOffset, UINT uSize, DWORD dwFlags)
{
	IRIS_VERIFYRETURN( m_lpIB != nullptr, E_POINTER );
	return m_lpIB->Lock(uOffset, uSize, ppbData, dwFlags);
}

/**********************************************************************//**
 *
 * AbN
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
HRESULT CDXIndexBuffer::Unlock(void)
{
	IRIS_VERIFYRETURN( m_lpIB != nullptr, E_POINTER );
	return m_lpIB->Unlock();
}

}	// end of namespace dx
}	// end of namespace iris
