//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMeshFrame.cpp
 * @brief		directX bVReibVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMeshFrame_CPP_

//======================================================================
// include
#include "DXMeshFrame.h"
#include "../DXDevice.h"

#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMeshFrame::CDXMeshFrame(void)
: m_pFrame(nullptr)
, m_pMatrixStack(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMeshFrame::~CDXMeshFrame(void)
{
	Release();
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void CDXMeshFrame::Draw(void)
{
	if( m_pFrame == nullptr ) return;
	SetupRenderState();
	DrawHierarchies(m_pFrame);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXMeshFrame::Release(void)
{
	IDXMesh::Release();
	DX_SAFE_RELEASE( m_pMatrixStack );
	m_Hierarchy.DestroyFrame( m_pFrame );
	m_pFrame = nullptr;
}

/**********************************************************************//**
 *
 * xt@C̓ǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	pFileName	= t@C
 * @return	
*//***********************************************************************/
bool CDXMeshFrame::Load(LPCTSTR pFileName)
{
	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr )
	{
		dprintf( TEXT("There is no device <%s>.\n"), pFileName );
		return false;
	}
	if( pFileName == nullptr ) return false;

	Release();

	if( FAILED(D3DXLoadMeshHierarchyFromX(pFileName
		, D3DXMESH_MANAGED
		, pDxDevice->GetDevice()
		, &m_Hierarchy
		, nullptr
		, &m_pFrame
		, &m_pAnim ) ) )
	{
		dprintf( TEXT("failed D3DXLoadMeshHierarchyFromX. <%s>.\n"), pFileName );
		return false;
	}
	if( FAILED(D3DXCreateMatrixStack(0, &m_pMatrixStack)) )
	{
		IRIS_WARNING( "failed D3DXCreateMatrixStack." );
		return false;
	}
	m_pMatrixStack->LoadIdentity();

	return true;
}

/**********************************************************************//**
 *
 * ǂݍݍς݂ǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
bool CDXMeshFrame::IsValid(void) const
{
	return (m_pFrame != nullptr);
}

/**********************************************************************//**
 *
 * `
 *
 ----------------------------------------------------------------------
 * @param [in]	pFrame	= D3DXFRAME
 * @return	
*//***********************************************************************/
void CDXMeshFrame::DrawHierarchies(LPD3DXFRAME pFrame)
{
	D3DXMATRIX				matrix;
	LPD3DXFRAME				pOldFrame		= pFrame;
	LPD3DXMESHCONTAINEREX	pMeshContainer	= static_cast<LPD3DXMESHCONTAINEREX>(pFrame->pMeshContainer);

	D3DXMatrixIdentity( &matrix );
	m_pMatrixStack->Push();
	matrix = pFrame->TransformationMatrix;
	OnCalcLocalMatrix( &matrix );
	m_pMatrixStack->MultMatrixLocal( &matrix );

	while( pMeshContainer != nullptr )
	{
		ID3DXMesh*			pD3DMesh		= pMeshContainer->MeshData.pMesh;
		D3DXMATERIAL*		pD3DXMaterial	= pMeshContainer->pMaterials;
		LPDXTEXTURE*		pD3DXTexture	= pMeshContainer->pTextures;
		CDXDeviceX			pDevice		= nullptr;
		pD3DMesh->GetDevice(&pDevice);

		pDevice.SetTransform( D3DTS_WORLD, m_pMatrixStack->GetTop() );

		for( DWORD i = 0; i < pMeshContainer->NumMaterials; ++i )
		{
			DXMATERIAL material;

			material = pD3DXMaterial[i].MatD3D;

			OnCalcLocalMaterial( &material );
			pDevice->SetMaterial( &material );
			pDevice.SetTexture( 0, pD3DXTexture[i] );
			pD3DMesh->DrawSubset( i );
			pDevice.SetTexture( 0, nullptr );
		}
		pMeshContainer = static_cast<LPD3DXMESHCONTAINEREX>(pMeshContainer->pNextMeshContainer);
	}

	if( pFrame->pFrameFirstChild != nullptr )
	{
		pFrame = pFrame->pFrameFirstChild;
		DrawHierarchies( pFrame );
	}

	m_pMatrixStack->Pop();
	pFrame = pOldFrame;

	if( pFrame->pFrameSibling != nullptr )
	{
		pFrame = pFrame->pFrameSibling;
		DrawHierarchies( pFrame );
	}
}

/**********************************************************************//**
 *
 * }gbNX̃[h
 *
 ----------------------------------------------------------------------
 * @param [in]	pMatrix	= }gbNX
*//***********************************************************************/
void CDXMeshFrame::LoadMatrix(LPD3DXMATRIX pMatrix)
{
	if( m_pMatrixStack != nullptr )
	{
		m_pMatrixStack->LoadMatrix(pMatrix);
	}
}

/**********************************************************************//**
 *
 * bV\̂̎擾
 *
 ----------------------------------------------------------------------
 * @return	bV\̂̃AhX
*//***********************************************************************/
LPDXMESH CDXMeshFrame::GetMesh(void) const
{
	if( !IsValid() ) return nullptr;
	IRIS_ASSERT( m_pFrame->pMeshContainer != nullptr );
#if 0
	switch( m_pFrame->pMeshContainer->MeshData.Type )
	{
	case D3DXMESHTYPE_MESH:
		return m_pFrame->pMeshContainer->MeshData.pMesh;
	case D3DXMESHTYPE_PMESH:
		return m_pFrame->pMeshContainer->MeshData.pPMesh;
	case D3DXMESHTYPE_PATCHMESH:
		return m_pFrame->pMeshContainer->MeshData.pPatchMesh;
	}
	return nullptr;
#else
	return m_pFrame->pMeshContainer->MeshData.pMesh;
#endif
}

/**********************************************************************//**
 *
 * }eA̐擾
 *
 ----------------------------------------------------------------------
 * @return	}eA̐
*//***********************************************************************/
DWORD CDXMeshFrame::GetMaterialNum(void) const
{
	if( !IsValid() ) return 0;
	IRIS_ASSERT( m_pFrame->pMeshContainer != nullptr );
	return m_pFrame->pMeshContainer->NumMaterials;
}

/**********************************************************************//**
 *
 * }eA̐擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwIndex	= CfbNX
 * @return	}eA̐
*//***********************************************************************/
LPDXMATERIAL CDXMeshFrame::GetMaterial(DWORD dwIndex) const
{
	if( !IsValid() ) return nullptr;
	IRIS_ASSERT( m_pFrame->pMeshContainer != nullptr );
	if( dwIndex >= m_pFrame->pMeshContainer->NumMaterials ) return nullptr;
	IRIS_ASSERT( m_pFrame->pMeshContainer->pMaterials != nullptr );
	return &m_pFrame->pMeshContainer->pMaterials[dwIndex].MatD3D;
}

/**********************************************************************//**
 *
 * eNX`̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	idx	= CfbNX
 * @return	eNX`
*//***********************************************************************/
LPDXTEXTURE CDXMeshFrame::GetTexture(DWORD dwIndex) const
{
	if( !IsValid() ) return nullptr;
	IRIS_ASSERT( m_pFrame->pMeshContainer != nullptr );
	LPD3DXMESHCONTAINEREX pMeshContainer = static_cast<LPD3DXMESHCONTAINEREX>(m_pFrame->pMeshContainer);
	if( pMeshContainer->pTextures == nullptr ) return nullptr;
	if( dwIndex >= pMeshContainer->NumMaterials ) return nullptr;
	return pMeshContainer->pTextures[dwIndex];
}

}	// end of namespace dx
}	// end of namespace iris
