//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMeshSimple.h
 * @brief		directX ȈՃbVNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMeshSimple_H_
#define INCG_IRIS_DXMeshSimple_H_

//======================================================================
// include
#include "DXMesh.h"

namespace iris {
namespace dx
{

//======================================================================
// class
//! ȈՃbVNX
class CDXMeshSimple : public IDXMesh
{
	typedef CDXDeviceObject<LPDXMESH>	MESH;
protected:
	MESH				m_pMesh;		//!< bV
	LPDXMATERIAL		m_pMaterials;			//!< }eA
	DWORD				m_dwNumMaterials;		//!< }eA̐
	LPDXTEXTURE*		m_pTextures;			//!< eNX`

	PFN_DXMeshCreateTexture	m_pfnCreateTexture;	//!< eNX`쐬R[obN
	PFN_DXMeshDeleteTexture	m_pfnDeleteTexture;	//!< eNX`폜R[obN

public:
	// RXgN^
	CDXMeshSimple(void);
	// fXgN^
	virtual ~CDXMeshSimple(void);

public:
	// `
	virtual	void	Draw(void);
	// 
	virtual	void	Release(void);

public:
    // xt@C̓ǂݍ
	virtual bool	Load(LPCTSTR filename);

	// [hς݂ǂ
	virtual bool	IsValid(void) const;

public:
	// set, get
	/// bV\̂̎擾
	virtual	LPDXMESH			GetMesh(void)			const	{ return m_pMesh; }
	/// }eA̐擾
	virtual	DWORD				GetMaterialNum(void)	const	{ return m_dwNumMaterials; }
	/// }eA擾
	virtual	LPDXMATERIAL		GetMaterial(DWORD idx)	const	{ return ( (m_pMaterials == nullptr) || (idx >= m_dwNumMaterials) ) ? nullptr : &m_pMaterials[idx]; }
	/// eNX`̎擾
	virtual	LPDXTEXTURE			GetTexture(DWORD idx)	const	{ return ( (m_pTextures  == nullptr) || (idx >= m_dwNumMaterials) ) ? nullptr : m_pTextures [idx]; }

	// eNX`R[obNݒ
	void	SetCreateTextureFunction(PFN_DXMeshCreateTexture func)	{ m_pfnCreateTexture = func; }
	// eNX`폜R[obNݒ
	void	SetDeleteTextureFunction(PFN_DXMeshDeleteTexture func)	{ m_pfnDeleteTexture = func; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
