//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXVertexBuffer.h
 * @brief		VertexBuffer t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXVertexBuffer_H_
#define INCG_IRIS_DXVertexBuffer_H_

//======================================================================
// include
#include "../DXObject.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**
 * @brief	o[ebNXobt@[NX
*/
class CDXVertexBuffer : virtual public IDXGXObject
{
public:
	typedef CDXDeviceObject<LPDXVERTEXBUFFER>	VERTEXBUFFER;
protected:
	VERTEXBUFFER		m_lpVB;		//!< o[ebNXobt@[
	DWORD				m_dwFVF;	//!< FVF
	UINT				m_uLength;	//!< obt@
	DWORD				m_uStride;	//!< ̃XgCh
public:
	// RXgN^
	CDXVertexBuffer(void);
	// fXgN^
	virtual ~CDXVertexBuffer(void);

public:
	// 쐬
	bool	Create(UINT uLength, DWORD dwUsage, DWORD dwFVF, UINT uStride, DXPOOL Pool);

public:
	//! 쐬
	virtual bool	Create(void) { return true; }
	// 
	virtual	void	Release(void);

protected:
	//! Zbg
	virtual	void	Reset(void)		{}
	//! XgA
	virtual	void	Restore(void)	{}

public:
	// Xg[ɐݒ
	HRESULT	SetStreamSource(UINT StreamNumber, UINT OffsetInBytes);

public:
	/// _̎擾
	UINT	GetVertexCount(void)	const	{ return m_uLength / m_uStride; }

public:
	// bN
	HRESULT	Lock(void** ppbData, UINT uOffset=0, UINT uSize=0, DWORD dwFlags=0);
	// AbN
	HRESULT	Unlock(void);

public:
	const VERTEXBUFFER&	GetVertexBuffer(void) const	{ return m_lpVB; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
