//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXFrame.cpp
 * @brief		directX bVReit@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXFrame_CPP_

//======================================================================
// include
#include "DXFrame.h"

#include "../../../../win/debug/WXDebug.h"
#include "../../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
// CDXFrameAllocHierarchy
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXFrameAllocHierarchy::CDXFrameAllocHierarchy(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXFrameAllocHierarchy::~CDXFrameAllocHierarchy(void)
{
}

/**********************************************************************//**
 *
 * t[ IuWFNg̊蓖Ăv
 *
 -----------------------------------------------------------------------
 * @param [in]	pMesh		= bV
 * @param [in]	ppNewFrame	= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXFrameAllocHierarchy::CreateFrame(LPCSTR pMesh, LPD3DXFRAME *ppNewFrame)
{
	D3DXFRAME *pD3DXFrame = new D3DXFRAME();

	if( pD3DXFrame == nullptr ) return S_FALSE;

	pD3DXFrame->Name = nullptr;
	D3DXMatrixIdentity( &pD3DXFrame->TransformationMatrix );
	pD3DXFrame->pMeshContainer = nullptr;
	pD3DXFrame->pFrameSibling = nullptr;
	pD3DXFrame->pFrameFirstChild = nullptr;

	if( pMesh != nullptr )
	{
		size_t len = strlen( pMesh );

		pD3DXFrame->Name = new char[len + 1];

		if( pD3DXFrame->Name != nullptr )
		{
			pD3DXFrame->Name[len] = '\0';

			strcpy_s( pD3DXFrame->Name, len+1, pMesh );
		}
	}

	*ppNewFrame = pD3DXFrame;

	return D3D_OK;
}

/**********************************************************************//**
 *
 * bV Rei IuWFNg̊蓖Ăv
 *
 -----------------------------------------------------------------------
 * @param [in]	Name				= O
 * @param [in]	pMeshData			= bVf[^
 * @param [in]	pMaterials			= }eA
 * @param [in]	pEffectInstances	= 
 * @param [in]	NumMaterials		= }eA
 * @param [in]	pAdjacency			= 
 * @param [in]	pSkinInfo			= XL
 * @param [in]	ppNewMeshContainer	= 
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXFrameAllocHierarchy::CreateMeshContainer(LPCSTR Name
													, const D3DXMESHDATA *pMeshData
													, const D3DXMATERIAL *pMaterials
													, const D3DXEFFECTINSTANCE *pEffectInstances
													, DWORD NumMaterials
													, const DWORD *pAdjacency
													, LPD3DXSKININFO pSkinInfo
													, LPD3DXMESHCONTAINER *ppNewMeshContainer
													)
{
	D3DXMESHCONTAINER *pD3DXMeshContainer = nullptr;
	DWORD FaceNum = 0;

	pD3DXMeshContainer = AllocateContainer();
	if( pD3DXMeshContainer == nullptr ) return S_FALSE;

	// O̍쐬
	CreateName(pD3DXMeshContainer, Name);

	// bV̍쐬
	CreateMesh(pD3DXMeshContainer, pMeshData);

	// }eA̍쐬
	CreateMaterials(pD3DXMeshContainer, pMaterials, NumMaterials);

	// GtFNg̍쐬
	CreateEffects(pD3DXMeshContainer, pEffectInstances);

	// Adjacency̍쐬
	FaceNum = pMeshData->pMesh->GetNumFaces();
	CreateAdjacency(pD3DXMeshContainer, pAdjacency, FaceNum);

	// Skin̍쐬
	CreateSkin(pD3DXMeshContainer, pSkinInfo);

	*ppNewMeshContainer = pD3DXMeshContainer;
	return D3D_OK;
}

/**********************************************************************//**
 *
 * t[ IuWFNg̊蓖ĉv
 *
 -----------------------------------------------------------------------
 * @param [in]	pFrameToFree	= t[
 * @return	HRESULTl
*//***********************************************************************/
HRESULT CDXFrameAllocHierarchy::DestroyFrame(LPD3DXFRAME pFrameToFree)
{
	if( pFrameToFree == nullptr )	return S_FALSE;

	D3DXFRAME *pD3DXFrame = pFrameToFree;
	D3DXFRAME *pOldFrame = pD3DXFrame;
	D3DXMESHCONTAINER *pD3DXMeshContainer = pD3DXFrame->pMeshContainer;

	if( pD3DXMeshContainer != nullptr )
	{
		DestroyMeshContainer( pD3DXMeshContainer );
	}

	if( pD3DXFrame->pFrameFirstChild != nullptr )
	{
		pD3DXFrame = pD3DXFrame->pFrameFirstChild;
		DestroyFrame( pD3DXFrame );
	}

	pD3DXFrame = pOldFrame;

	if( pD3DXFrame->pFrameSibling != nullptr )
	{
		pD3DXFrame = pD3DXFrame->pFrameSibling;
		DestroyFrame( pD3DXFrame );
	}

	DX_SAFE_DELETE_ARRAY( pFrameToFree->Name );
	DX_SAFE_DELETE( pFrameToFree );
	return D3D_OK;
}

/**********************************************************************//**
 *
 * bV Rei IuWFNg̊蓖ĉv
 *
*//***********************************************************************/
HRESULT CDXFrameAllocHierarchy::DestroyMeshContainer(LPD3DXMESHCONTAINER pMeshContainerToFree)
{
	if( pMeshContainerToFree == nullptr )	return S_FALSE;

	LPD3DXMESHCONTAINER pD3DXMeshContainer = pMeshContainerToFree;

	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pAdjacency );
	DX_SAFE_RELEASE( pD3DXMeshContainer->pSkinInfo );

	for( DWORD i = 0; i < pD3DXMeshContainer->pEffects->NumDefaults; ++ i )
	{
		DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pEffects->pDefaults[i].pValue );
		DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pEffects->pDefaults[i].pParamName );
	}

	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pEffects->pDefaults );
	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pEffects->pEffectFilename );
	DX_SAFE_DELETE( pD3DXMeshContainer->pEffects );

	for( DWORD i = 0; i < pD3DXMeshContainer->NumMaterials; ++ i )
	{
		DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pMaterials[i].pTextureFilename );
	}

	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->pMaterials );

	DX_SAFE_DELETE_ARRAY( pD3DXMeshContainer->Name );

	switch( pD3DXMeshContainer->MeshData.Type )
	{
	case D3DXMESHTYPE_MESH:
		DX_SAFE_RELEASE( pD3DXMeshContainer->MeshData.pMesh );
		break;
	case D3DXMESHTYPE_PMESH:
		DX_SAFE_RELEASE( pD3DXMeshContainer->MeshData.pPMesh );
		break;
	case D3DXMESHTYPE_PATCHMESH:
		DX_SAFE_RELEASE( pD3DXMeshContainer->MeshData.pPatchMesh );
		break;
	}

	DX_SAFE_DELETE( pD3DXMeshContainer );
	return D3D_OK;
}

/**********************************************************************//**
 *
 * Rei\̂̊m
 *
 -----------------------------------------------------------------------
 * @return	D3DXMESHCONTAINER*
*//***********************************************************************/
D3DXMESHCONTAINER* CDXFrameAllocHierarchy::AllocateContainer(void)
{
	D3DXMESHCONTAINER* pD3DXMeshContainer = new D3DXMESHCONTAINER;
	if( pD3DXMeshContainer == nullptr ) return nullptr;
	pD3DXMeshContainer->Name				= nullptr;
	pD3DXMeshContainer->MeshData.Type		= D3DXMESHTYPE_MESH;
	pD3DXMeshContainer->MeshData.pMesh		= nullptr;
	pD3DXMeshContainer->MeshData.pPMesh		= nullptr;
	pD3DXMeshContainer->MeshData.pPatchMesh	= nullptr;
	pD3DXMeshContainer->pMaterials			= nullptr;
	pD3DXMeshContainer->pEffects			= nullptr;
	pD3DXMeshContainer->NumMaterials		= 0;
	pD3DXMeshContainer->pAdjacency			= nullptr;
	pD3DXMeshContainer->pSkinInfo			= nullptr;
	pD3DXMeshContainer->pNextMeshContainer	= nullptr;

	return pD3DXMeshContainer;
}

/**********************************************************************//**
 *
 * O̍쐬
 *
 -----------------------------------------------------------------------
 * @param [out]	pContainer	= Rei
 * @param [in]	lpName		= O
 * @return 
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateName(D3DXMESHCONTAINER* pContainer, LPCSTR lpName)
{
	if( lpName != nullptr )
	{
		size_t len = strlen(lpName);
		LPSTR name = new char[len + 1];

		if( name == nullptr ) return false;
		strcpy_s( name, len+1, lpName );
		pContainer->Name = name;
	}
	return true;
}

/**********************************************************************//**
 *
 * bV̍쐬
 *
 -----------------------------------------------------------------------
 * @param [out]	pContainer	= Rei
 * @param [in]	lpName		= O
 * @return 
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateMesh(D3DXMESHCONTAINER* pContainer, const D3DXMESHDATA* pMeshData)
{
	pContainer->MeshData = *pMeshData;
	switch( pContainer->MeshData.Type )
	{
	case D3DXMESHTYPE_MESH:
		pContainer->MeshData.pMesh->AddRef();
		break;
	case D3DXMESHTYPE_PMESH:
		pContainer->MeshData.pPMesh->AddRef();
		break;
	case D3DXMESHTYPE_PATCHMESH:
		pContainer->MeshData.pPatchMesh->AddRef();
		break;
	}
	// @̐
	if( ( pMeshData->pMesh->GetFVF() & D3DFVF_NORMAL ) == 0 )
	{
		CreateNormalMap(&pContainer->MeshData);
	}
	return true;
}

/**********************************************************************//**
 *
 * @̍쐬
 *
 -----------------------------------------------------------------------
 * @param [in]	pMeshData	= bVf[^
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateNormalMap(D3DXMESHDATA* pMeshData)
{
	HRESULT hr = D3D_OK;
	CDXDeviceX pDevice = nullptr;

	pMeshData->pMesh->GetDevice(&pDevice);
	if( pDevice == nullptr ) return false;

	ID3DXMesh *pTempMesh = nullptr;
	hr = pMeshData->pMesh->CloneMeshFVF(pMeshData->pMesh->GetOptions()
		, pMeshData->pMesh->GetFVF() | D3DFVF_NORMAL
		, pDevice
		, &pTempMesh
		);

	if( FAILED( hr ) ) return false;

	ID3DXMesh *pMesh = pMeshData->pMesh;
	D3DXComputeNormals( pTempMesh, nullptr );
	DX_SAFE_RELEASE( pMesh );
	pMeshData->pMesh = pTempMesh;
	return true;
}

/**********************************************************************//**
 *
 * }eA̍쐬
 *
 -----------------------------------------------------------------------
 * @param [out]	pContainer		= Rei
 * @param [in]	pMaterials		= }eAf[^
 * @param [in]	NumMaterials	= }eA
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateMaterials(D3DXMESHCONTAINER* pContainer, const D3DXMATERIAL *pMaterials, DWORD NumMaterials)
{
	pContainer->NumMaterials = NumMaterials;
	D3DXMATERIAL *pD3DXMaterial = new D3DXMATERIAL[NumMaterials];
	if( pD3DXMaterial == nullptr ) return false;
	pContainer->pMaterials	= pD3DXMaterial;

	for( DWORD i = 0; i < NumMaterials; ++ i )
	{
		pD3DXMaterial[i].MatD3D = pMaterials[i].MatD3D;
		//pD3DXMaterial[i].MatD3D.Ambient = pD3DXMaterial[i].MatD3D.Diffuse;
		pD3DXMaterial[i].pTextureFilename = nullptr;

		CreateTexture(pContainer, pMaterials[i].pTextureFilename, i);
	}
	return true;
}

/**********************************************************************//**
 *
 * eNX`̍쐬
 *
 -----------------------------------------------------------------------
 * @param [io]	pContainer		= Rei
 * @param [in]	lpFileName		= eNX`̃t@C
 * @param [in]	dwIndex			= CfbNX
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateTexture(D3DXMESHCONTAINER* pContainer, LPCSTR lpFileName, DWORD dwIndex)
{
	if( lpFileName != nullptr )
	{
		size_t len = strlen( lpFileName );
		pContainer->pMaterials[dwIndex].pTextureFilename = new char[len + 1];
		if( pContainer->pMaterials[dwIndex].pTextureFilename == nullptr ) return false;
		strcpy_s( pContainer->pMaterials[dwIndex].pTextureFilename, len+1, lpFileName );
	}
	return true;
}

/**********************************************************************//**
 *
 * GtFNg̍쐬
 *
 -----------------------------------------------------------------------
 * @param [io]	pContainer			= Rei
 * @param [in]	pEffectInstances	= GtFNgCX^X
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateEffects(D3DXMESHCONTAINER* pContainer, const D3DXEFFECTINSTANCE *pEffectInstances)
{
	D3DXEFFECTINSTANCE *pD3DXEffectInstance = new D3DXEFFECTINSTANCE;
	if( pD3DXEffectInstance == nullptr ) return false;

	pContainer->pEffects	= pD3DXEffectInstance;
	D3DXEFFECTDEFAULT *pD3DXEffectDefault = nullptr;

	pD3DXEffectInstance->pEffectFilename = nullptr;
	pD3DXEffectInstance->NumDefaults = 0;
	pD3DXEffectInstance->pDefaults = nullptr;

	if( pEffectInstances->pEffectFilename != nullptr )
	{
		size_t len = strlen( pEffectInstances->pEffectFilename );

		pD3DXEffectInstance->pEffectFilename = new char[len + 1];

		if( pD3DXEffectInstance->pEffectFilename != nullptr )
		{
			pD3DXEffectInstance->pEffectFilename[len] = '\0';

			strcpy_s( pD3DXEffectInstance->pEffectFilename, len+1, pEffectInstances->pEffectFilename );
		}
	}

	pD3DXEffectInstance->NumDefaults = pEffectInstances->NumDefaults;
	pD3DXEffectDefault = new D3DXEFFECTDEFAULT[pD3DXEffectInstance->NumDefaults];

	if( pD3DXEffectDefault != nullptr )
	{
		D3DXEFFECTDEFAULT *pDest = pEffectInstances->pDefaults;
		D3DXEFFECTDEFAULT *pSrc = pD3DXEffectDefault;
		DWORD NumBytes = 0;
		DWORD *pdwValue = nullptr;

		for( DWORD i = 0; i < pD3DXEffectInstance->NumDefaults; ++ i )
		{
			pSrc[i].pParamName = nullptr;
			pSrc[i].Type = D3DXEDT_STRING;
			pSrc[i].NumBytes = 0;
			pSrc[i].pValue = nullptr;

			if( pDest[i].pParamName != nullptr )
			{
				size_t len = strlen( pDest[i].pParamName );

				pSrc[i].pParamName = new char[len + 1];

				if( pSrc[i].pParamName != nullptr )
				{
					pSrc[i].pParamName[len] = '\0';

					strcpy_s( pSrc[i].pParamName, len+1, pDest[i].pParamName );
				}
			}

			NumBytes = pSrc[i].NumBytes = pDest[i].NumBytes;
			pSrc[i].Type = pDest[i].Type;

			if( pDest[i].Type <= D3DXEDT_DWORD )
			{
				pdwValue = new DWORD[NumBytes];

				if( pdwValue != nullptr )
				{
					memcpy( pdwValue, pDest[i].pValue, NumBytes );
				}
				pSrc[i].pValue = pdwValue;
			}
		}
	}

	pD3DXEffectInstance->pDefaults = pD3DXEffectDefault;
	return true;
}

/**********************************************************************//**
 *
 * Adjacency̍쐬
 *
 -----------------------------------------------------------------------
 * @param [io]	pContainer	= Rei
 * @param [in]	pAdjacency	= Adjacency
 * @param [in]	FaceNum		= 
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateAdjacency(D3DXMESHCONTAINER* pContainer, const DWORD* pAdjacency, DWORD FaceNum)
{
	LPDWORD pdwAdjacency = new DWORD[FaceNum * 3];
	if( pdwAdjacency == nullptr ) return false;
	pContainer->pAdjacency	= pdwAdjacency;
	memcpy( pdwAdjacency, pAdjacency, sizeof( DWORD ) * FaceNum * 3 );
	return true;
}

/**********************************************************************//**
 *
 * XL̍쐬
 *
 -----------------------------------------------------------------------
 * @param [io]	pContainer	= Rei
 * @param [in]	pSkinInfo	= XL
 * @return	
*//***********************************************************************/
bool CDXFrameAllocHierarchy::CreateSkin(D3DXMESHCONTAINER* pContainer, LPD3DXSKININFO pSkinInfo)
{
	if( pSkinInfo != nullptr )
	{
		pContainer->pSkinInfo = pSkinInfo;
		pContainer->pSkinInfo->AddRef();
	}
	return true;
}

}	// end of namespace dx
}	// end of namespace iris
