//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessage.h
 * @brief		directX bZ[WNXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMessage_H_
#define INCG_IRIS_DXMessage_H_

//======================================================================
// include
#include "DXMessageData.h"
#include "../font/DXFontResource.h"

namespace iris {
namespace dx
{

//======================================================================
//! bZ[WǗNX
class CDXMessageMgr : public IDXLayerObject
{
public:
	typedef std::map<UINT, IDXFontResource*>	CResMap;
	typedef std::pair<UINT, IDXFontResource*>	CResPair;

	typedef std::map<UINT, CDXMessage*>			CMsgMap;
	typedef std::pair<UINT, CDXMessage*>		CMsgPair;

	typedef enum
	{
		eERROR_ID = (UINT)-1,	//!< error ID
	} ERROR_ID;

protected:
	CResMap		m_Resource;	//!< \[XXg
	CMsgMap		m_Message;	//!< bZ[WXg

public:
	// RXgN^
	CDXMessageMgr(void);
	// fXgN^
	virtual ~CDXMessageMgr(void);

public:
	// 쐬
	virtual bool	Create(void)	{ return true; }
	// 
	virtual void	Release(void);
	// XV
	virtual void	Update(f32 time);
	// `
	virtual void	Draw(void);

protected:
	// Zbg
	virtual void	Reset(void)		{}
	// XgA
	virtual void	Restore(void)	{}
public:
	/// bZ[W쐬
	template<class _TC>
	_TC*			CreateMessage(UINT uID, UINT uResID)
	{
		if( GetMessage(uID) != nullptr ) return false;
		_TC* msg = new _TC(uResID);
		m_Message.insert( CMsgPair(uID, msg) );
		return msg;
	}
	/// bZ[W쐬
	CDXMessage*	CreateMessage(UINT uID, UINT uResID)
	{
		return CreateMessage<CDXMessage>(uID, uResID);
	}

	// bZ[W폜
	bool		DeleteMessage(UINT uID);
	// bZ[W擾
	CDXMessage*	GetMessage(UINT uID);

public:
	/// tHg\[X쐬
	template<class ResFont_>
	ResFont_*	CreateResource(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
#ifdef UNICDOE
		return CreateResourceW<ResFont_>(uID, width, height, lpInfo);
#else
		return CreateResourceA<ResFont_>(uID, width, height, lpInfo);
#endif
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResource(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResource<CDXHFontResource>(uID, width, height, lpInfo);
	}

	// tHg\[X폜
	bool				DeleteResource(UINT uID);
	// \[X擾
	IDXFontResource*	GetResource(UINT uID) const;
	// \[X
	bool				WriteResourceA(UINT uID, LPCSTR  pString, size_t size);
	bool				WriteResourceW(UINT uID, LPCWSTR pString, size_t size);
	bool				WriteResource (UINT uID, LPCSTR  pString, size_t size)	{ return WriteResourceA(uID, pString, size); }
	bool				WriteResource (UINT uID, LPCWSTR pString, size_t size)	{ return WriteResourceW(uID, pString, size); }

public:
	/// tHg\[X쐬
	template<class ResFont_>
	ResFont_*	CreateResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( uID == eERROR_ID )				return nullptr;
		if( GetResource(uID) != nullptr )	return nullptr;
		ResFont_* res = new ResFont_;
		if( !RegisterResourceA(uID, width, height, lpInfo, res) )
		{
			delete res;
			res = nullptr;
		}
		return res;
	}
	/// tHg\[X쐬
	template<class ResFont_>
	ResFont_*	CreateResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		if( uID == eERROR_ID )			return nullptr;
		if( GetResource(uID) != nullptr )	return nullptr;
		ResFont_* res = new ResFont_;
		if( !RegisterResourceW(uID, width, height, lpInfo, res) )
		{
			delete res;
			res = nullptr;
		}
		return res;
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResourceA<CDXHFontResource>(uID, width, height, lpInfo);
	}
	/// tHg\[X쐬
	CDXHFontResource*	CreateResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo)
	{
		return CreateResourceW<CDXHFontResource>(uID, width, height, lpInfo);
	}


private:
	// \[Xo^
	bool			RegisterResource (UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont);
	bool			RegisterResourceA(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont);
	bool			RegisterResourceW(UINT uID, UINT width, UINT height, const CDXFontInfo* lpInfo, IDXFontResource* pResFont);

};

}	// end of namespace dx
}	// end of namespace iris

#endif
