//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMessageData.cpp
 * @brief		directX bZ[Wf[^NXt@C
 *
 * @note		GȃNX݌vɂȂĂ܂BBB
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXMessageData_CPP_

//======================================================================
// include
#include "DXMessageData.h"

namespace iris {
namespace dx
{

//======================================================================
// declare

//======================================================================
// class

//======================================================================
// CDXMessageData
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMessageData::CDXMessageData(void)
: m_Length(-1)
, m_Min(0.0f, 0.0f, 0.0f)
, m_Max(0.0f, 0.0f, 0.0f)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMessageData::~CDXMessageData(void)
{
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXMessageData::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * JgʒǔvZ
 *
 ----------------------------------------------------------------------
 * @param [in]	loop	= vZ񐔃JEg
 * @param [in]	idx		= CfbNX
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @param [out]	pos		= óBʒu
*//***********************************************************************/
void CDXMessageData::CalcPosition(int loop, int idx, int width, int height, D3DXVECTOR3& pos)
{
	IRIS_UNUSED_VARIABLE(loop);
	IRIS_UNUSED_VARIABLE(height);
	pos = m_Min;
	pos.x += width * idx;
}

/**********************************************************************//**
 *
 * R[hݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pString	= 
 * @param [in]	size	= 
*//***********************************************************************/
void CDXMessageData::SetCodeA(LPCSTR  pString, size_t size)
{
	m_Code.clear();
	LPCSTR p = pString;
	LPCSTR e = p + size;
	for( ; p < e; )
	{
		UINT code;
		p += IDXFontTexture::mbtocode(p, code);
		m_Code.push_back(code);
	}
}
/// CDXMessageData::SetCodeA Q
void CDXMessageData::SetCodeW(LPCWSTR pString, size_t size)
{
	m_Code.clear();
	LPCWSTR p = pString;
	LPCWSTR e = p + size;
	for( ; p < e; ++p )
	{
		UINT code = *p;
		m_Code.push_back(code);
	}
}

/**********************************************************************//**
 *
 * R[hݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	codes	= R[h
 * @param [in]	size	= R[h
*//***********************************************************************/
void CDXMessageData::SetCodeX(const UINT* codes, size_t size)
{
	m_Code.clear();
	const UINT* p = codes;
	const UINT* e = p + size;
	for( ; p < e; ++p )
	{
		UINT code = *p;
		m_Code.push_back(code);
	}
}

//======================================================================
// CDXMessage
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXMessage::CDXMessage(void)
: m_ResID((UINT)-1)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	uResID = \[XID
*//***********************************************************************/
CDXMessage::CDXMessage(UINT uResID)
: m_ResID(uResID)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXMessage::~CDXMessage(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void CDXMessage::Update(f32 time)
{
	for( CDataMap::iterator it = m_Data.begin(), end = m_Data.end(); it != end; ++it )
	{
		it->second->Update(time);
	}
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXMessage::Release(void)
{
	for( CDataMap::iterator it = m_Data.begin(); it != m_Data.end(); )
	{
		CDXMessageData* p = it->second;
		it = m_Data.erase(it);
		delete p;
	}
}

/**********************************************************************//**
 *
 * f[^폜
 *
 ----------------------------------------------------------------------
 * @param [in]	uID	= bZ[Wf[^ID
 * @return	
*//***********************************************************************/
bool CDXMessage::DeleteMessageData(UINT uID)
{
	CDataMap::iterator it = m_Data.find(uID);
	if( it == m_Data.end() ) return false;
	if( it->first != uID ) return false;
	CDXMessageData* p = it->second;
	m_Data.erase(it);
	delete p;
	return true;
}

/**********************************************************************//**
 *
 * f[^擾
 *
 ----------------------------------------------------------------------
 * @param [in]	id	= bZ[Wf[^ID
 * @return	bZ[Wf[^
*//***********************************************************************/
CDXMessageData* CDXMessage::GetMessageData(UINT uID)
{
	CDataMap::iterator it = m_Data.find(uID);
	if( it == m_Data.end() ) return nullptr;
	if( it->first != uID ) return nullptr;
	return it->second;
}

}	// end of namespace dx
}	// end of namespace iris
