//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXSprite.cpp
 * @brief		DXSprite t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXSprite_CPP_

//======================================================================
// include
#include "DXSprite.h"
#include "../DXDevice.h"
#include "../../DXError.h"

#if	!defined(_IRIS_SUPPORT_DXMOBILE)

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXSprite::CDXSprite(void)
: m_pSprite(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXSprite::~CDXSprite(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXSprite::Create(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite.is_valid() ) return false;
	DX_DO_CHECK_RESULT( D3DXCreateSprite(GetDevice(), &m_pSprite), return false);
	return true;
#else
	return false;
#endif
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXSprite::Release(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	DX_SAFE_RELEASE( m_pSprite );
#endif
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXSprite::Reset(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite.is_valid() )	m_pSprite->OnLostDevice();
#endif
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXSprite::Restore(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	if( m_pSprite.is_valid() )	m_pSprite->OnResetDevice();
#endif
}

}	// end of namespace dx
}	// end of namespace iris

#endif
