//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTarget.cpp
 * @brief		directX _O^[QbgeNX`NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXRenderTarget_CPP_

//======================================================================
// include
#include "DXRenderTarget.h"
#include "../DXDevice.h"
#include "../../DXError.h"

#include "../../../win/debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderTarget::CDXRenderTarget(void)
: m_Format(D3DFMT_X8R8G8B8)
, m_pStencil(nullptr)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXRenderTarget::~CDXRenderTarget(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool CDXRenderTarget::Create(UINT width, UINT height)
{
	return Create(m_Format, width, height);
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	format	= tH[}bg
 * @param [in]	width	= 
 * @param [in]	height	= 
 * @return	
*//***********************************************************************/
bool CDXRenderTarget::Create(D3DFORMAT format, UINT width, UINT height)
{
	Release();

	CDXDevice* pDxDevice = GetDXDevice();
	if( pDxDevice == nullptr ) return false;
	CDXDeviceX pDevice = GetDevice();

	HRESULT hr = pDevice.CreateTexture(width, height, 1, D3DUSAGE_RENDERTARGET
		, format, D3DPOOL_DEFAULT, &m_pTexture, nullptr);
	DX_DO_CHECK_RESULT(hr, return false);

	// XeVobt@
	hr = pDevice.CreateDepthStencilSurface(width, height, GetPresent()->AutoDepthStencilFormat
		, D3DMULTISAMPLE_NONE, 0, 0, &m_pStencil, nullptr );
	DX_DO_CHECK_RESULT(hr, return false);

	// T[tFCX
	hr = m_pTexture->GetSurfaceLevel(0, &m_pSurface);
	DX_DO_CHECK_RESULT(hr, return false);

	m_Format = format;
	m_Width  = width;
	m_Height = height;
	m_TexSize.x = (f32)width;
	m_TexSize.y = (f32)height;
	m_UV0.x = 0.0f;
	m_UV0.y = 0.0f;
	m_UV1.x = (f32)width;
	m_UV1.y = (f32)height;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXRenderTarget::Release(void)
{
	DX_SAFE_RELEASE( m_pStencil );
	IDXTexture::Release();
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXRenderTarget::Reset(void)
{
	Release();
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXRenderTarget::Restore(void)
{
	// ݂̐ݒōĐ
	Create(m_Width, m_Height);
}

/**********************************************************************//**
 *
 * ^[Qbgݒ
 *
 *----------------------------------------------------------------------
 * @param [in]	RenderTargetIndex	= CfbNX
 * @return	
*//***********************************************************************/
bool CDXRenderTarget::SetRenderTarget(DWORD RenderTargetIndex)
{
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return false;

	HRESULT hr = pDevice.SetRenderTarget(RenderTargetIndex, m_pSurface);
	if( FAILED(hr)) { DX_ERROR(hr); return false; }

	hr = pDevice.SetDepthStencilSurface(m_pStencil);
	if( FAILED(hr)) { DX_ERROR(hr); return false; }

	return true;
}

}	// end of namespace dx
}	// end of namespace iris
