//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTexture.cpp
 * @brief		Texture `NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXRenderTexture_CPP_

//======================================================================
// include
#include "DXRenderTexture.h"
#include "DXTexture.h"
#include "../env/DXFVF.h"
#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXRenderTexture::IDXRenderTexture(void)
: m_Color(0xffffffff)
, m_TexSize(-1.0f, -1.0f)
, m_UV0(0.0f, 0.0f)
, m_UV1(1.0f, 1.0f)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= F
 * @param [in]	tex_size	= eNX`TCY
*//***********************************************************************/
IDXRenderTexture::IDXRenderTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size)
: m_Color(color)
, m_TexSize(tex_size)
, m_UV0(0.0f, 0.0f)
, m_UV1(1.0f, 1.0f)
{
}

/**********************************************************************//**
 *
 * eNX`TCYobNobt@TCYɍ킹
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool IDXRenderTexture::FitBackBufferSize(void)
{
	LPCDXPRESENT_PARAMETERS present = GetPresent();
	if( present == nullptr ) return false;
	m_TexSize.x = static_cast<f32>(present->BackBufferWidth);
	m_TexSize.y = static_cast<f32>(present->BackBufferHeight);
	return true;
}

/**********************************************************************//**
 *
 * eNX`ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pTexture	= eNX`NX
*//***********************************************************************/
void IDXRenderTexture::SetTexture(const IDXTexture* pTexture)
{
	IRIS_ASSERT( pTexture != nullptr );
	m_TexSize.x = static_cast<f32>(pTexture->GetWidth());
	m_TexSize.y = static_cast<f32>(pTexture->GetHeight());
}

//======================================================================
// CDXRenderTexture

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXRenderTexture::CDXRenderTexture(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= F
 * @param [in]	tex_size	= eNX`TCY
*//***********************************************************************/
CDXRenderTexture::CDXRenderTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size)
: IDXRenderTexture(color, tex_size)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXRenderTexture::~CDXRenderTexture(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXRenderTexture::Create(void)
{
	SetType(D3DPT_TRIANGLESTRIP);
	SetCount(2);
	CDXDevice* pDevice = GetDXDevice();
	if( pDevice == nullptr ) return false;

	return CDXPrimitive::Create(CDXFVF<FVF>::SIZE * 4, 0, FVF, CDXFVF<FVF>::SIZE, D3DPOOL_DEFAULT);
}

/**********************************************************************//**
 *
 * rh
 *
*//***********************************************************************/
void CDXRenderTexture::Build(void)
{
	CDXFVF<FVF>* ver;
	if( FAILED( Lock(pointer_cast<void**>(&ver)) ) ) return;
	f32 u0 = m_UV0.x;
	f32 v0 = m_UV0.y;
	f32 u1 = m_UV1.x;
	f32 v1 = m_UV1.y;

	f32 cx = m_TexSize.x / 2.0f;
	f32 cy = m_TexSize.y / 2.0f;
	ver[0].vertex(-cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v0);
#ifdef _IRIS_DX_RIGHTHAND
	ver[1].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
	ver[2].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
#else
	ver[1].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
	ver[2].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
#endif
	ver[3].vertex( cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v1);

	Unlock();
}

/**********************************************************************//**
 *
 * eNX`ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	pTexture	= eNX`NX
*//***********************************************************************/
void CDXRenderTexture::SetTexture(const IDXTexture* pTexture)
{
	IDXRenderTexture::SetTexture(pTexture);
	CDXPrimitive::SetTexture(pTexture->GetTexture());
}


}	// end of namespace dx
}	// end of namespace iris
