//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXRenderTexture.h
 * @brief		Texture `NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXRenderTexture_H_
#define INCG_IRIS_DXRenderTexture_H_

//======================================================================
// include
#include "../mesh/DXPrimitive.h"

namespace iris {
namespace dx
{

//======================================================================
// declare
class IDXTexture;

//======================================================================
// class
/**
 * @brief	eNX``C^[tF[XNX
*/
class IDXRenderTexture : virtual public IDXGXObject
{
public:
	// RXgN^
	IDXRenderTexture(void);
	IDXRenderTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size);
public:
	// eNX`̐ݒ
	virtual	void		SetTexture(const IDXTexture* pTexture);

protected:
	D3DCOLOR			m_Color;			//!< _J[
	D3DXVECTOR2			m_TexSize;			//!< `TCY
	D3DXVECTOR2			m_UV0, m_UV1;		//!< eNX`W(0.0f`width,0.0f`height)

public:
	// rh
	virtual	void			Build(void)	{}
	// eNX`TCYobNobt@TCYɂ킹
	virtual	bool			FitBackBufferSize(void);

public:
	// set, get
	// color
	virtual	void			SetColor(const intr::DXICOLOR& color)		{ m_Color = color; }
	virtual	intr::DXICOLOR	GetColor(void)			const				{ return m_Color; }

	// texture size
	virtual	void			SetTextureSize(const D3DXVECTOR2* texsize)	{ m_TexSize = *texsize; }
	virtual	void			SetTextureSize(const D3DXVECTOR2& texsize)	{ m_TexSize = texsize; }
	virtual	D3DXVECTOR2		GetTextureSize(void)	const				{ return m_TexSize; }

	// uv
	virtual	void			SetUV(f32 u0, f32 v0, f32 u1, f32 v1)	{ m_UV0.x = u0; m_UV0.y = v0; m_UV1.x = u1; m_UV1.y = v1; }
};

/**
 * @brief	eNX``NX
*/
class CDXRenderTexture : public CDXPrimitive, public IDXRenderTexture
{
	static const	DWORD	FVF	= (D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1);

public:
	// RXgN^
	CDXRenderTexture(void);
	CDXRenderTexture(const intr::DXICOLOR& color, const D3DXVECTOR2& tex_size);
	// fXgN^
	virtual ~CDXRenderTexture(void);

public:
	// 쐬
	virtual bool	Create(void);

	// 
	virtual	void	Release(void)	{ CDXPrimitive::Release(); }
protected:
	// Zbg
	virtual	void	Reset(void)		{ CDXPrimitive::Reset(); }
	// XgA
	virtual	void	Restore(void)	{ CDXPrimitive::Restore(); }

public:
	// rh
	virtual	void	Build(void);

public:
	// eNX`̐ݒ
	void			SetTexture(const IDXTexture* pTexture);
};

}	// end of namespace dx
}	// end of namespace iris

#endif
