//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXTexture.cpp
 * @brief		directX eNX`NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXTexture_CPP_

//======================================================================
// include
#include "DXTexture.h"
#include "../DXDevice.h"
#include "../../DXCoordinates.h"
#include "../env/DXFVF.h"
#include "../../DXError.h"

#include "../../../win/debug/WXDebug.h"

namespace iris {
namespace dx
{

//======================================================================
// class
// IDXTexture
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
IDXTexture::IDXTexture(void)
: CRenderState(DXRS_DEFAULT)
, m_pTexture(nullptr)
, m_pSurface(nullptr)
, m_Color(0xffffffff)
, m_TexSize(-1.0f, -1.0f)
, m_Width(0)
, m_Height(0)
, m_UV0(0.0f, 0.0f)
, m_UV1(0.0f, 0.0f)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	color		= F
 * @param [in]	tex_size	= eNX`TCY
*//***********************************************************************/
IDXTexture::IDXTexture(intr::DXICOLOR& color, D3DXVECTOR2* tex_size)
: CRenderState(DXRS_DEFAULT)
, m_pTexture(nullptr)
, m_pSurface(nullptr)
, m_Color(color)
, m_TexSize(*tex_size)
, m_Width(0)
, m_Height(0)
, m_UV0(0.0f, 0.0f)
, m_UV1(0.0f, 0.0f)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
IDXTexture::~IDXTexture(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void IDXTexture::Release(void)
{
	DX_SAFE_RELEASE( m_pSurface );
	DX_SAFE_RELEASE( m_pTexture );
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	width		= 
 * @param [in]	height		= 
 * @param [in]	MipLevel	= ~bv}bvxi0w肵ĂLɂȂ̂ŒӁj
 * @param [in]	Usage		= D3DUSAGE_***
 * @param [in]	Format		= D3DFMT_***
 * @param [in]	Pool		= D3DPOOL_***
 * @return	
*//***********************************************************************/
bool IDXTexture::CreateTexture(UINT width, UINT height, UINT MipLevel, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool)
{
	if( width == 0 || height == 0 ) return false;
	if( m_pTexture != nullptr )
	{
		IRIS_WARNING( "failed CreateTexture. already create." );
		return false;
	}
	CDXDevice* pDevice = GetDXDevice();
	if( pDevice == nullptr ) return false;
	DX_DO_CHECK_RESULT(pDevice->GetDevice().CreateTexture(width, height, MipLevel, Usage,
											Format, Pool, &m_pTexture, nullptr)
					, return false);

	m_Width  = width;
	m_Height = height;
	if( m_TexSize.x < 0.0f ) m_TexSize.x = (f32)m_Width;
	if( m_TexSize.y < 0.0f ) m_TexSize.y = (f32)m_Height;
	m_UV0.x = 0.0f;
	m_UV0.y = 0.0f;
	m_UV1.x = (f32)m_Width;
	m_UV1.y = (f32)m_Height;
	return true;
}

/**********************************************************************//**
 *
 * eNX`_OpCvCɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	stage	= eNX`Xe[W
 * @return	
*//***********************************************************************/
HRESULT IDXTexture::SetTexture(DWORD stage)
{
	CDXDeviceX pDevice = GetDevice();
	IRIS_ASSERT( pDevice != nullptr );
	return pDevice.SetTexture(stage, m_pTexture);
}

/**********************************************************************//**
 *
 * nullptreNX`_OpCvCɓo^
 *
 ----------------------------------------------------------------------
 * @param [in]	stage	= eNX`Xe[W
 * @return	
*//***********************************************************************/
HRESULT IDXTexture::ResetTexture(DWORD stage)
{
	CDXDeviceX pDevice = GetDevice();
	IRIS_ASSERT( pDevice != nullptr );
	return pDevice.SetTexture(stage, nullptr);
}

/**********************************************************************//**
 *
 * XV
 *
 ----------------------------------------------------------------------
 * @param [in]	time	= XV
*//***********************************************************************/
void IDXTexture::Update(f32 time)
{
	IRIS_UNUSED_VARIABLE(time);
}

/**********************************************************************//**
 *
 * `
 *
*//***********************************************************************/
void IDXTexture::Draw(void)
{
	if( m_pTexture == nullptr ) return;
	if( IsRenderState(DXRS_DRAWSPRITE) )	Draw2D();
	else									Draw3D();
}

/**********************************************************************//**
 *
 * `(3D)
 *
*//***********************************************************************/
void IDXTexture::Draw3D(void)
{
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	CDXDeviceX& pDevice = pDxDevice->GetDevice();
	// _OXe[g̍XV
	// Cg
	DWORD light;
	D3DXMATRIX mat;
	D3DXMatrixIdentity(&mat);
	pDevice.GetRenderState( D3DRS_LIGHTING , &light);
	pDevice.SetRenderState( D3DRS_LIGHTING , IsRenderState(DXRS_ENABLELIGHT) );
	pDevice.SetTransform(D3DTS_TEXTURE0, &mat);

	if( FAILED(SetTexture(0)) )
	{
		IRIS_WARNING("failed SetTexture.");
	}

	// [hWϊ
	pDevice.SetTransform(D3DTS_WORLD , &m_Mtx);

	// lp`쐬
	{
#define FVF_NORMAL	(D3DFVF_XYZ | D3DFVF_NORMAL | D3DFVF_DIFFUSE | D3DFVF_TEX1)
		CDXFVF<FVF_NORMAL> ver[4];
		f32 u0 = m_UV0.x / m_Width;
		f32 v0 = m_UV0.y / m_Height;
		f32 u1 = m_UV1.x / m_Width;
		f32 v1 = m_UV1.y / m_Height;
#if 0
		f32 w = m_TexSize.x;
		f32 h = m_TexSize.y;
		ver[ 0] = CDXFVF( 0.0f, 0.0f, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u0, v0 );
#ifdef _IRIS_DX_RIGHTHAND
		ver[ 1] = CDXFVF( 0.0f,    h, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u0, v1 );
		ver[ 2] = CDXFVF(    w, 0.0f, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u1, v0 );
#else
		ver[ 1] = CDXFVF(    w, 0.0f, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u1, v0 );
		ver[ 2] = CDXFVF( 0.0f,    h, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u0, v1 );
#endif
		ver[ 3] = CDXFVF(    w,    h, 0.0f,  0.0f,  0.0f, -1.0f, m_Color, u1, v1 );
#else
		f32 cx = m_TexSize.x / 2.0f;
		f32 cy = m_TexSize.y / 2.0f;
		ver[0].vertex(-cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v0);
#ifdef _IRIS_DX_RIGHTHAND
		ver[1].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
		ver[2].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
#else
		ver[1].vertex( cx,  cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v0);
		ver[2].vertex(-cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u0, v1);
#endif
		ver[3].vertex( cx, -cy, 0.0f).normal(0.0f, 0.0f, -1.0f).diffuse(m_Color).uv(u1, v1);
#endif
#if	defined(_IRIS_SUPPORT_DXMOBILE)
		// TODO : Ή
//		pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, ver, CDXFVF<FVF_NORMAL>::SIZE );
#else
		pDevice->SetFVF( FVF_NORMAL );
		pDevice->DrawPrimitiveUP(D3DPT_TRIANGLESTRIP, 2, ver, CDXFVF<FVF_NORMAL>::SIZE );
#endif
	}

	// Ƃɖ߂
	pDevice.SetRenderState( D3DRS_LIGHTING , light );

	ResetTexture(0);
}
/**********************************************************************//**
 *
 * `(2D)
 *
*//***********************************************************************/
void IDXTexture::Draw2D(void)
{
#if	!defined(_IRIS_SUPPORT_DXMOBILE)
	CDXDevice* pDxDevice = GetDXDevice();
	IRIS_ASSERT( pDxDevice != nullptr );
	LPCDXSPRITE pSprite = pDxDevice->GetSprite();
	if( pSprite == nullptr ) return;
	if( FAILED(SetTexture(0)) )
	{
		IRIS_WARNING("failed SetTexture.");
	}
	RECT rect = {	(LONG)m_UV0.x,
					(LONG)m_UV0.y,
					(LONG)m_UV1.x,
					(LONG)m_UV1.y
	};
	//D3DXVECTOR3 center( (rect.right-rect.left)/2.0f, (rect.bottom-rect.top)/2.0f, 0.0f);
	D3DXVECTOR3 center(0.0f, 0.0f, 0.0f);

	// [hWϊ
	D3DXMATRIX matW;
	D3DXMatrixScaling(&matW, m_TexSize.x/(m_UV1.x-m_UV0.x), m_TexSize.y/(m_UV1.y-m_UV0.y), 1.0f);
	D3DXMatrixMultiply(&matW, &m_Mtx, &matW);
	pDxDevice->SetRenderState(D3DRS_CULLMODE, DXCULL_FACE);
	pSprite->SetTransform(&matW);
	pSprite->Begin(D3DXSPRITE_ALPHABLEND);
	DX_CHECK_RESULT( pSprite->Draw( m_pTexture
									, &rect
									, &center
									, &center
									, m_Color ) );
	pSprite->End();

	ResetTexture(0);
#endif
}

/**********************************************************************//**
 *
 * eNX`TCYobNobt@TCYɍ킹
 *
*//***********************************************************************/
bool IDXTexture::FitBackBufferSize(void)
{
	LPCDXPRESENT_PARAMETERS present = GetPresent();
	if( present == nullptr ) return false;
	m_TexSize.x = (f32)present->BackBufferWidth;
	m_TexSize.y = (f32)present->BackBufferHeight;
	return true;
}

/**********************************************************************//**
 *
 * eNX`̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [in] lprc	= o
*//***********************************************************************/
void IDXTexture::GetRect(LPRECT lprc) const
{
	IRIS_ASSERT( lprc != nullptr );
	lprc->left = lprc->top = 0;
	lprc->right = GetWidth();
	lprc->bottom = GetHeight();
}


// CDXTexture
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXTexture::CDXTexture(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXTexture::~CDXTexture(void)
{
}

/**********************************************************************//**
 *
 * t@Cǂݍ
 *
 ----------------------------------------------------------------------
 * @param [in]	path		= t@CpX
 * @param [in]	remColor	= F
 * @param [in]	width		= 
 * @param [in]	height		= 
 * @param [in]	mipmaplevel	= ~bv}bvxi0w肵ĂLɂȂ̂ŒӁj
 * @param [in]	usage		= D3DUSAGE_***
 * @param [in]	filter		= D3DX_FILTER_***
 * @param [in]	mipFilter	= D3DX_***
 * @param [out]	srcInfo		= C[W
 * @param [out]	pltEntry	= 
 * @return	
*//***********************************************************************/
bool CDXTexture::Load(LPCTSTR path, intr::DXICOLOR remColor, UINT width, UINT height, UINT mipmaplevel, DWORD usage
						, DWORD filter, DWORD mipFilter
						, DXIMAGE_INFO* srcInfo, PALETTEENTRY* pltEntry)
{
	if( m_pTexture != nullptr )
	{
		IRIS_WARNING( "failed CreateTexture. already create." );
		return false;
	}
	CDXDeviceX pDevice = GetDevice();
	if( pDevice == nullptr ) return false;

	DXIMAGE_INFO* pdii = srcInfo;
	DXIMAGE_INFO dii;
	if( pdii == nullptr ) pdii = &dii;

	HRESULT hr = D3DXCreateTextureFromFileEx(pDevice, path,
		width, height, mipmaplevel, usage,
		D3DFMT_UNKNOWN, D3DPOOL_MANAGED, filter, mipFilter,
		remColor, pdii, pltEntry, &m_pTexture);
	if(FAILED(hr))
	{
		DX_ERROR(hr);
		dprintf(TEXT("failed D3DXCreateTextureFromFileEx <%s>."), path);
		return false;
	}
	m_Width  = pdii->Width;
	m_Height = pdii->Height;
	if( m_TexSize.x < 0.0f ) m_TexSize.x = (f32)m_Width;
	if( m_TexSize.y < 0.0f ) m_TexSize.y = (f32)m_Height;
	m_UV0.x = 0.0f;
	m_UV0.y = 0.0f;
	m_UV1.x = (f32)m_Width;
	m_UV1.y = (f32)m_Height;
	return true;
}

/**********************************************************************//**
 *
 * Zbg
 *
*//***********************************************************************/
void CDXTexture::Reset(void)
{
}

/**********************************************************************//**
 *
 * XgA
 *
*//***********************************************************************/
void CDXTexture::Restore(void)
{
}

}	// end of namespace dx
}	// end of namespace iris
