//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXQuaternion.cpp
 * @brief		directX NH[^jIvZ⏕֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXQuaternion_CPP_

//======================================================================
// include
#include "DXQuaternion.h"

namespace iris {
namespace dx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * `ʕ
 *
 ----------------------------------------------------------------------
 * @param [out]	pvecOut	= o͈ʒu
 * @param [in]	pvecPos	= ʒu
 * @param [in]	pvecRot	= ]
 * @param [in]	distance= z
 * @param [in]	Slerp	= ԂNH[^jI̊Ԋup[^
 * @return	pvecOut
*//***********************************************************************/
D3DXVECTOR3* DXQuatSlerpCoord( D3DXVECTOR3* pvecOut, const D3DXVECTOR3* pvecPos, const D3DXVECTOR3* pvecRot, f32 distance, f32 slerp )
{
	D3DXQUATERNION	q1, q2, qSlerp;		// NH[^jIpϐ q1:ŏ̎p q2:Ō̎p
	D3DXMATRIX		matRot1, matRot2;	// ]̎pp}gbNX 1:ŏ@2;Ō
	D3DXMATRIX		matRot, matTrans;
	D3DXVECTOR3		v(0.0f, 0.0f, distance);

	// ŏ̎p
	D3DXMatrixRotationYawPitchRoll(&matRot1 , 0.0f , 0.0f , 0.0f);
	// Ō̎p
	D3DXMatrixRotationYawPitchRoll(	  &matRot2
									, (f32)D3DXToRadian(pvecRot->y)
									, (f32)D3DXToRadian(pvecRot->x)
									, (f32)D3DXToRadian(pvecRot->z));

	// }gbNXNH[^jI쐬
	D3DXQuaternionRotationMatrix( &q1, &matRot1 );
	D3DXQuaternionRotationMatrix( &q2, &matRot2 );

	// NH[^jI̕ԂƉ]}gbNX̎擾Ɛݒ
	D3DXQuaternionSlerp( &qSlerp, &q1, &q2, slerp );

	// NH[^jI]}gbNXɕϊ
	D3DXMatrixRotationQuaternion( &matRot, &qSlerp );

	// ]sJWɓKp
	D3DXVec3TransformCoord( pvecOut, &v, &matRot );

	// ʒuړ
	D3DXMatrixTranslation( &matTrans, pvecPos->x, pvecPos->y, pvecPos->z);
	D3DXVec3TransformCoord( pvecOut, pvecOut, &matTrans );

	return pvecOut;
}

}	// end of namespace dx
}	// end of namespace iris
