//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dmx_types.h
 * @brief		^` wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dmx_types_H_
#define INCG_IRIS_dmx_types_H_

//======================================================================
// include
#include "dmx_support.h"

#if		defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// struct
//--------------------------
// 2D Vector
//--------------------------
typedef struct D3DMXVECTOR2
{
#ifdef __cplusplus
public:
	D3DMXVECTOR2() {};
	D3DMXVECTOR2( CONST FLOAT *f )
	{
		x = f[0]; y = f[1];
	}
	D3DMXVECTOR2( CONST D3DMXVECTOR2& v)
		: x(v.x), y(v.y)
	{}
	D3DMXVECTOR2( FLOAT _x, FLOAT _y )
		: x(_x), y(_y)
	{}

	// casting
	operator		FLOAT* ()		{ return &x; }
	operator CONST	FLOAT* () const { return &x; }

	// assignment operators
	D3DMXVECTOR2& operator += ( CONST D3DMXVECTOR2& v)
	{
		x += v.x; y += v.y; return *this;
	}
	D3DMXVECTOR2& operator -= ( CONST D3DMXVECTOR2& v)
	{
		x -= v.x; y -= v.y; return *this;
	}
	D3DMXVECTOR2& operator *= ( FLOAT s)
	{
		x *= s; y *= s; return *this;
	}
	D3DMXVECTOR2& operator /= ( FLOAT s)
	{
		x /= s; y /= s; return *this;
	}

	// unary operators
	D3DMXVECTOR2 operator + () const	{ return *this; }
	D3DMXVECTOR2 operator - () const	{ D3DMXVECTOR2 r(-x, -y); return r; }

	// binary operators
	D3DMXVECTOR2 operator + ( CONST D3DMXVECTOR2& v) const	{ D3DMXVECTOR2 r(*this); r += v; return r; }
	D3DMXVECTOR2 operator - ( CONST D3DMXVECTOR2& v) const	{ D3DMXVECTOR2 r(*this); r -= v; return r; }
	D3DMXVECTOR2 operator * ( FLOAT s) const	{ D3DMXVECTOR2 r(*this); r *= s; return r; }
	D3DMXVECTOR2 operator / ( FLOAT s) const	{ D3DMXVECTOR2 r(*this); r /= s; return r; }

	friend D3DMXVECTOR2 operator * ( FLOAT s, CONST struct D3DMXVECTOR2& v)	{ D3DMXVECTOR2 r(s/v.x, s/v.y); return r; }

	BOOL operator == ( CONST D3DMXVECTOR2& v) const	{ return x == v.x && y == v.y; }
	BOOL operator != ( CONST D3DMXVECTOR2& v) const	{ return x != v.x || y != v.y; }

#endif //__cplusplus
	FLOAT x, y, z;
} D3DMXVECTOR2, *LPD3DMXVECTOR2;

//======================================================================
// typedef
typedef D3DMMATRIX				D3DMATRIX;
typedef D3DMCOLOR				D3DCOLOR;
typedef D3DMCOLORVALUE			D3DCOLORVALUE;
typedef D3DMFORMAT				D3DFORMAT;
typedef D3DMRENDERSTATETYPE		D3DRENDERSTATETYPE;
typedef D3DMTRANSFORMSTATETYPE	D3DTRANSFORMSTATETYPE;
typedef D3DMDISPLAYMODE			D3DDISPLAYMODE;
typedef D3DMXIMAGE_INFO			D3DXIMAGE_INFO;
typedef D3DMMULTISAMPLE_TYPE	D3DMULTISAMPLE_TYPE;

typedef D3DMATRIX		*LPD3DMATRIX;

typedef D3DMXVECTOR2	D3DXVECTOR2;
typedef D3DMXVECTOR3	D3DXVECTOR3;
typedef D3DMXVECTOR4	D3DXVECTOR4;
typedef D3DMXMATRIX		D3DXMATRIX;
typedef D3DMXVECTOR4	D3DXQUATERNION;

typedef D3DMXVECTOR3	*LPD3DXVECTOR3;
typedef D3DMXVECTOR4	*LPD3DXVECTOR4;
typedef D3DXMATRIX		*LPD3DXMATRIX;

typedef D3DMPOOL		D3DPOOL;
typedef D3DMBLEND		D3DBLEND;
typedef D3DMBLENDOP		D3DBLENDOP;
typedef D3DMCULL		D3DCULL;
typedef D3DMFOGMODE		D3DFOGMODE;
typedef D3DMLIGHTTYPE	D3DLIGHTTYPE;
typedef D3DMZBUFFERTYPE		D3DZBUFFERTYPE;
typedef D3DMSWAPEFFECT		D3DSWAPEFFECT;
typedef D3DMBACKBUFFER_TYPE	D3DBACKBUFFER_TYPE;

typedef D3DMADAPTER_IDENTIFIER	D3DADAPTER_IDENTIFIER;

typedef enum D3DSAMPLERSTATETYPE
{
    D3DSAMP_ADDRESSU = 1,
    D3DSAMP_ADDRESSV = 2,
    D3DSAMP_ADDRESSW = 3,
    D3DSAMP_BORDERCOLOR = 4,
    D3DSAMP_MAGFILTER = 5,
    D3DSAMP_MINFILTER = 6,
    D3DSAMP_MIPFILTER = 7,
    D3DSAMP_MIPMAPLODBIAS = 8,
    D3DSAMP_MAXMIPLEVEL = 9,
    D3DSAMP_MAXANISOTROPY = 10,
    D3DSAMP_SRGBTEXTURE = 11,
    D3DSAMP_ELEMENTINDEX = 12,
    D3DSAMP_DMAPOFFSET = 13,
    D3DSAMP_FORCE_DWORD = 0x7fffffff,
} D3DSAMPLERSTATETYPE, *LPD3DSAMPLERSTATETYPE;

#endif

#endif
