//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DMXMath.h
 * @brief		directX w֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DMXMath_H_
#define INCG_IRIS_DMXMath_H_

//======================================================================
// include
#include "../dmx_inchead.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// define
#define D3DXVec3Normalize		D3DMXVec3Normalize

#define D3DXMatrixRotationQuaternion

#define D3DXQuaternionSlerp

//======================================================================
// function
STATICINLINE D3DMXMATRIX*		D3DXMatrixIdentity(D3DMXMATRIX *pOut)		{ return D3DMXMatrixIdentity(pOut); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixIdentity(D3DMXMATRIXFXD *pOut)	{ return D3DMXMatrixIdentityFxd(pOut); }

STATICINLINE D3DMXMATRIX*		D3DXMatrixLookAtLH(D3DMXMATRIX* pOut, CONST D3DMXVECTOR3 *pEye
												   , CONST D3DMXVECTOR3 *pAt, CONST D3DMXVECTOR3 *pUp)			{ return D3DMXMatrixLookAtLH(pOut, pEye, pAt, pUp); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixLookAtLH(D3DMXMATRIXFXD* pOut, CONST D3DMXVECTOR3FXD *pEye
												   , CONST D3DMXVECTOR3FXD *pAt, CONST D3DMXVECTOR3FXD *pUp)	{ return D3DMXMatrixLookAtLHFxd(pOut, pEye, pAt, pUp); }

STATICINLINE D3DMXMATRIX*		D3DXMatrixRotationYawPitchRoll(D3DMXMATRIX *pOut
															   , FLOAT Yaw, FLOAT Pitch, FLOAT Roll)	{ return D3DMXMatrixRotationYawPitchRoll(pOut, Yaw, Pitch, Roll); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixRotationYawPitchRoll(D3DMXMATRIXFXD *pOut
															   , FIXED Yaw, FIXED Pitch, FIXED Roll)	{ return D3DMXMatrixRotationYawPitchRollFxd(pOut, Yaw, Pitch, Roll); }


STATICINLINE D3DMXMATRIX*		D3DXMatrixPerspectiveFovLH(D3DMXMATRIX *pOut
														   , FLOAT fovy, FLOAT Aspect, FLOAT zn, FLOAT zf)	{ return D3DMXMatrixPerspectiveFovLH(pOut, fovy, Aspect, zn, zf); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixPerspectiveFovLH(D3DMXMATRIXFXD *pOut
														   , FIXED fovy, FIXED Aspect, FIXED zn, FIXED zf)	{ return D3DMXMatrixPerspectiveFovLHFxd(pOut, fovy, Aspect, zn, zf); }

STATICINLINE D3DMXMATRIX*		D3DXMatrixTranslation(D3DMXMATRIX *pOut, FLOAT x, FLOAT y, FLOAT z)			{ return D3DMXMatrixTranslation(pOut, x, y, z); }
STATICINLINE D3DMXMATRIXFXD*	D3DXMatrixTranslation(D3DMXMATRIXFXD *pOut, FIXED x, FIXED y, FIXED z)		{ return D3DMXMatrixTranslationFxd(pOut, x, y, z); }

STATICINLINE D3DMXVECTOR4*		D3DXVec3TransformCoord(D3DMXVECTOR4* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM) { return D3DMXVec3Transform(pOut, pV, pM); }
STATICINLINE D3DMXVECTOR4FXD*	D3DXVec3TransformCoord(D3DMXVECTOR4FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM) { return D3DMXVec3TransformFxd(pOut, pV, pM); }
D3DMXVECTOR3*		D3DXVec3TransformCoord(D3DMXVECTOR3* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM);
D3DMXVECTOR3FXD*	D3DXVec3TransformCoord(D3DMXVECTOR3FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM);

STATICINLINE D3DMXVECTOR4*		D3DXVec3Transform(D3DMXVECTOR4* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM) { return D3DMXVec3Transform(pOut, pV, pM); }
STATICINLINE D3DMXVECTOR4FXD*	D3DXVec3Transform(D3DMXVECTOR4FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM) { return D3DMXVec3TransformFxd(pOut, pV, pM); }
D3DMXVECTOR3*		D3DXVec3Transform(D3DMXVECTOR3* pOut, const D3DMXVECTOR3* pV, const D3DMXMATRIX* pM);
D3DMXVECTOR3FXD*	D3DXVec3Transform(D3DMXVECTOR3FXD* pOut, const D3DMXVECTOR3FXD* pV, const D3DMXMATRIXFXD* pM);

D3DXVECTOR3*		D3DXVec3Project(D3DMXVECTOR3 *pOut, CONST D3DMXVECTOR3 *pV, CONST D3DMVIEWPORT *pViewport
												, CONST D3DMXMATRIX *pProjection, CONST D3DMXMATRIX *pView, CONST D3DMXMATRIX *pWorld);
D3DXVECTOR3*		D3DXVec3Unproject(D3DMXVECTOR3 *pOut, CONST D3DMXVECTOR3 *pV, CONST D3DMVIEWPORT *pViewport
												, CONST D3DMXMATRIX *pProjection, CONST D3DMXMATRIX *pView, CONST D3DMXMATRIX *pWorld);


D3DXQUATERNION *	D3DXQuaternionRotationMatrix(D3DXQUATERNION *pOut, CONST D3DMXMATRIX *pMa);

#endif

#endif
