//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		dmx_texture.h
 * @brief		direct mobile texture ֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_dmx_texture_H_
#define INCG_IRIS_dmx_texture_H_

//======================================================================
// include
#include "../dmx_inchead.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)

//======================================================================
// define
#ifdef UNICODE
#  define D3DXCreateTextureFromFileEx	D3DXCreateTextureFromFileExW
#else
#  define D3DXCreateTextureFromFileEx	D3DXCreateTextureFromFileExA
#endif

//======================================================================
// function
STATICINLINE HRESULT WINAPI
    D3DXCreateTextureFromFileExA(
        LPDIRECT3DMOBILEDEVICE    pDevice,
        LPCSTR                    pSrcFile,
        UINT                      Width,
        UINT                      Height,
        UINT                      MipLevels,
        DWORD                     Usage,
        D3DMFORMAT                Format,
        D3DMPOOL                  Pool,
        DWORD                     Filter,
        DWORD                     MipFilter,
        D3DMCOLOR                 ColorKey,
        D3DMXIMAGE_INFO*          pSrcInfo,
        PALETTEENTRY*             pPalette,
        LPDIRECT3DMOBILETEXTURE*  ppTexture)
{
	WCHAR path[MAX_PATH];
	mbstowcs(path, pSrcFile, MAX_PATH);
	return D3DMXCreateTextureFromFileExW(pDevice, path, Width, Height, MipLevels
		, Usage, Format, Pool, Filter, MipFilter
		, ColorKey, pSrcInfo, pPalette, ppTexture);
}

STATICINLINE HRESULT WINAPI
    D3DXCreateTextureFromFileExW(
        LPDIRECT3DMOBILEDEVICE    pDevice,
        LPCWSTR                   pSrcFile,
        UINT                      Width,
        UINT                      Height,
        UINT                      MipLevels,
        DWORD                     Usage,
        D3DMFORMAT                Format,
        D3DMPOOL                  Pool,
        DWORD                     Filter,
        DWORD                     MipFilter,
        D3DMCOLOR                 ColorKey,
        D3DMXIMAGE_INFO*          pSrcInfo,
        PALETTEENTRY*             pPalette,
        LPDIRECT3DMOBILETEXTURE*  ppTexture)
{
	return D3DMXCreateTextureFromFileExW(pDevice, pSrcFile, Width, Height, MipLevels
		, Usage, Format, Pool, Filter, MipFilter
		, ColorKey, pSrcInfo, pPalette, ppTexture);
}

#endif

#endif
