//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXInupt.cpp
 * @brief		directX ̓foCXǗt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_DXInupt_CPP_

//======================================================================
// include
#include "../DXDirectInput.h"
#include "DXInput.h"
#include "../DXLib.h"
#include "../DXError.h"

#include "iris_debug.h"

namespace iris {
namespace dx
{

//======================================================================
// link
#pragma comment (lib, "dxguid.lib")

//======================================================================
// define
// L[foCX̉
#define DXINPUT_SAFE_RELEASE( p )	{ if(p) { p->Unacquire(); p->Release(); p = nullptr; } }

//======================================================================
// declare
// WCpbhfoCX̗񋓃R[obN
static BOOL CALLBACK __EnumJoypadCallback(LPCDIDEVICEINSTANCE did, VOID* ref);

//======================================================================
// class

//======================================================================
// IDXInput
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDXInput::CDXInput(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDXInput::~CDXInput(void)
{
	Release();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CDXInput::Initialize(void)
{
	if( !LoadDInputLib() ) return false;
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CDXInput::Release(void)
{
	IDXInputDevice* p = GetObservers();
	while( p != nullptr )
	{
		EraseDevice(p);
		p = GetObservers();
	}
}

/**********************************************************************//**
 *
 * foCXǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= ǉfoCX
*//***********************************************************************/
void CDXInput::RegisterDevice(IDXInputDevice* pDevice)
{
	if( pDevice == nullptr ) return;
	AttachObserver(pDevice);
}

/**********************************************************************//**
 *
 * foCX폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pDevice	= 폜foCX
*//***********************************************************************/
void CDXInput::EraseDevice(IDXInputDevice* pDevice)
{
	if( pDevice == nullptr ) return;
	pDevice->Release();
	DetachObserver(pDevice);
}

/**********************************************************************//**
 *
 * L[XV
 *
*//***********************************************************************/
void CDXInput::Update(void)
{
	IDXInputDevice* p = GetObservers();
	while( p != nullptr )
	{
		p->Update();
		p = p->GetNext();
	}
}

/**********************************************************************//**
 *
 * L[{[hfoCX쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	pDevice	= foCXNX
 * @return	
*//***********************************************************************/
bool CDXInput::CreateKeyDevice(HWND hWnd, IDXInputDevice* pDevice)
{
	if( pDevice == nullptr ) return false;
	if( !CDirectInput::GetInstance().IsValid() ) return false;
	// foCX쐬
	HRESULT hr = CDirectInput::GetInstance()->CreateDevice(GUID_SysKeyboard, &pDevice->m_pDevice, nullptr);
	if( FAILED(hr) ) { DX_ERROR(hr); return false; }

	// foCXL[{[hɐݒ
	hr = pDevice->m_pDevice->SetDataFormat(&c_dfDIKeyboard);
	if( FAILED(hr) ) { DX_ERROR(hr); return false; }

	// x̐ݒ
	hr = pDevice->m_pDevice->SetCooperativeLevel(hWnd, DISCL_FOREGROUND | DISCL_NONEXCLUSIVE);
	if( FAILED(hr) ) { DX_ERROR(hr); return false; }

	return true;
}

/**********************************************************************//**
 *
 * WCpbhfoCX쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	pDevice	= foCXNX
 * @return	
*//***********************************************************************/
bool CDXInput::CreateJoyDevice(HWND hWnd, IDXInputDevice* pDevice)
{
	if( pDevice == nullptr ) return false;
	if( !CDirectInput::GetInstance().IsValid() ) return false;
	HRESULT hr = CDirectInput::GetInstance()->EnumDevices(DI8DEVCLASS_GAMECTRL
								, __EnumJoypadCallback
								, pDevice , DIEDFL_ATTACHEDONLY);
	// WCpbhT
	if(FAILED(hr)) { DX_ERROR(hr); return false; }
	if(pDevice->m_pDevice == nullptr ) return false;

	// foCXWCpbhɐݒ
	hr = pDevice->m_pDevice->SetDataFormat(&c_dfDIJoystick2);
	if(FAILED(hr)) { DX_ERROR(hr); return false; }

	// x̐ݒ
	hr = pDevice->m_pDevice->SetCooperativeLevel(hWnd , DISCL_FOREGROUND | DISCL_EXCLUSIVE);
	if(FAILED(hr)) { DX_ERROR(hr); return false; }

	return true;
}

/**********************************************************************//**
 *
 * WCpbhfoCX񋓗p̃R[obN֐
 *
 ----------------------------------------------------------------------
 * @param [in]	did		= 
 * @param [in]	pDevice	= foCXNX
*//***********************************************************************/
BOOL CALLBACK CDXInput::EnumJoypadCallback(LPCDIDEVICEINSTANCE did, IDXInputDevice* pDevice)
{
	HRESULT hr = CDirectInput::GetInstance()->CreateDevice(did->guidInstance , &pDevice->m_pDevice , nullptr);
	if(FAILED(hr))
	{
		DX_ERROR(hr);
		return DIENUM_CONTINUE;	// ̃foCX
	}
	return DIENUM_STOP;	// foCX̗񋓂𒆎~
}
BOOL CALLBACK __EnumJoypadCallback(LPCDIDEVICEINSTANCE did, VOID* ref)
{
	IDXInputDevice* p = pointer_cast<IDXInputDevice*>(ref);
	CDXInput* input = dcast<CDXInput*>(p->GetSubject());
	if( input == nullptr ) return DIENUM_STOP;
	return input->EnumJoypadCallback(did, p);
}

}	// end of namespace dx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../win/debug/unittest/WXDebugUnitTest.h"
#include "DXVPad.h"
#include "iris_using.h"
#include <tchar.h>

//======================================================================
// class
class CDXInputUnitTest : public iris::wx::dbg::CUnitTest<CDXInputUnitTest>
{
public:
	CDXInput		m_input;
	CDXKeyDevice	m_key;
	CDXVPad			m_pad;

public:
	virtual void OnPaint(HWND hWnd)
	{
		RECT rc;
		GetClientRect(hWnd, &rc);
		int cx = (rc.right-rc.left)/2 - 10;
		int cy = (rc.bottom-rc.top)/2 - 15;
		PAINTSTRUCT ps;
		HDC hdc = BeginPaint(hWnd, &ps);

		if( m_key.Trig(DIK_UP) )
			TextOut(hdc, cx, cy-15, TEXT("1"), 1 );
		else if( m_key.Hold(DIK_UP) )
			TextOut(hdc, cx, cy-15, TEXT("0"), 1 );
		else if( m_key.Free(DIK_UP) )
			TextOut(hdc, cx, cy-15, TEXT("2"), 1 );
		else
			TextOut(hdc, cx, cy-15, TEXT("-"), 1 );

		if( m_key.Trig(DIK_DOWN) )
			TextOut(hdc, cx, cy+15, TEXT("1"), 1 );
		else if( m_key.Hold(DIK_DOWN) )
			TextOut(hdc, cx, cy+15, TEXT("0"), 1 );
		else if( m_key.Free(DIK_DOWN) )
			TextOut(hdc, cx, cy+15, TEXT("2"), 1 );
		else
			TextOut(hdc, cx, cy+15, TEXT("-"), 1 );

		if( m_key.Trig(DIK_LEFT) )
			TextOut(hdc, cx-15, cy, TEXT("1"), 1 );
		else if( m_key.Hold(DIK_LEFT) )
			TextOut(hdc, cx-15, cy, TEXT("0"), 1 );
		else if( m_key.Free(DIK_LEFT) )
			TextOut(hdc, cx-15, cy, TEXT("2"), 1 );
		else
			TextOut(hdc, cx-15, cy, TEXT("-"), 1 );

		if( m_key.Trig(DIK_RIGHT) )
			TextOut(hdc, cx+15, cy, TEXT("1"), 1 );
		else if( m_key.Hold(DIK_RIGHT) )
			TextOut(hdc, cx+15, cy, TEXT("0"), 1 );
		else if( m_key.Free(DIK_RIGHT) )
			TextOut(hdc, cx+15, cy, TEXT("2"), 1 );
		else
			TextOut(hdc, cx+15, cy, TEXT("-"), 1 );

		TCHAR text[64];
		wsprintf(text, TEXT("%08x"), m_pad.Hold() );
		TextOut(hdc, 0, 0, text, (int)_tcslen(text) );

		EndPaint(hWnd, &ps);
	}
public:
	static void IdleFunc(void* arg);
};


//======================================================================
// test
IRIS_UNITTEST_F(CDXInputUnitTest, Func)
{
	RECT src = {0, 0, 320, 240};

	// EBhEg̒
	AdjustWindowRectEx(
		&src,
		WINDOW_STYLE,
		FALSE,
		WINDOW_STYLEEX );

	// EBhE̍쐬
	HWND hWnd = wx::dbg::CreateUnitTestWindow(WINDOW_STYLEEX
		, m_TestName, m_TestName, WINDOW_STYLE, src.right, src.bottom
		, DrawTestWindowProc);

	// EBhE̍쐬Ɏs
	if( hWnd == nullptr )
		return;

	// EBhE`
	ShowWindow(hWnd, SW_SHOW);
	// őOʂ
	SetForegroundWindow(hWnd);

	// EBhE̍XV
	UpdateWindow(hWnd);

	m_input.Initialize();
	m_input.RegisterDevice(&m_key);
	m_input.CreateKeyDevice(hWnd, &m_key);
	CKeyState* pKey = nullptr;
	pKey = m_key.RegisterKey<CDXJoyKeyState>(DIK_UP		, DIK_UP);
	m_pad.SetKey(eDXVPAD_BUTTON_UP	, pKey);
	pKey = m_key.RegisterKey<CDXJoyKeyState>(DIK_DOWN	, DIK_DOWN);
	m_pad.SetKey(eDXVPAD_BUTTON_DOWN	, pKey);
	pKey = m_key.RegisterKey<CDXJoyKeyState>(DIK_LEFT	, DIK_LEFT);
	m_pad.SetKey(eDXVPAD_BUTTON_LEFT	, pKey);
	pKey = m_key.RegisterKey<CDXJoyKeyState>(DIK_RIGHT	, DIK_RIGHT);
	m_pad.SetKey(eDXVPAD_BUTTON_RIGHT	, pKey);

	wx::dbg::UnitTestMainLoop(hWnd, IdleFunc, hWnd);
}

// ACh
void CDXInputUnitTest::IdleFunc(void* arg)
{
	CDXInputUnitTest* pUT = GetCurrent();
	CDXInput& input = pUT->m_input;
	CDXVPad& pad = pUT->m_pad;

	input.Update();
	pad.Update();
	InvalidateRect((HWND)arg, nullptr, FALSE);
	Sleep(1);
}

#endif	// (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
