//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXKeyState.h
 * @brief		directX ̓L[ԃt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXKeyState_H_
#define INCG_IRIS_DXKeyState_H_

//======================================================================
// include
#include "fnd/pad/FndKeyState.h"
#include "../dx_inchead.h"
#include "../DXLib.h"

#if	defined(_IRIS_SUPPORT_DXMOBILE)
#error not support.
#endif

namespace iris {
namespace dx
{

//======================================================================
// declare
class CKeyState;
class CDXJoyKeyState;
class CDXJoyStickState;

//======================================================================
// types
typedef CKeyState*		LPKeyState;		//!< L[ԃNX|C^[^
typedef CDXJoyKeyState*	LPDXJoyKeyState;//!< WCXpbhNX|C^[^

//======================================================================
// class

//======================================================================
//! L[NX
class CKeyState : public fnd::IKeyState
{
protected:
	bool	m_bHold;	//!< 
	bool	m_bPrev;	//!< O񉟉
	bool	m_bRept;	//!< s[g
	f32		m_fCnt;		//!< s[gJE^
	BYTE	m_Key;		//!< L[
public:
	// RXgN^
	explicit CKeyState(BYTE key);
	// fXgN^
	//virtual ~CKeyState(void) {}
public:
	// XV
	virtual void	Update(bool hold, f32 rept_first, f32 rept_loop);
	/// NA
	virtual void	Clear(void)	{ m_bHold = false; m_bPrev = false; m_bRept = false; m_fCnt = 0.0f; }
public:
	/// 
	virtual bool	Hold(void)	const	{ return m_bHold; }
	/// u
	virtual bool	Trig(void)	const	{ return (m_bHold && !m_bPrev); }
	/// u
	virtual bool	Free(void)	const	{ return (m_bPrev && !m_bHold); }
	/// s[g
	virtual bool	Rept(void)	const	{ return m_bRept; }
	/// O
	virtual bool	Prev(void)	const	{ return m_bPrev; }
public:
	/// L[ݒ
	virtual void	SetKey(BYTE key)		{ m_Key = key; }
	/// L[擾
	virtual BYTE	GetKey(void)	const	{ return m_Key; }
};

//======================================================================
//! WCpbhgL[ԃNX
class CDXJoyKeyState : public CKeyState
{
public:
	/// RXgN^
	explicit CDXJoyKeyState(BYTE key) : CKeyState(key) {}
	/// fXgN^
	virtual ~CDXJoyKeyState(void) {}
public:
	/// foCXԍXVʒm
	virtual void	UpdateDevice(LPDIRECTINPUTDEVICE8 /*pDevice*/)	{}
	/// WCpbhXV
	virtual bool	JoyUpdate(const DIJOYSTATE2* /*pJoyState*/, f32 /*rept_first*/, f32 /*rept_loop*/ ) { return false; }
	/// L[Ԃ
	virtual void*	GetKeyState(void)	{ return nullptr; }
};

//======================================================================
//! WCXeBbNL[ԃNX
class CDXJoyStickState : public CDXJoyKeyState
{
protected:
	D3DXVECTOR3	m_Stick;	//!< -1.0f~1.0f
	D3DXVECTOR3	m_Range;	//!< ͔͈
	DWORD		m_OffsetX;	//!< DIJOYSTATE2 offset (DIJOFS_***)
	DWORD		m_OffsetY;	//!< DIJOYSTATE2 offset (DIJOFS_***)
	DWORD		m_OffsetZ;	//!< DIJOYSTATE2 offset (DIJOFS_***)
public:
	// RXgN^
	explicit CDXJoyStickState(BYTE key);
	// fXgN^
	virtual ~CDXJoyStickState(void);
public:
	// foCXԍXVʒm
	virtual void	UpdateDevice(LPDIRECTINPUTDEVICE8 pDevice);
	// WCpbhXV
	virtual bool	JoyUpdate(const DIJOYSTATE2* pJoyState, f32 rept_first, f32 rept_loop );
	// L[Ԃ
	virtual void*	GetKeyState(void)			{ return (void*)&m_Stick; }
	//
	const	D3DXVECTOR3*	GetStick(void) const	{ return &m_Stick; }
public:
	// offset̐ݒ
	virtual void	SetOffsets(DWORD x, DWORD y, DWORD z)	{ m_OffsetX = x; m_OffsetY = y; m_OffsetZ = z; }
	virtual void	SetOffsetX(DWORD offset)				{ m_OffsetX = offset; }
	virtual void	SetOffsetY(DWORD offset)				{ m_OffsetY = offset; }
	virtual void	SetOffsetZ(DWORD offset)				{ m_OffsetZ = offset; }
	virtual DWORD	SetOffsetX(void)						{ return m_OffsetX; }
	virtual DWORD	SetOffsetY(void)						{ return m_OffsetY; }
	virtual DWORD	SetOffsetZ(void)						{ return m_OffsetZ; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif
