//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMusic.h
 * @brief		directX Music t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMusic_H_
#define INCG_IRIS_DXMusic_H_

//======================================================================
// include
#include "../dx_inchead.h"
#ifdef _IRIS_DX_SUPPORT_DXMUSIC

#include <dmusici.h>
#include "../../win/com/WXComObj.h"

//======================================================================
// define
// DirectMusic̃o[W
#ifndef DIRECTMUSIC_VERSION
#define DIRECTMUSIC_VERSION ( 0x0900 )
#endif

namespace iris {
namespace dx
{

//======================================================================
// class
//! DirectMusicNX
class CDXMusic : public IIrisObject
{
	typedef wx::CComObj<IDirectMusicLoader8>		DirectMusicLoader;
	typedef wx::CComObj<IDirectMusicPerformance8>	DirectMusicPerformance;
	typedef wx::CComObj<IDirectMusicComposer8>		DirectMusicComposer;
protected:
	DirectMusicLoader		m_pLoader;		//!< [_[
	DirectMusicPerformance	m_pPerformance;	//!< 
	DirectMusicComposer		m_pComposer;	//!< R|[U[

public:
	// RXgN^
	CDXMusic(void);
	// fXgN^
	virtual ~CDXMusic(void);

public:
	// 
	virtual HRESULT Initialize(HWND hWnd = nullptr
		, DWORD dwPChannelCount = 128
		, DWORD dwFlags = DMUS_APATH_SHARED_STEREOPLUSREVERB
		, IDirectSound* pDS = nullptr );

	// 
	virtual void Release(void);
public:
	//t@C烍[h
	virtual HRESULT LoadSegmentFromFile(IDirectMusicSegment8** ppSegment, LPWSTR lpFileName);

public:
	// }X^[{[̐ݒ
	virtual HRESULT SetMasterVolume(LONG lVolume);
	// }X^[{[̎擾
	virtual HRESULT GetMasterVolume(PLONG plVolume) const;
	// }X^[e|̐ݒ
	virtual HRESULT SetMasterTempo(f32 fTempo);
	// }X^[e|̎擾
	virtual HRESULT GetMasterTempo(f32 *pfTempo) const;

public:
	// pX̐ݒ
	HRESULT SetSearchDirectory(LPWSTR lpPath, BOOL bClear = TRUE);
	// gpȂȂIuWFNgLbV폜
	void CollectGarbage(void);

public:
	// SẲt̒~
	HRESULT StopAll(void);

public:
	// W̃I[fBIpX̍쐬
	HRESULT CreateStandardAudioPath(IDirectMusicAudioPath** ppAudioPath
		, DWORD dwType = DMUS_APATH_SHARED_STEREOPLUSREVERB
		, DWORD dwPChannelCount = 128
		, BOOL bActivate = TRUE);
public:
	// X[YȋȂ̕ύX
	HRESULT AutoTransition(IDirectMusicSegment *pSegment = nullptr
		, WORD wCommand = DMUS_COMMANDT_ENDANDINTRO
		, DWORD dwFlags = DMUS_COMPOSEF_MEASURE);

public:
	//! IDirectMusicLoader8̎擾
	DirectMusicLoader&			GetLoader(void)			{ return m_pLoader; }
	//! IDirectMusicPerformance8̎擾
	DirectMusicPerformance&		GetPerformance(void)	{ return m_pPerformance; }
	//! IDirectMusicComposer8̎擾
	DirectMusicComposer&		GetComposer(void)		{ return m_pComposer; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	// #ifdef _IRIS_DX_SUPPORT_DXMUSIC
#endif
