//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		DXMusicSegment.h
 * @brief		directX MusicSegment t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_DXMusicSegment_H_
#define INCG_IRIS_DXMusicSegment_H_

//======================================================================
// include
#include "../dx_inchead.h"

#ifdef _IRIS_DX_SUPPORT_DXMUSIC

#include <dmusici.h>
#include "../../win/com/WXComObj.h"

namespace iris {
namespace dx
{
//======================================================================
// class
/// ZOgNX
class CDXMusicSegment : public IIrisObject
{
	typedef wx::CComObj<IDirectMusicPerformance8>	DirectMusicPerformance;
	typedef wx::CComObj<IDirectMusicSegment8>		DirectMusicSegment;
	typedef wx::CComObj<IDirectMusicAudioPath8>		DirectMusicAudioPath;
protected:
	DirectMusicPerformance	m_pPerformance;	//!< IDirectMusicPerformance8IuWFNg
	IDirectMusicSegment8*	m_pSegment;		//!< IDirectMusicSegment8IuWFNg
	IDirectMusicAudioPath8*	m_pAudioPath;	//!< IDirectMusicAudioPath8IuWFNg

public:
	// RXgN^
	CDXMusicSegment(IDirectMusicPerformance8 *pPerformance = nullptr
		, IDirectMusicSegment8 *pSegment = nullptr);

	// fXgN^
	virtual ~CDXMusicSegment(void);

public:
	// tJn
	virtual HRESULT PlayEx(DWORD dwFlags = DMUS_SEGF_SECONDARY, IDirectMusicAudioPath8* pAudioPath = nullptr);
	// t~
	virtual HRESULT StopEx(DWORD dwFlags = 0);
	// tׂ
	virtual HRESULT IsPlaying(void) const;

public:
	// g`̃_E[h
	virtual HRESULT Download(IDirectMusicAudioPath8* pAudioPath = nullptr);
	// g`̃A[h
	virtual HRESULT Unload(IDirectMusicAudioPath8* pAudioPath = nullptr);

public:
	// [v񐔂̐ݒ
	HRESULT SetRepeats(DWORD dwRepeats);
	// [v񐔂̎擾
	HRESULT GetRepeats(LPDWORD pdwRepeats) const;
	// t̊Jnʒu̐ݒ
	HRESULT SetStartPoint(LONG lStart);
	// t̊Jnʒu̎擾
	HRESULT GetStartPoint(PLONG plStart) const;
	// Ȃ̒̐ݒ
	HRESULT SetLength(LONG lLength);
	// Ȃ̒̎擾
	HRESULT GetLength(PLONG plLength) const;

public:
	// IDirectMusicPerformance8̐ݒ
	void SetPerformance(IDirectMusicPerformance8 *pPerformance) { m_pPerformance = pPerformance; }
	// IDirectMusicSegment8̎擾
	IDirectMusicSegment8**		GetSegment(void)	{ return &m_pSegment; }
	//IDirectMusicAudioPath8̎擾
	IDirectMusicAudioPath8**	GetAudioPath(void)	{ return &m_pAudioPath; }
};

}	// end of namespace dx
}	// end of namespace iris

#endif	// #ifdef _IRIS_DX_SUPPORT_DXMUSIC
#endif
