//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXApplication.h
 * @brief		AvP[VNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXApplication_H_
#define INCG_IRIS_WXApplication_H_

//======================================================================
// include
#include "WXWindow.h"
#include "fnd/container/FndSingleton.h"
#include "../io/WXAccelerator.h"

namespace iris {
namespace wx
{

//======================================================================
// define
// App̃Cxg
#define __IrisAppEventFuncName( name ) OnApp##name
// App̃Cxg
#define __IrisAppEventFunc( name )					\
	virtual LRESULT __IrisAppEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)
// App̃Cxg֐̈warning̏p
#define __IrisAppEventUnusedVariable()				\
	IRIS_UNUSED_VARIABLE(hWnd);	IRIS_UNUSED_VARIABLE(wParam); IRIS_UNUSED_VARIABLE(lParam)
// App̃Cxg`
#define __IrisAppEventFuncImpl( cls, name )			\
	LRESULT cls::__IrisAppEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)

//======================================================================
// class
/**
 *	@class		iris::wx::CApplication
 *	@brief		AvP[VNX
*/
class CApplication : virtual public CWindow
{
protected:

#ifndef _IRIS_WX_DLG_BASE
	static CApplication* s_pApp;	//!< VOg
#endif

	TCHAR			m_AppName[256];		//!< AvP[V
	HINSTANCE		m_hInst;			//!< CX^Xnh
	CAccelerator	m_Accel;			//!< ANZ[^L[
	ATOM			m_Atom;				//!< Ag

#ifdef _IRIS_WX_CHECKMULTIBOOT
	HANDLE	m_hMutex;				//!< dNh~pmutex
#endif

public:

	// RXgN^
	CApplication(LPCTSTR AppName);
	// fXgN^
	virtual ~CApplication(void);

	// AvP[V̎s
	virtual void RunSync(void);
	virtual void RunAsync(void);
	/// AvP[V̎s
	inline	void Run(bool bAsync=false)	{ if( bAsync ) RunAsync(); else RunSync(); }	// Âo[WƂ̌݊̂

	// 
	virtual bool Init(void);
	// I
	virtual void Term(void);
	// ֐
	virtual void Transaction(void)	{}
	// bZ[WO
	virtual BOOL PreTranslateMessage(LPMSG msg);

public:
    // EBhEvV[W
    static LRESULT CALLBACK AppWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
protected:
	// EBhEvV[W
	virtual LRESULT WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	virtual LRESULT DefWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

public:
	virtual bool CheckMultiBoot(void);

protected:
	// EBhE쐬
	virtual HWND	OnCreateWindow(void);
	// 
	virtual bool	OnInit(void);

protected:
	// Cxgnh
	// 0ԂƃftHgEBhEvV[WR[Ȃ
	__IrisAppEventFunc(Create)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Destroy)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Move)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Size)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Activate)		{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(SetFocus)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(KillFocus)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Enable)			{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(Paint)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Close)			{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(EraseBkGnd)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(ShowWindow)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SetCursor)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MouseActivate)	{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(ChildActivate)	{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(GetMinMaxInfo)	{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(DrawItem)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MeasureItem)		{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(Notify)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Help)			{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(KeyDown)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(KeyUp)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Char)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(DeadChar)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SysKeyDown)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SysKeyUp)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SysChar)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SysDeadChar)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(KeyLast)			{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(Command)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(SysCommand)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(Timer)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(HScroll)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(VScroll)			{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MenuSelect)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MenuChar)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(EnterMenuLoop)	{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(ExitMenuLoop)	{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(MouseMove)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(LButtonDown)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(LButtonUp)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(LButtonDblClk)	{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(RButtonDown)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(RButtonUp)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(RButtonDblClk)	{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MButtonDown)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MButtonUp)		{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(MButtonDblClk)	{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(DropFiles)		{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(DrawClipboard)	{ __IrisAppEventUnusedVariable(); return 1; }

	__IrisAppEventFunc(QueryendSession)	{ __IrisAppEventUnusedVariable(); return 1; }
	__IrisAppEventFunc(UserChanged)		{ __IrisAppEventUnusedVariable(); return 1; }

protected:
	virtual bool RegisterClassEntry(WNDPROC pWndProc, LPCTSTR ClassName, HBRUSH hbrBack);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
