//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCurrentDirectory.cpp
 * @brief		CurrentDirectory t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCurrentDirectory_CPP_

//======================================================================
// include
#include "WXCurrentDirectory.h"
#include "iris_debug.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTCurrentDirectory<CHARTYPE_>::CTCurrentDirectory(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTCurrentDirectory<CHARTYPE_>::~CTCurrentDirectory(void)
{
	PopAll();
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	dwLength	= o͕
 * @param [out]	lpPath		= o̓obt@
 * @return	
*//***********************************************************************/
template<>
BOOL CTCurrentDirectory<CHAR>::GetPath(DWORD dwLength, _Mylpstr lpPath) const
{
	return IRIS_TO_BOOL(::GetCurrentDirectoryA(dwLength, lpPath));
}
template<>
BOOL CTCurrentDirectory<WCHAR>::GetPath(DWORD dwLength, _Mylpstr lpPath) const
{
	return IRIS_TO_BOOL(::GetCurrentDirectoryW(dwLength, lpPath));
}

/**********************************************************************//**
 *
 * JgfBNgpX̎擾
 *
 -----------------------------------------------------------------------
 * @return	JgfBNg
*//***********************************************************************/
template<typename CHARTYPE_>
CHARTYPE_* CTCurrentDirectory<CHARTYPE_>::GetPath(void) const
{
	static _Mychar path[MAX_PATH];
	GetPath(MAX_PATH, path);
	return path;
}

/**********************************************************************//**
 *
 * JgfBNgpX̐ݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszPath	= pX
 * @return	
*//***********************************************************************/
template<>
BOOL CTCurrentDirectory<CHAR>::SetPath(_Mylpcstr lpszPath)
{
	return ::SetCurrentDirectoryA(lpszPath);
}
template<>
BOOL CTCurrentDirectory<WCHAR>::SetPath(_Mylpcstr lpszPath)
{
	return ::SetCurrentDirectoryW(lpszPath);
}

/**********************************************************************//**
 *
 * ݂̐ݒޔĐݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpDirectory	= VJgfBNg
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTCurrentDirectory<CHARTYPE_>::Push(_Mylpcstr lpDirectory)
{
	IRIS_ASSERT( lpDirectory != nullptr );
	_Mychar path[MAX_PATH];
	GetPath(MAX_PATH, path);
	m_Store.push_back(path);
	return SetPath(lpDirectory);
}

/**********************************************************************//**
 *
 * ޔݒP߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTCurrentDirectory<CHARTYPE_>::Pop(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = m_Store.back();
	m_Store.pop_back();
	return SetPath(path.c_str());
}

/**********************************************************************//**
 *
 * ޔݒׂĖ߂
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
template<typename CHARTYPE_>
BOOL CTCurrentDirectory<CHARTYPE_>::PopAll(void)
{
	if( m_Store.size() == 0 ) return FALSE;
	_Mystring path = *m_Store.begin();
	m_Store.clear();
	return SetPath(path.c_str());
}

template class CTCurrentDirectory<CHAR>;
template class CTCurrentDirectory<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris
