//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCurrentDirectory.h
 * @brief		CurrentDirectory t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXCurrentDirectory_H_
#define INCG_IRIS_WXCurrentDirectory_H_

//======================================================================
// include
#include "iris_object.h"
#include "ml/iml_type_select.hpp"
#include <vector>
#include <string>

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
template<typename CHARTYPE_>class CTCurrentDirectory;

//======================================================================
// typedef
typedef CTCurrentDirectory<CHAR>	CCurrentDirectoryA;
typedef CTCurrentDirectory<WCHAR>	CCurrentDirectoryW;
typedef CTCurrentDirectory<TCHAR>	CCurrentDirectory;

//======================================================================
// class
/**
 * @brief	}`oCg JgfBNgNX
*/
template<typename CHARTYPE_>
class CTCurrentDirectory : public IIrisObject
{
	typedef CHARTYPE_				_Mychar;
	typedef CHARTYPE_				*_Mylpstr;
	typedef const CHARTYPE_			*_Mylpcstr;

	typedef typename iml::type_select<(sizeof(_Mychar) == sizeof(WCHAR)), std::wstring, std::string>::type _Mystring;
	typedef std::vector<_Mystring>	_Myvec;
	typedef CTCurrentDirectory<CHARTYPE_>	_Myt;
private:
	_Myvec	m_Store;	//!< ޔ
public:
	// RXgN^
	CTCurrentDirectory(void);
	// fXgN^
	~CTCurrentDirectory(void);

public:
	// JgfBNgpX̎擾
	BOOL		GetPath(DWORD dwLength, _Mylpstr lpPath)	const;
	_Mylpstr	GetPath(void)	const;
	// JgfBNgpX̐ݒ
	BOOL		SetPath(_Mylpcstr lpszPath);
public:
	// ݂̐ݒޔĐݒ
	BOOL		Push(_Mylpcstr lpDirectory);
	// ޔݒP߂
	BOOL		Pop(void);
	// ޔݒׂĖ߂
	BOOL		PopAll(void);

public:
	operator _Mylpstr	(void)			{ return GetPath(); }
	operator _Mylpcstr	(void)	const	{ return GetPath(); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
