//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComObj.h
 * @brief		ComIuWFNgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXComObj_H_
#define INCG_IRIS_WXComObj_H_

//======================================================================
// include
#include "WXCom.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! Com IuWFNgNX
template<typename IT>
class CComObj : private INonCopyable<>
{
	typedef CComObj<IT>	_Myt;
	friend class CComObj;
public:
	typedef IT		value_type;
	typedef IT		*value_ptr;

protected:
	value_ptr		m_pObj;	//!< C^[tFCXCX^X
	CCom			m_Com;
public:
    /// RXgN^
	CComObj(void) : m_pObj(nullptr) {}
	CComObj(value_ptr ptr)
		: m_pObj(nullptr)	{ Attach(prt); }
	template<typename T>
	CComObj<IT>(const CComObj<T>& obj)
		: m_pObj(nullptr)	{ Attach(obj.m_pObj); }
	CComObj(const _Myt& obj)
		: m_pObj(nullptr)	{ Attach(obj.m_pObj); }

	/// fXgN^
	virtual ~CComObj(void) { Delete(); }

public:
	/**
	 * @brief	쐬
	*/
	HRESULT	Create(REFCLSID rclsid, LPUNKNOWN pUnkOuter, DWORD dwClsContext, REFIID riid)
	{
		HRESULT hr = CCom::CoCreateInstance(rclsid, pUnkOuter, dwClsContext, riid, (void**)&m_pObj);
		return hr;
	}

	/**
	 * @brief	폜
	*/
	void	Delete(void)
	{
		IRIS_SAFE_RELEASE(m_pObj);
	}

	/**
	 * @brief
	*/
	template<typename IT2>
	HRESULT	QueryInterface(REFIID riid, CComObj<IT2>& obj)
	{
		if( m_pObj == nullptr ) return E_POINTER;
		return m_pObj->QueryInterface(riid, (void**)&obj.m_pObj);
	}

protected:
	/**
	 * @brief	A^b`
	*/
	template<typename IT2>
	void		Attach(IT2* obj)
	{
		Delete();
		m_pObj = obj;
		if( obj != nullptr )
		{
			obj->AddRef();
		}
	}

	/**
	 * @brief	f^b`
	*/
	value_ptr	Detach(void)
	{
		value_ptr obj = m_pObj;
		m_pObj = nullptr;
		return obj;
	}


public:
	bool	IsValid(void)	const	{ return m_pObj != nullptr; }
public:
	/**
	 * @name	operator
	 * @{
	*/

	_Myt&	operator = (const _Myt& rhs)			{ Attach(rhs.m_pObj); return *this; }

	operator value_ptr	(void)	const				{ return m_pObj; }
			value_ptr	operator ->	(void)			{ return m_pObj; }
	const	value_ptr	operator ->	(void)	const	{ return m_pObj; }
			value_ptr	operator ()	(void)			{ return m_pObj; }
	const	value_ptr	operator ()	(void)	const	{ return m_pObj; }
	/**
	 * @}
	*/
};

}	// end of namespace wx
}	// end of namespace iris

#endif
