//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXLiberator.h
 * @brief		|C^{NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXLiberator_H_
#define INCG_IRIS_WXLiberator_H_

//======================================================================
// include
#include "../../../../fnd/container/FndLiberator.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! |C^{NX
class CLocalMemLiberator : public fnd::CLiberator
{
public:
	/// RXgN^
	CLocalMemLiberator(value_ptr p=nullptr) : fnd::CLiberator(p)	{}
public:
	/// ֐
	void	liberate( void )
	{
		if( m_ptr != nullptr )
		{
			LocalFree(m_ptr);
			m_ptr = nullptr;
		}
	}
};


}	// end of namespace wx
}	// end of namespace iris

#endif
