//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaticCtrl.cpp
 * @brief		X^eBbNRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXStaticCtrl_CPP_

//======================================================================
// include
#include "WXStaticCtrl.h"
#include <commctrl.h>
#include <windowsx.h>

namespace iris {
namespace wx
{

//======================================================================
// function

//**********************************************************************
//
// ACR̎擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @return	ACRnh
//**********************************************************************
//HICON	Static_GetIcon(HWND hWnd)
//{
//	return (HICON)SendMessage(hWnd, STM_GETICON, 0, 0);
//}
/**********************************************************************//**
 *
 * STM_GETIMAGE
 *
 ----------------------------------------------------------------------
 * @param [in]	Image	= IMAGE_BITMAP or IMAGE_ICON
 * @return	C[W̃nh
*//***********************************************************************/
LRESULT	Static_GetImage(HWND hWnd, int nImage)
{
#if(WINVER >= 0x0400)
	return SendMessage(hWnd, STM_GETIMAGE, (WPARAM)nImage, 0);
#else
	return 0;
#endif
}
//**********************************************************************
//
// ACR̐ݒ
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	hIcon	= ACR
// @return	ACRnh
//**********************************************************************
//HICON	Static_GetIcon(HWND hWnd, HICON hIcon)
//{
//	return (HICON)SendMessage(hWnd, STM_SETICON, (WPARAM)hIcon, 0);
//}
/**********************************************************************//**
 *
 * BM_SETIMAGE
 *
 ----------------------------------------------------------------------
 * @param [in]	Image	= IMAGE_BITMAP or IMAGE_ICON
 * @param [in]	hImgae	= C[W̃nh
*//***********************************************************************/
LRESULT	Static_SetImage(HWND hWnd, int nImage, LPARAM hImgae)
{
#if(WINVER >= 0x0400)
	return SendMessage(hWnd, STM_GETIMAGE, (WPARAM)nImage, hImgae);
#else
	return 0;
#endif
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStaticCtrl::CStaticCtrl(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CStaticCtrl::CStaticCtrl(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStaticCtrl::~CStaticCtrl(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param	dwStyle			= EBhEX^C
 * @param	lpszWindowName	= EBhE̖O
 * @param	rRect			= RECT\̂̎Q
 * @param	hWndParent		= ẽEBhEnh
 * @param	nID				= j[ID
 * @param	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	// EBhE̍쐬
	return CWindow::Create(WC_STATIC
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	// EBhE̍쐬
	return CreateWindow(WC_STATIC
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_STATIC
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_STATIC
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * ACRErbg}bvEBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	nImageID		= C[W\[XID
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::CreateImage( DWORD dwExStyle
					, DWORD dwStyle
					, UINT nImageID
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	TCHAR WindowName[32];
	wsprintf(WindowName, TEXT("#%d"), nImageID);
	return CreateEx( dwExStyle
		, dwStyle
		, WindowName
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * ACRErbg}bvEBhE
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	nImageID		= C[W\[XID
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CStaticCtrl::CreateImage( DWORD dwExStyle
					, DWORD dwStyle
					, UINT nImageID
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam)
{
	TCHAR WindowName[32];
	wsprintf(WindowName, TEXT("#%d"), nImageID);
	return CreateEx( dwExStyle
		, dwStyle
		, WindowName
		, x, y, w, h
		, hWndParent
		, nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CStaticCtrl::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
HICON	CStaticCtrl::GetIcon(void)								const	{ return Static_GetIcon(m_hWnd, 0); }
LRESULT	CStaticCtrl::GetImage(int nImage)						const	{ return Static_GetImage(m_hWnd, nImage); }
HICON	CStaticCtrl::SetIcon(HICON hIcon)						{ return Static_SetIcon(m_hWnd, hIcon); }
LRESULT	CStaticCtrl::SetImage(int nImage, LPARAM hImage)		{ return Static_SetImage(m_hWnd, nImage, hImage); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
