//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXToolTipCtrl.cpp
 * @brief		c[`bvt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXToolTipCtrl_CPP_

//======================================================================
// include
#include "WXToolTipCtrl.h"
#include "WXComControl.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * ANeBuԂ̐؂ւ
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bActivate	= 0:ANeBu,0ȊO:ANeBu
*//***********************************************************************/
void	ToolTip_Activate(HWND hWnd, BOOL bActivate)
{
	SendMessage(hWnd, TTM_ACTIVATE, (WPARAM)bActivate, 0);
}
/**********************************************************************//**
 *
 * c[̒ǉ
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_AddTool (HWND hWnd, LPTOOLINFO	lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_ADDTOOL , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_AddTool Q
BOOL	ToolTip_AddToolA(HWND hWnd, LPTOOLINFOA lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_ADDTOOLA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_AddTool Q
BOOL	ToolTip_AddToolW(HWND hWnd, LPTOOLINFOW lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_ADDTOOLW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * Ή̈̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [io]	lprc	= ϊÖ̗Bϊɏo͂B
 * @param [io]	bLarger	= ϊÖ̗Bϊɏo͂B
 * @return	
*//***********************************************************************/
BOOL	ToolTip_AdjustRect(HWND hWnd, LPRECT lprc, BOOL bLarger)
{
#if (_WIN32_IE >= 0x0500)
	return (BOOL)SendMessage(hWnd, TTM_ADJUSTRECT, (WPARAM)bLarger, (LPARAM)lprc);
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(lprc);
	IRIS_UNUSED_VARIABLE(bLarger);
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[̍폜
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return
*//***********************************************************************/
void	ToolTip_DelTool (HWND hWnd, LPTOOLINFO	lpti)
{
	SendMessage(hWnd, TTM_DELTOOL , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_DelTool Q
void	ToolTip_DelToolA(HWND hWnd, LPTOOLINFOA lpti)
{
	SendMessage(hWnd, TTM_DELTOOLA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_DelTool Q
void	ToolTip_DelToolW(HWND hWnd, LPTOOLINFOW lpti)
{
	SendMessage(hWnd, TTM_DELTOOLW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * o^c[̗
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return
*//***********************************************************************/
LRESULT	ToolTip_EnumTools (HWND hWnd, UINT uIndex, LPTOOLINFO  lpti)
{
	return SendMessage(hWnd, TTM_ENUMTOOLS	, (WPARAM)uIndex, (LPARAM)lpti);
}
/// iris::wx::ToolTip_EnumTools Q
LRESULT	ToolTip_EnumToolsA(HWND hWnd, UINT uIndex, LPTOOLINFOA lpti)
{
	return SendMessage(hWnd, TTM_ENUMTOOLSA , (WPARAM)uIndex, (LPARAM)lpti);
}
/// iris::wx::ToolTip_EnumTools Q
LRESULT	ToolTip_EnumToolsW(HWND hWnd, UINT uIndex, LPTOOLINFOW lpti)
{
	return SendMessage(hWnd, TTM_ENUMTOOLSW , (WPARAM)uIndex, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * c[qg̃TCY擾
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lpti	= 
 * @return	
*//***********************************************************************/
LRESULT	ToolTip_GetBubbleSize (HWND hWnd, LPTOOLINFO  lpti)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_GETBUBBLESIZE , 0, (LPARAM)lpti);
#else
	return 0;
#endif
}
LRESULT	ToolTip_GetBubbleSizeA(HWND hWnd, LPTOOLINFOA lpti)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_GETBUBBLESIZE , 0, (LPARAM)lpti);
#else
	return 0;
#endif
}
LRESULT	ToolTip_GetBubbleSizeW(HWND hWnd, LPTOOLINFOW lpti)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_GETBUBBLESIZE , 0, (LPARAM)lpti);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * ݂̃c[擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_GetCurrentTool (HWND hWnd, LPTOOLINFO  lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETCURRENTTOOL , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetCurrentTool Q
BOOL	ToolTip_GetCurrentToolA(HWND hWnd, LPTOOLINFOA lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETCURRENTTOOLA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetCurrentTool Q
BOOL	ToolTip_GetCurrentToolW(HWND hWnd, LPTOOLINFOW lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETCURRENTTOOLW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * xԂ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	x
*//***********************************************************************/
int		ToolTip_GetDelayTime(HWND hWnd)
{
	return ToolTip_GetDelayTime(hWnd, TTDT_AUTOPOP);
}
/**********************************************************************//**
 *
 * xԂ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	dwDuration	= TTDT_***
 * @return	x
*//***********************************************************************/
int		ToolTip_GetDelayTime(HWND hWnd, DWORD dwDuration)
{
#if (_WIN32_IE >= 0x0300)
	return (int)SendMessage(hWnd, TTM_GETDELAYTIME, (WPARAM)dwDuration, 0);
#else
#endif
}
/**********************************************************************//**
 *
 * }[W擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lprc	= eӂ̃}[Wl
 * @return
*//***********************************************************************/
void	ToolTip_GetMargin(HWND hWnd, LPRECT lprc)
{
#if (_WIN32_IE >= 0x0300)
	SendMessage(hWnd, TTM_GETMARGIN, 0, (LPARAM)lprc);
#else
#endif
}
/**********************************************************************//**
 *
 * ő啝擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
int		ToolTip_GetMaxTipWidth(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (int)SendMessage(hWnd, TTM_GETMAXTIPWIDTH, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * eLXg擾
 *
 *----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lpti	= 
 * @return	
*//***********************************************************************/
void	ToolTip_GetText (HWND hWnd, LPTOOLINFO	lpti)
{
	SendMessage(hWnd, TTM_GETTEXT , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetText Q
void	ToolTip_GetTextA(HWND hWnd, LPTOOLINFOA lpti)
{
	SendMessage(hWnd, TTM_GETTEXTA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetText Q
void	ToolTip_GetTextW(HWND hWnd, LPTOOLINFOW lpti)
{
	SendMessage(hWnd, TTM_GETTEXTW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * wiF̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	F
*//***********************************************************************/
COLORREF	ToolTip_GetTipBkColor(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (COLORREF)SendMessage(hWnd, TTM_GETTIPBKCOLOR, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * F̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	F
*//***********************************************************************/
COLORREF	ToolTip_GetTipTextColor(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	return (COLORREF)SendMessage(hWnd, TTM_GETTIPTEXTCOLOR, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * o^Ăc[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	o^Ăc[
*//***********************************************************************/
int		ToolTip_GetToolCount(HWND hWnd)
{
	return (int)SendMessage(hWnd, TTM_GETTOOLCOUNT, 0, 0);
}
/**********************************************************************//**
 *
 * c[̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [out]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_GetToolInfo (HWND hWnd, LPTOOLINFO	lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETTOOLINFO , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetToolInfo Q
BOOL	ToolTip_GetToolInfoA(HWND hWnd, LPTOOLINFOA lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETTOOLINFOA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_GetToolInfo Q
BOOL	ToolTip_GetToolInfoW(HWND hWnd, LPTOOLINFOW lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_GETTOOLINFOW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * c[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_HitTest (HWND hWnd, LPTTHITTESTINFO	 lphti)
{
	return (BOOL)SendMessage(hWnd, TTM_HITTEST , 0, (LPARAM)lphti);
}
/// iris::wx::ToolTip_HitTest Q
BOOL	ToolTip_HitTestA(HWND hWnd, LPTTHITTESTINFOA lphti)
{
	return (BOOL)SendMessage(hWnd, TTM_HITTESTA, 0, (LPARAM)lphti);
}
/// iris::wx::ToolTip_HitTest Q
BOOL	ToolTip_HitTestW(HWND hWnd, LPTTHITTESTINFOW lphti)
{
	return (BOOL)SendMessage(hWnd, TTM_HITTESTW, 0, (LPARAM)lphti);
}
/**********************************************************************//**
 *
 * ̈̍XV
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_NewToolRect (HWND hWnd, LPTOOLINFO	lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_NEWTOOLRECT , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_NewToolRect Q
BOOL	ToolTip_NewToolRectA(HWND hWnd, LPTOOLINFOA lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_NEWTOOLRECTA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_NewToolRect Q
BOOL	ToolTip_NewToolRectW(HWND hWnd, LPTOOLINFOW lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_NEWTOOLRECTW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return
*//***********************************************************************/
void	ToolTip_Pop(HWND hWnd)
{
#if (_WIN32_IE >= 0x0300)
	SendMessage(hWnd, TTM_POP, 0, 0);
#else
#endif
}
/**********************************************************************//**
 *
 * }EXbZ[WM
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	msg		= bZ[W
 * @return
*//***********************************************************************/
LRESULT	ToolTip_RelayEvent(HWND hWnd, LPMSG msg)
{
	return SendMessage(hWnd, TTM_RELAYEVENT, 0, (LPARAM)msg);
}
/**********************************************************************//**
 *
 * xԂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nTime	= x
 * @return
*//***********************************************************************/
void	ToolTip_SetDelayTime(HWND hWnd, int nDelay)
{
	ToolTip_SetDelayTime(hWnd, TTDT_AUTOPOP, nDelay);
}
/**********************************************************************//**
 *
 * xԂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	dwDuration	= TTDT_***
 * @param [in]	nTime		= x
 * @return
*//***********************************************************************/
void	ToolTip_SetDelayTime(HWND hWnd, DWORD dwDuration, int nDelay)
{
	SendMessage(hWnd, TTM_SETDELAYTIME, (WPARAM)dwDuration, (LPARAM)nDelay);
}
/**********************************************************************//**
 *
 * }[Wݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lprc	= eӂ̃}[Wl
 * @return
*//***********************************************************************/
void	ToolTip_SetMargin(HWND hWnd, LPRECT lprc)
{
#if (_WIN32_IE >= 0x0300)
	SendMessage(hWnd, TTM_SETMARGIN, 0, (LPARAM)lprc);
#else
	//SendMessage(hWnd, TTM_SETMARGIN, 0, (LPARAM)lprc);
#endif
}
/**********************************************************************//**
 *
 * }[Wݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	top		= ̃}[Wl
 * @param [in]	left	= ̃}[Wl
 * @param [in]	bottom	= ̃}[Wl
 * @param [in]	right	= Ẽ}[Wl
 * @return
*//***********************************************************************/
void	ToolTip_SetMargin(HWND hWnd, LONG top, LONG left, LONG bottom, LONG right)
{
	RECT rc = { top, left, bottom, right };
	ToolTip_SetMargin(hWnd, &rc);
}
/**********************************************************************//**
 *
 * ő啝ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nWidth	= 
 * @return	ȑO̕
*//***********************************************************************/
int		ToolTip_SetMaxTipWidth(HWND hWnd, int nWidth)
{
#if (_WIN32_IE >= 0x0300)
	return (int)SendMessage(hWnd, TTM_SETMAXTIPWIDTH, 0, (LPARAM)nWidth);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * wiF̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return
*//***********************************************************************/
void	ToolTip_SetTipBkColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0300)
	SendMessage(hWnd, TTM_SETTIPBKCOLOR, (WPARAM)color, 0);
#else
#endif
}
/**********************************************************************//**
 *
 * F̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return
*//***********************************************************************/
void	ToolTip_SetTipTextColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0300)
	SendMessage(hWnd, TTM_SETTIPTEXTCOLOR, (WPARAM)color, 0);
#else
#endif
}
/**********************************************************************//**
 *
 * c[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIcon		= ACRݒ(TTI_*** or HICION)
 * @param [in]	lpszTitle	= ^CgeLXg
 * @return	
*//***********************************************************************/
LRESULT		ToolTip_SetTitle (HWND hWnd, WPARAM icon, LPCTSTR lpszTitle)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_SETTITLE , icon, (LPARAM)lpszTitle);
#else
	return 0;
#endif
}
/// iris::wx::ToolTip_SetTitle Q
LRESULT		ToolTip_SetTitleA(HWND hWnd, WPARAM icon, LPCSTR  lpszTitle)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_SETTITLEA, icon, (LPARAM)lpszTitle);
#else
	return 0;
#endif
}
/// iris::wx::ToolTip_SetTitle Q
LRESULT		ToolTip_SetTitleW(HWND hWnd, WPARAM icon, LPCWSTR lpszTitle)
{
#if (_WIN32_IE >= 0x0500)
	return SendMessage(hWnd, TTM_SETTITLEW, icon, (LPARAM)lpszTitle);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * c[̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
BOOL	ToolTip_SetToolInfo (HWND hWnd, LPTOOLINFO	lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_SETTOOLINFO , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_SetToolInfo Q
BOOL	ToolTip_SetToolInfoA(HWND hWnd, LPTOOLINFOA lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_SETTOOLINFOA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_SetToolInfo Q
BOOL	ToolTip_SetToolInfoW(HWND hWnd, LPTOOLINFOW lpti)
{
	return (BOOL)SendMessage(hWnd, TTM_SETTOOLINFOW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * o^eLXg̍Đݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
void	ToolTip_Update(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, TTM_UPDATE, 0, 0);
#else
#endif
}
/**********************************************************************//**
 *
 * o^eLXg̍Đݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
void	ToolTip_UpdateTipText (HWND hWnd, LPTOOLINFO  lpti)
{
	SendMessage(hWnd, TTM_UPDATETIPTEXT , 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_UpdateTipText Q
void	ToolTip_UpdateTipTextA(HWND hWnd, LPTOOLINFOA lpti)
{
	SendMessage(hWnd, TTM_UPDATETIPTEXTA, 0, (LPARAM)lpti);
}
/// iris::wx::ToolTip_UpdateTipText Q
void	ToolTip_UpdateTipTextW(HWND hWnd, LPTOOLINFOW lpti)
{
	SendMessage(hWnd, TTM_UPDATETIPTEXTW, 0, (LPARAM)lpti);
}
/**********************************************************************//**
 *
 * o^eLXg̍Đݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	lpti	= 
 * @return	
*//***********************************************************************/
void	ToolTip_WindowFromPoint(HWND hWnd, LPPOINT lppt)
{
	SendMessage(hWnd, TTM_WINDOWFROMPOINT , 0, (LPARAM)lppt);
}

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CToolTipCtrl::CToolTipCtrl(void)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES);	// tooltip
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CToolTipCtrl::CToolTipCtrl(HWND hWnd)
: CSubClass(hWnd)
{
	CComCtrl::Initialize(ICC_TAB_CLASSES);
}

//**********************************************************************
//
// fXgN^
//
//**********************************************************************
CToolTipCtrl::~CToolTipCtrl(void)
{
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolTipCtrl::Create(DWORD dwStyle
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void *pParam )
{
	// EBhE̍쐬
	return CreateWindow(TOOLTIPS_CLASS
		, nullptr
		, dwStyle
		, 0, 0, 0, 0
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CToolTipCtrl::CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam )
{
	// EBhE̍쐬
	return CreateWindowEx(dwExStyle
		, TOOLTIPS_CLASS
		, nullptr
		, dwStyle
		, 0, 0, 0, 0
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CToolTipCtrl::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * AddTool
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags		= (TTF_***)
 * @param [in]	uID			= c[`bv̎ʎqBTTF_IDISHWNDw肵Ăꍇ́AEBhEnhB
 * @param [in]	lpszText	=  or 񃊃\[XIDBiLPSTR_TEXTCALLBACKw肷ƐeEBhETTN_NEEDTEXT𑗐M܂Bj
 * @param [in]	hInstance	= nullptr̂Ƃ́AlpszText͕B!=nullptr̂Ƃ́A񃊃\[XID
 * @param [in]	lprc		= hwnd ̃NCAg̈̍_Ƃc[`bv̕\LȋE`̍W
*//***********************************************************************/
template<>
BOOL CToolTipCtrl::AddTool<CHAR>(UINT uFlags, UINT_PTR uID, LPSTR  lpszText, HINSTANCE hInstance, const RECT* lprc)
{
	TOOLINFOA ti = {0};
	ti.cbSize	= sizeof(TOOLINFOA);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ti.hinst	= hInstance;
	ti.hwnd		= m_hWnd;
	if( lprc != nullptr ) ti.rect = *lprc;
	return ToolTip_AddToolA(m_hWnd, &ti);
}
/// CToolTipCtrl::AddTool Q
template<>
BOOL CToolTipCtrl::AddTool<WCHAR>(UINT uFlags, UINT_PTR uID, LPWSTR lpszText, HINSTANCE hInstance, const RECT* lprc)
{
	TOOLINFOW ti = {0};
	ti.cbSize	= sizeof(TOOLINFOW);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ti.hinst	= hInstance;
	ti.hwnd		= m_hWnd;
	if( lprc != nullptr ) ti.rect = *lprc;
	return ToolTip_AddToolW(m_hWnd, &ti);
}

/**********************************************************************//**
 *
 * DelTool
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags		= (TTF_***)
 * @param [in]	uID			= c[`bv̎ʎqBTTF_IDISHWNDw肵Ăꍇ́AEBhEnhB
*//***********************************************************************/
void CToolTipCtrl::DelTool (UINT uFlags, UINT_PTR uID)
{
#ifdef UNICODE
	DelToolW(uFlags, uID);
#else
	DelToolA(uFlags, uID);
#endif
}
/// CToolTipCtrl::DelTool Q
void CToolTipCtrl::DelToolA(UINT uFlags, UINT_PTR uID)
{
	TOOLINFOA ti = {0};
	ti.cbSize	= sizeof(TOOLINFOA);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ToolTip_DelToolA(m_hWnd, &ti);
}
/// CToolTipCtrl::DelTool Q
void CToolTipCtrl::DelToolW(UINT uFlags, UINT_PTR uID)
{
	TOOLINFOW ti = {0};
	ti.cbSize	= sizeof(TOOLINFOW);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ToolTip_DelToolW(m_hWnd, &ti);
}

/**********************************************************************//**
 *
 * eLXg擾
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags		= (TTF_***)
 * @param [in]	uID			= c[`bv̎ʎqBTTF_IDISHWNDw肵Ăꍇ́AEBhEnhB
*//***********************************************************************/
template<>
void CToolTipCtrl::GetText<CHAR>(UINT uFlags, UINT_PTR uID, LPSTR  lpszText) const
{
	TOOLINFOA ti = {0};
	ti.cbSize	= sizeof(TOOLINFOA);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ToolTip_GetTextA(m_hWnd, &ti);
}
/// CToolTipCtrl::GetText Q
template<>
void CToolTipCtrl::GetText<WCHAR>(UINT uFlags, UINT_PTR uID, LPWSTR lpszText) const
{
	TOOLINFOW ti = {0};
	ti.cbSize	= sizeof(TOOLINFOW);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ToolTip_GetTextW(m_hWnd, &ti);
}

/**********************************************************************//**
 *
 * qbgeXg
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags		= (TTF_***)
 * @param [in]	uID			= c[`bv̎ʎqBTTF_IDISHWNDw肵Ăꍇ́AEBhEnhB
*//***********************************************************************/
template<>
BOOL CToolTipCtrl::HitTest<LPTOOLINFOA>(POINT pt, LPTOOLINFOA lpti)
{
	TTHITTESTINFOA tthi = {0};
	tthi.hwnd	= m_hWnd;
	tthi.pt		= pt;
	tthi.ti		= *lpti;
	return ToolTip_HitTestA(m_hWnd, &tthi);
}
/// CToolTipCtrl::HitTest Q
template<>
BOOL CToolTipCtrl::HitTest<LPTOOLINFOW>(POINT pt, LPTOOLINFOW lpti)
{
	TTHITTESTINFOW tthi = {0};
	tthi.hwnd	= m_hWnd;
	tthi.pt		= pt;
	tthi.ti		= *lpti;
	return ToolTip_HitTestW(m_hWnd, &tthi);
}

/**********************************************************************//**
 *
 * o^eLXg̍Đݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	uFlags		= (TTF_***)
 * @param [in]	uID			= c[`bv̎ʎqBTTF_IDISHWNDw肵Ăꍇ́AEBhEnhB
*//***********************************************************************/
template<>
void CToolTipCtrl::UpdateTipText<CHAR>(UINT uFlags, UINT_PTR uID, LPSTR	lpszText, HINSTANCE hInstance)
{
	TOOLINFOA ti = {0};
	ti.cbSize	= sizeof(TOOLINFOA);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ti.hinst	= hInstance;
	ti.hwnd		= m_hWnd;
	ToolTip_UpdateTipTextA(m_hWnd, &ti);
}
/// CToolTipCtrl::UpdateTipText Q
template<>
void CToolTipCtrl::UpdateTipText<WCHAR>(UINT uFlags, UINT_PTR uID, LPWSTR lpszText, HINSTANCE hInstance)
{
	TOOLINFOW ti = {0};
	ti.cbSize	= sizeof(TOOLINFOW);
	ti.uFlags	= uFlags;
	ti.uId		= uID;
	ti.lpszText	= lpszText;
	ti.hinst	= hInstance;
	ti.hwnd		= m_hWnd;
	ToolTip_UpdateTipTextW(m_hWnd, &ti);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
void		CToolTipCtrl::Activate(BOOL bActivate)									{ ToolTip_Activate(m_hWnd, bActivate); }
template<>
BOOL		CToolTipCtrl::AddTool<LPTOOLINFOA>(LPTOOLINFOA lpti)					{ return ToolTip_AddToolA(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::AddTool<LPTOOLINFOW>(LPTOOLINFOW lpti)					{ return ToolTip_AddToolW(m_hWnd, lpti); }
BOOL		CToolTipCtrl::AdjustRect(LPRECT lprc, BOOL bLarger)						{ return ToolTip_AdjustRect(m_hWnd, lprc, bLarger); }
template<>
void		CToolTipCtrl::DelTool<LPTOOLINFOA>(LPTOOLINFOA lpti)					{ return ToolTip_DelToolA(m_hWnd, lpti); }
template<>
void		CToolTipCtrl::DelTool<LPTOOLINFOW>(LPTOOLINFOW lpti)					{ return ToolTip_DelToolW(m_hWnd, lpti); }
template<>
LRESULT		CToolTipCtrl::EnumTools<LPTOOLINFOA>(UINT uIndex, LPTOOLINFOA lpti)		{ return ToolTip_EnumToolsA(m_hWnd, uIndex, lpti); }
template<>
LRESULT		CToolTipCtrl::EnumTools<LPTOOLINFOW>(UINT uIndex, LPTOOLINFOW lpti)		{ return ToolTip_EnumToolsW(m_hWnd, uIndex, lpti); }
template<>
LRESULT		CToolTipCtrl::GetBubbleSize<LPTOOLINFOA>(LPTOOLINFOA	 lpti)			const	{ return ToolTip_GetBubbleSizeA(m_hWnd, lpti); }
template<>
LRESULT		CToolTipCtrl::GetBubbleSize<LPTOOLINFOW>(LPTOOLINFOW	 lpti)			const	{ return ToolTip_GetBubbleSizeW(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::GetCurrentTool<LPTOOLINFOA>(LPTOOLINFOA lpti)				const	{ return ToolTip_GetCurrentToolA(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::GetCurrentTool<LPTOOLINFOW>(LPTOOLINFOW lpti)				const	{ return ToolTip_GetCurrentToolW(m_hWnd, lpti); }
int			CToolTipCtrl::GetDelayTime(void)										const	{ return ToolTip_GetDelayTime(m_hWnd); }
int			CToolTipCtrl::GetDelayTime(DWORD dwDuration)							const	{ return ToolTip_GetDelayTime(m_hWnd, dwDuration); }
void		CToolTipCtrl::GetMargin(LPRECT lprc)									const	{ return ToolTip_GetMargin(m_hWnd, lprc); }
int			CToolTipCtrl::GetMaxTipWidth(void)										const	{ return ToolTip_GetMaxTipWidth(m_hWnd); }
template<>
void		CToolTipCtrl::GetText<LPTOOLINFOA>(LPTOOLINFOA lpti)					const	{ return ToolTip_GetTextA(m_hWnd, lpti); }
template<>
void		CToolTipCtrl::GetText<LPTOOLINFOW>(LPTOOLINFOW lpti)					const	{ return ToolTip_GetTextW(m_hWnd, lpti); }
COLORREF	CToolTipCtrl::GetTipBkColor(void)										const	{ return ToolTip_GetTipBkColor(m_hWnd); }
COLORREF	CToolTipCtrl::GetTipTextColor(void)										const	{ return ToolTip_GetTipTextColor(m_hWnd); }
int			CToolTipCtrl::GetToolCount(void)										const	{ return ToolTip_GetToolCount(m_hWnd); }
template<>
BOOL		CToolTipCtrl::GetToolInfo<LPTOOLINFOA>(LPTOOLINFOA lpti)				const	{ return ToolTip_GetToolInfoA(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::GetToolInfo<LPTOOLINFOW>(LPTOOLINFOW lpti)				const	{ return ToolTip_GetToolInfoW(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::HitTest<LPTTHITTESTINFOA>(LPTTHITTESTINFOA lphti)			{ return ToolTip_HitTestA(m_hWnd, lphti); }
template<>
BOOL		CToolTipCtrl::HitTest<LPTTHITTESTINFOW>(LPTTHITTESTINFOW lphti)			{ return ToolTip_HitTestW(m_hWnd, lphti); }
template<>
BOOL		CToolTipCtrl::NewToolRect<LPTOOLINFOA>(LPTOOLINFOA lpti)				{ return ToolTip_NewToolRectA(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::NewToolRect<LPTOOLINFOW>(LPTOOLINFOW lpti)				{ return ToolTip_NewToolRectW(m_hWnd, lpti); }
void		CToolTipCtrl::Pop(void)													{ return ToolTip_Pop(m_hWnd); }
LRESULT		CToolTipCtrl::RelayEvent(LPMSG msg)										{ return ToolTip_RelayEvent(m_hWnd, msg); }
void		CToolTipCtrl::SetDelayTime(int nDelay)									{ return ToolTip_SetDelayTime(m_hWnd, nDelay); }
void		CToolTipCtrl::SetDelayTime(DWORD dwDuration, int nDelay)				{ return ToolTip_SetDelayTime(m_hWnd, dwDuration, nDelay); }
void		CToolTipCtrl::SetMargin(LPRECT lprc)									{ return ToolTip_SetMargin(m_hWnd, lprc); }
void		CToolTipCtrl::SetMargin(LONG top, LONG left, LONG bottom, LONG right)	{ return ToolTip_SetMargin(m_hWnd, top, left, bottom, right); }
int			CToolTipCtrl::SetMaxTipWidth(int nWidth)								{ return ToolTip_SetMaxTipWidth(m_hWnd, nWidth); }
void		CToolTipCtrl::SetTipBkColor(COLORREF color)								{ return ToolTip_SetTipBkColor(m_hWnd, color); }
void		CToolTipCtrl::SetTipTextColor(COLORREF color)							{ return ToolTip_SetTipTextColor(m_hWnd, color); }
template<>
LRESULT		CToolTipCtrl::SetTitle<CHAR>(WPARAM icon, LPCSTR lpszTitle)				{ return ToolTip_SetTitleA(m_hWnd, icon, lpszTitle); }
template<>
LRESULT		CToolTipCtrl::SetTitle<WCHAR>(WPARAM icon, LPCWSTR lpszTitle)			{ return ToolTip_SetTitleW(m_hWnd, icon, lpszTitle); }
template<>
BOOL		CToolTipCtrl::SetToolInfo<LPTOOLINFOA>(LPTOOLINFOA lpti)				{ return ToolTip_SetToolInfoA(m_hWnd, lpti); }
template<>
BOOL		CToolTipCtrl::SetToolInfo<LPTOOLINFOW>(LPTOOLINFOW lpti)				{ return ToolTip_SetToolInfoW(m_hWnd, lpti); }
void		CToolTipCtrl::Update(void)												{ return ToolTip_Update(m_hWnd); }
template<>
void		CToolTipCtrl::UpdateTipText<LPTOOLINFOA>(LPTOOLINFOA lpti)				{ return ToolTip_UpdateTipTextA(m_hWnd, lpti); }
template<>
void		CToolTipCtrl::UpdateTipText<LPTOOLINFOW>(LPTOOLINFOW lpti)				{ return ToolTip_UpdateTipTextW(m_hWnd, lpti); }
void		CToolTipCtrl::WindowFromPoint(LPPOINT lppt)								{ return ToolTip_WindowFromPoint(m_hWnd, lppt); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
