//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXScrollBar.h
 * @brief		XN[o[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXScrollBar_H_
#define INCG_IRIS_WXScrollBar_H_

//======================================================================
// include
#include "../../app/WXSubClass.h"

namespace iris {
namespace wx
{

//======================================================================
// declare
class CScrollBar;

//======================================================================
// function

// TODO : 
// EBhȆ傫RANGݒ
void	SetVScrollBarRange(HWND hWnd);
void	SetHScrollBarRange(HWND hWnd);
// WM_SIZE
void	OnScrollBarSize(HWND hWnd, int nBar, LPARAM lParam);
// WM_VSCROLL WM_HSCROLL̏
void	OnScrollBarScroll(HWND hWnd, int nBar, WPARAM wParam, int line=1);

//======================================================================
// class
//! XN[o[NX
class CScrollBar : public CSubClass
{
public:
	// RXgN^
	CScrollBar(void);
	CScrollBar(HWND hWnd);
	// fXgN^
	~CScrollBar(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );

public:
	// wrap
	// ̐ݒ
	BOOL	EnableArrow(DWORD dwFlags);
	// ʒu̐ݒ
	int		SetPos(int pos, BOOL redraw);
	// ʒu̎擾
	int		GetPos(void)	const;
	// ͈͂̐ݒ
	void	SetRange(int min, int max, BOOL redraw);
	void	SetRange(int min, int max);
	void	SetRangeRedraw(int min, int max);
	// ͈͂̎擾
	void	GetRange(int* min, int* max)	const;
#if	!defined(IRIS_WIN32_WCE)
	// XN[o[̎擾
	BOOL	GetBarInfo(LPSCROLLBARINFO lpsbi)	const;
#endif
	// ̐ݒ
	BOOL	SetInfo(LPCSCROLLINFO lpsbi, BOOL redraw);
	// ̎擾
	BOOL	GetInfo(LPSCROLLINFO lpsbi)	const;
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXScrollBar_H_
