//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStatusBar.h
 * @brief		StatusBart@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXStatusBar_H_
#define INCG_IRIS_WXStatusBar_H_

//======================================================================
// icnlude
#include "../../app/WXSubClass.h"

//======================================================================
// define
/// Vv[hɎw肷p[cԍ
#define	WX_SB_SIMPLEMODE_PARTS	(0xff)

namespace iris {
namespace wx
{

//======================================================================
// declare
class CStatusBar;

//======================================================================
// function
// Ȇ̎擾
BOOL		StatusBar_GetBorders(HWND hWnd, int pBorders[]);
int			StatusBar_GetHorizontalBorder(HWND hWnd);
int			StatusBar_GetVerticalBorder(HWND hWnd);
int			StatusBar_GetSeparateBorder(HWND hWnd);
// ACR̎擾
HICON		StatusBar_GetIcon(HWND hWnd, int nParts);
// p[c̎擾
int			StatusBar_GetParts(HWND hWnd, int nCount, int pWidthArray[]);
// p[c̎擾
int			StatusBar_GetPartsNum(HWND hWnd);
// p[c̗̈擾
BOOL		StatusBar_GetRect(HWND hWnd, int nParts, LPRECT lprc);
// eLXg擾
DWORD		StatusBar_GetText (HWND hWnd, int nParts, LPTSTR pString);
DWORD		StatusBar_GetTextA(HWND hWnd, int nParts, LPSTR  pString);
DWORD		StatusBar_GetTextW(HWND hWnd, int nParts, LPWSTR pString);
// eLXg擾
int			StatusBar_GetTextLength (HWND hWnd, int nParts);
int			StatusBar_GetTextLengthA(HWND hWnd, int nParts);
int			StatusBar_GetTextLengthW(HWND hWnd, int nParts);
// c[`bveLXg擾
LRESULT		StatusBar_GetTipText (HWND hWnd, int nParts, LPTSTR pString);
LRESULT		StatusBar_GetTipTextA(HWND hWnd, int nParts, LPSTR  pString);
LRESULT		StatusBar_GetTipTextW(HWND hWnd, int nParts, LPWSTR pString);
// Vv[hǂ
BOOL		StatusBar_IsSimple(HWND hWnd);
// wiF̐ݒ
COLORREF	StatusBar_SetBkColor(HWND hWnd, COLORREF color);
// ACR̐ݒ
BOOL		StatusBar_SetIcon(HWND hWnd, int nParts, HICON hIcon);
// \̍̐ݒ
void		StatusBar_SetMinHeight(HWND hWnd, int pixexHeight);
// p[cݒ
BOOL		StatusBar_SetParts(HWND hWnd, int nCount, int* pWidthArray);
// eLXgݒ
BOOL		StatusBar_SetText (HWND hWnd, int nParts, LPCTSTR pString, UINT uType=0);
BOOL		StatusBar_SetTextA(HWND hWnd, int nParts, LPCSTR  pString, UINT uType=0);
BOOL		StatusBar_SetTextW(HWND hWnd, int nParts, LPCWSTR pString, UINT uType=0);
// c[`bveLXgƃeLXgݒ
BOOL		StatusBar_SetTextEx (HWND hWnd, int nParts, LPCTSTR pText, LPCTSTR pTipText, UINT uType=0);
BOOL		StatusBar_SetTextExA(HWND hWnd, int nParts, LPCSTR  pText, LPCSTR  pTipText, UINT uType=0);
BOOL		StatusBar_SetTextExW(HWND hWnd, int nParts, LPCWSTR pText, LPCWSTR pTipText, UINT uType=0);
// c[`bveLXg̐ݒ
void		StatusBar_SetTipText (HWND hWnd, int nParts, LPCTSTR pString);
void		StatusBar_SetTipTextA(HWND hWnd, int nParts, LPCSTR  pString);
void		StatusBar_SetTipTextW(HWND hWnd, int nParts, LPCWSTR pString);
// Vv[h̐ݒ
void		StatusBar_Simple(HWND hWnd, BOOL bSimple);

//======================================================================
// class
//! Xe[^Xo[NX
class CStatusBar : public CSubClass
{
public:
	// RXgN^
	CStatusBar(void);
	CStatusBar(HWND hWnd);
	// fXgN^
	~CStatusBar(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

public:
	// wrap
	// Ȇ̎擾
	BOOL		GetBorders(int pBorders[]) const;
	int			GetHorizontalBorder(void) const;
	int			GetVerticalBorder(void) const;
	int			GetSeparateBorder(void) const;
	// ACR̎擾
	HICON		GetIcon(int nParts) const;
	// p[c̎擾
	int			GetParts(int nCount, int pWidthArray[]) const;
	// p[X̎擾
	int			GetPartsNum(void) const;
	// p[c̗̈擾
	BOOL		GetRect(int nParts, LPRECT lprc) const;
	// eLXg擾
	DWORD		GetText (int nParts, LPTSTR pString) const;
	DWORD		GetTextA(int nParts, LPSTR  pString) const;
	DWORD		GetTextW(int nParts, LPWSTR pString) const;
	// c[`bveLXg擾
	LRESULT		GetTipText (int nParts, LPTSTR pString) const;
	LRESULT		GetTipTextA(int nParts, LPSTR  pString) const;
	LRESULT		GetTipTextW(int nParts, LPWSTR pString) const;
	// eLXg擾
	int			GetTextLength (int nParts) const;
	int			GetTextLengthA(int nParts) const;
	int			GetTextLengthW(int nParts) const;
	// Vv[hǂ
	BOOL		IsSimple(void) const;
	// wiF̐ݒ
	COLORREF	SetBkColor(DWORD color);
	// ACR̐ݒ
	BOOL		SetIcon(int nParts, HICON hIcon);
	// \̍̐ݒ
	void		SetMinHeight(int pixexHeight);
	// p[cݒ
	BOOL		SetParts(int nCount, int* pWidthArray);
	// eLXgݒ
	BOOL		SetText (int nParts, LPCTSTR pString, UINT uType=0);
	BOOL		SetTextA(int nParts, LPCSTR  pString, UINT uType=0);
	BOOL		SetTextW(int nParts, LPCWSTR pString, UINT uType=0);
	// c[`bveLXgƃeLXgݒ
	BOOL		SetTextEx (int nParts, LPCTSTR pText, LPCTSTR pTipText, UINT uType=0);
	BOOL		SetTextExA(int nParts, LPCSTR  pText, LPCSTR  pTipText, UINT uType=0);
	BOOL		SetTextExW(int nParts, LPCWSTR pText, LPCWSTR pTipText, UINT uType=0);
	// c[`bveLXg̐ݒ
	void		SetTipText (int nParts, LPCTSTR pString);
	void		SetTipTextA(int nParts, LPCSTR  pString);
	void		SetTipTextW(int nParts, LPCWSTR pString);
	// Vv[h̐ݒ
	void		Simple(BOOL bSimple);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
