//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXListBox.cpp
 * @brief		ListBoxt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXListBox_CPP_

//======================================================================
// include
#include "WXListBox.h"
#include <commctrl.h>

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * LB_ADDFILE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT ListBox_AddFile(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
#if !defined(IRIS_WIN32_WCE)
	return SendMessage(hWnd, LB_ADDFILE, wParam, lParam);
#else
	return LB_ERR;
#endif
}
//**********************************************************************
//
// ڂ̒ǉ
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	pString	= ǉ镶
// @return	ǉꂽCfbNX
//			s LB_ERR
//**********************************************************************
//int		ListBox_AddString(HWND hWnd, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, LB_ADDSTRING, 0, (LPARAM)pString);
//}
//**********************************************************************
//
// ڂ̍폜
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex		= CfbNX
// @return	
//**********************************************************************
//BOOL	ListBox_DeleteString(HWND hWnd, int nIndex)
//{
//	return (SendMessage(hWnd, LB_DELETESTRING, (WPARAM)nIndex, 0) != LB_ERR) ? 1 : 0;
//}
//**********************************************************************
//
// t@Cڂ̎擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	DDL		= t@C(DDL_***)
// @param [in]	path	= or΃pXiChJ[hj
// @return	Ō̃t@C̃CfbNX
//			s LB_ERR
//			ȂꍇLB_ERRSPACE
//**********************************************************************
//int	ListBox_Dir(HWND hWnd, int DDL, LPCTSTR path)
//{
//	return (int)SendMessage(hWnd, LB_DIR, (WPARAM)DDL, (LPARAM)path);
//}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * ̌iOvj
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= JnCfbNX
 * @param [in]	pString	= 镶
 * @return	CfbNX
 *			s LB_ERR
*//***********************************************************************/
int		ListBox_FindString(HWND hWnd, int nIndex, LPCTSTR pString)
{
	return (int)SendMessage(hWnd, CB_FINDSTRING, (WPARAM)nIndex, (LPARAM)pString);
}
/**********************************************************************//**
 *
 * ̌iSvj
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= JnCfbNX
 * @param [in]	pString	= 镶
 * @return	CfbNX
 *			s CB_ERR
*//***********************************************************************/
int		ListBox_FindStringExact(HWND hWnd, int nIndex, LPCTSTR pString)
{
	return (int)SendMessage(hWnd, LB_FINDSTRINGEXACT, (WPARAM)nIndex, (LPARAM)pString);
}
#endif

/**********************************************************************//**
 *
 * ŏ̑IځiAJ[j擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	CfbNX
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_GetAnchorIndex(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETANCHORINDEX, 0, 0);
}
//**********************************************************************
//
// ڐ̎擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @return	ڐ
//			sLB_ERR
//**********************************************************************
//int		ListBox_GetCount(HWND hWnd)
//{
//	return (int)SendMessage(hWnd, LB_GETCOUNT, 0, 0);
//}
/**********************************************************************//**
 *
 * Xg{bNX̃Lbg̈ʒu擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	Lbg̈ʒu
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_GetCreateIndex(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETCARETINDEX, 0, 0);
}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * Iڂ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	IڃCfbNX
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_GetCurSel(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETCURSEL, 0, 0);
}
/**********************************************************************//**
 *
 * XN[\̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	sNZPʂ̃XN[\ȕ
*//***********************************************************************/
int		ListBox_GetHorizontalExtent(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETHORIZONTALEXTENT, 0, 0);
}
//**********************************************************************
//
// ACeɊ֘Atꂽl̎擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex		= CfbNX
// @return	32bitl
//**********************************************************************
//LRESULT	ListBox_GetItemData(HWND hWnd, int nIndex)
//{
//	return SendMessage(hWnd, LB_GETITEMDATA, (WPARAM)nIndex, 0);
//}
/**********************************************************************//**
 *
 * ڂ̍̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= CfbNX
 * @return	sNZPʂ̍
 *			s CB_ERR
*//***********************************************************************/
int		ListBox_GetItemHeight(HWND hWnd, int nIndex)
{
	return (int)SendMessage(hWnd, LB_GETITEMHEIGHT, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * Xg\̈̋E`擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= CfbNX
 * @param [out]	lprc	= óB̈
 * @return	
*//***********************************************************************/
int		ListBox_GetItemRect(HWND hWnd, int nIndex, LPRECT lprc)
{
	return (int)SendMessage(hWnd, LB_GETITEMRECT, (WPARAM)nIndex, (LPARAM)lprc);
}
#endif
/**********************************************************************//**
 *
 * [P̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ʃ[hɍR[h
 *			ʃ[hɌꎯʎq
*//***********************************************************************/
LCID	ListBox_GetLocale(HWND hWnd)
{
	return (LCID)SendMessage(hWnd, LB_GETLOCALE, 0, 0);
}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * ڂ̏Ԃ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= CfbNX
 * @return	IԂȂ TRUE
 *			IԂȂ FALSE
*//***********************************************************************/
BOOL	ListBox_GetSel(HWND hWnd, int nIndex)
{
	return (BOOL)SendMessage(hWnd, LB_GETSEL, (WPARAM)nIndex, 0);
}
/**********************************************************************//**
 *
 * Iڐ̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	ڐ
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_GetSelCount(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETSELCOUNT, 0, 0);
}
/**********************************************************************//**
 *
 * IڂɊ֘AÂꂽl̔z擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nMaxItems	= o̓obt@z
 * @param [out]	lpIndex		= o̓obt@
 * @return	o͂z
*//***********************************************************************/
int		ListBox_GetSelItems(HWND hWnd, int nMaxItems, LPINT lpIndex)
{
	return (int)SendMessage(hWnd, LB_GETSELITEMS, (WPARAM)nMaxItems, (LPARAM)lpIndex);
}
#endif
//**********************************************************************
//
// ڂ̕擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex	= CfbNX
// @param [out]	lpBuf	= o̓obt@
// @return	
//			sLB_ERR
//**********************************************************************
//int		ListBox_GetText(HWND hWnd, int nIndex, LPTSTR lpBuf)
//{
//	return (int)SendMessage(hWnd, LB_GETTEXT, (WPARAM)nIndex, (LPARAM)lpBuf);
//}
//**********************************************************************
//
// ڂ̕񒷎擾
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex	= CfbNX
// @return	
//			sLB_ERR
//**********************************************************************
//int		ListBox_GetTextLen(HWND hWnd, int nIndex)
//{
//	return (int)SendMessage(hWnd, LB_GETTEXTLEN, (WPARAM)nIndex, 0);
//}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * 擪̃CfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @return	CfbNX
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_GetTopIndex(HWND hWnd)
{
	return (int)SendMessage(hWnd, LB_GETTOPINDEX, 0, 0);
}
#endif
/**********************************************************************//**
 *
 * ̊蓖
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	add		= 鍀ڐ
 * @param [in]	mem		= ڕ̃
 * @return	Iꍇ́A̍Ċ蓖ĂKvƂȂOɊi[ł郊Xg {bNX̍ڂ̍ő吔
 * @retval	LB_ERRSPACE	= s
*//***********************************************************************/
int		ListBox_InitStorage(HWND hWnd, int nItems, UINT nBytes)
{
#if(WINVER >= 0x0400)
	return (int)SendMessage(hWnd, LB_INITSTORAGE, (WPARAM)nItems, (LPARAM)nBytes);
#else
	return LB_ERRSPACE;
#endif
}
//**********************************************************************
//
// ڂ̑}
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex	= CfbNX
// @param [in]	pString	= ǉ镶
// @return	ǉꂽCfbNX
//			s LB_ERR
//**********************************************************************
//int		ListBox_InsertString(HWND hWnd, int nIndex, LPCTSTR pString)
//{
//	return (int)SendMessage(hWnd, LB_INSERTSTRING, (WPARAM)nIndex, (LPARAM)pString);
//}
/**********************************************************************//**
 *
 * w肳ꂽʒuɍł߂Xg {bNXڂ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	pt		= eXgW
 * @return	CfbNX
*//***********************************************************************/
LRESULT	ListBox_ItemFromPoint(HWND hWnd, POINT pt)
{
	return SendMessage(hWnd, LB_ITEMFROMPOINT, 0, MAKELPARAM(pt.x, pt.y));
}
/**********************************************************************//**
 *
 * w肳ꂽʒuɍł߂Xg {bNXڂ擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	pt		= eXgW
 * @param [out]	nIndex	= óBCfbNX
 * @retval	true	= eXgWڂ̗̈
 * @retval	false	= eXgWڂ̗̈O
*//***********************************************************************/
BOOL	ListBox_ItemFromPoint(HWND hWnd, POINT pt, int& nIndex)
{
	LRESULT lr = SendMessage(hWnd, LB_ITEMFROMPOINT, 0, MAKELPARAM(pt.x, pt.y));
	nIndex = LOWORD(lr);
	if( HIWORD(lr) == 0 ) return FALSE;
	return TRUE;
}
//**********************************************************************
//
// Sڂ폜
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
//**********************************************************************
//BOOL	ListBox_ResetContent(HWND hWnd)
//{
//	return (BOOL)SendMessage(hWnd, LB_RESETCONTENT, 0, 0);
//}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * w蕶ɑOv鍀ڂI
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= JnCfbNX
 * @param [in]	pString	= Ώە
 * @return	IڃCfbNX
 *			sLB_ERR
*//***********************************************************************/
int		ListBox_SelectString(HWND hWnd, int nIndex, LPCTSTR pString)
{
	return (int)SendMessage(hWnd, LB_SELECTSTRING, (WPARAM)nIndex, (LPARAM)pString);
}
/**********************************************************************//**
 *
 * w肵͈͂̍ڂI܂B}`̂
 *	IʒuJnʒȕꍇ͔͈͂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	bSel	= I
 * @param [in]	First	= Jnʒu
 * @param [in]	Last	= Iʒu
 * @return	
*//***********************************************************************/
LRESULT	ListBox_SelItemRange(HWND hWnd, BOOL bSel, short First, short Last)
{
	return SendMessage(hWnd, LB_SELITEMRANGE, (WPARAM)bSel, MAKELPARAM(First, Last));
}
#endif
/**********************************************************************//**
 *
 * w肵͈͂̍ڂI܂B}`̂
 *	IʒuJnʒȕꍇ͔͈͂
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	First	= Jnʒu
 * @param [in]	Last	= Iʒu
 * @return	
*//***********************************************************************/
LRESULT	ListBox_SelItemRangeEx(HWND hWnd, int First, int Last)
{
	return SendMessage(hWnd, LB_SELITEMRANGEEX, (WPARAM)First, (LPARAM)Last);
}
/**********************************************************************//**
 *
 * ŏ̑IځiAJ[jݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= CfbNX
*//***********************************************************************/
void	ListBox_SetAnchorIndex(HWND hWnd, int nIndex)
{
	SendMessage(hWnd, LB_SETANCHORINDEX, (WPARAM)nIndex, 0);
}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * R̕ݒ(LBS_MULTICOLUMN)
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pixelWidth	= sNZPʂ̃R̕
 * @return	
*//***********************************************************************/
void	ListBox_SetColumnWidth(HWND hWnd, int pixelWidth)
{
	SendMessage(hWnd, LB_SETCOLUMNWIDTH, (WPARAM)pixelWidth, 0);
}
#endif
/**********************************************************************//**
 *
 * LB_SETCOUNT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nCount	= ACe
 * @return	
*//***********************************************************************/
LRESULT	ListBox_SetCount(HWND hWnd, int nCount)
{
#if	!defined(IRIS_WIN32_WCE)
	return SendMessage(hWnd, LB_SETCOUNT, nCount, 0);
#else
	return LB_ERR;
#endif
}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * ڂ̑I
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
BOOL	ListBox_SetCurSel(HWND hWnd, int nIndex)
{
	return (SendMessage(hWnd, LB_SETCURSEL, (WPARAM)nIndex, 0) != LB_ERR) ? 1 : 0;
}
#endif
/**********************************************************************//**
 *
 * Xg{bNX̎w肵ڌʒu܂ŃXN[
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex	= XN[CfbNX
 * @param [in]	bScroll	= 
 * @return	
*//***********************************************************************/
int		ListBox_SetCreateIndex(HWND hWnd, int nIndex, BOOL bScroll)
{
	return (int)SendMessage(hWnd, LB_SETCARETINDEX, (WPARAM)nIndex, (LPARAM)bScroll);
}
/**********************************************************************//**
 *
 * XN[\̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	pixelWidth	= sNZPʂ̃XN[\ȕ
 * @return	
*//***********************************************************************/
BOOL	ListBox_SetHorizonTalextent(HWND hWnd, int pixelWitdth)
{
	SendMessage(hWnd, LB_SETHORIZONTALEXTENT, (WPARAM)pixelWitdth, 0);
	return 1;
}
//**********************************************************************
//
// lACeɊ֘At
//
//----------------------------------------------------------------------
// @param [in]	hWnd	= Ώۂ̃EBhEnh
// @param [in]	nIndex	= CfbNX
// @param [in]	Data	= l
// @return	
//**********************************************************************
//BOOL	ListBox_SetItemData(HWND hWnd, int nIndex, LPARAM Data)
//{
//	return (SendMessage(hWnd, LB_SETITEMDATA, (WPARAM)nIndex, Data) != LB_ERR) ? 1 : 0;
//}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * ڂ̍̎w
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= CfbNX
 * @param [in]	pixelHeight	= sNZPʂ̍
 * @return	
*//***********************************************************************/
BOOL	ListBox_SetItemHeight(HWND hWnd, int nIndex, int pixelHeight)
{
	return (SendMessage(hWnd, CB_SETITEMHEIGHT, (WPARAM)nIndex, (LPARAM)pixelHeight) != LB_ERR) ? 1 : 0;
}
#endif
/**********************************************************************//**
 *
 * [P̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	Country	= R[h
 * @param [in]	Lang	= ꎯʎq
 * @return	ȑÕ[P
 *			ʃ[hɍR[h
 *			ʃ[hɌꎯʎq
*//***********************************************************************/
LCID	ListBox_SetLocale(HWND hWnd, WORD Country, WORD Lang)
{
	return (LCID)SendMessage(hWnd, LB_SETLOCALE, MAKEWPARAM(Lang, Country), 0);
}
LCID	ListBox_SetLocale(HWND hWnd, LCID Locale)
{
	return (LCID)SendMessage(hWnd, LB_SETLOCALE, (WPARAM)Locale, 0);
}
#if (WINVER < 0x030a)
/**********************************************************************//**
 *
 * wCfbNX̑IE
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	bSel	= IE
 * @param [in]	nIndex	= CfbNX
 * @return	
*//***********************************************************************/
BOOL	ListBox_SetSel(HWND hWnd, BOOL bSel, int nIndex)
{
	return (SendMessage(hWnd, LB_SETSEL, (WPARAM)bSel, (LPARAM)nIndex) != LB_ERR) ? 1 : 0;
}
/**********************************************************************//**
 *
 * ^uXgbv̐ƈʒu̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	wParam	= 
 * @param [in]	lParam	= 
 * @return	
*//***********************************************************************/
LRESULT ListBox_SetTabStops(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
	return SendMessage(hWnd, LB_SETTABSTOPS, wParam, lParam);
}
/**********************************************************************//**
 *
 * 擪̃CfbNXw
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	nIndex		= CfbNX
 * @return	
*//***********************************************************************/
BOOL	ListBox_SetTopIndex(HWND hWnd, int nIndex)
{
	return (SendMessage(hWnd, LB_SETTOPINDEX, (WPARAM)nIndex, 0) != LB_ERR) ? 1 : 0;
}
#endif

//======================================================================
// class
// CListBox
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CListBox::CListBox(void)
{
}
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
*//***********************************************************************/
CListBox::CListBox(HWND hWnd)
: CSubClass(hWnd)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CListBox::~CListBox(void)
{
}

/**********************************************************************//**
 *
 * ftHg\[g֐
 *
 ----------------------------------------------------------------------
 * @param [in]	lp1		= r
 * @param [in]	lp2		= r
 * @param [in]	lpData	= [U[f[^
 * @return	
*//***********************************************************************/
int CALLBACK CListBox::DefaultCompare(LPARAM lp1, LPARAM lp2, LPARAM lpData)
{
	HWND hWnd = (HWND)lpData;
	int len1 = (int)::SendMessage(hWnd, LB_GETTEXTLEN, (WPARAM)lp1, 0);
	if( len1 == LB_ERR )	return 0;
	int len2 = (int)::SendMessage(hWnd, LB_GETTEXTLEN, (WPARAM)lp2, 0);
	if( len2 == LB_ERR )	return 0;

	char* str1 = new char [len1+1];
	::SendMessage(hWnd, LB_GETTEXT, (WPARAM)lp1, (LPARAM)str1);
	char* str2 = new char [len2+1];
	::SendMessage(hWnd, LB_GETTEXT, (WPARAM)lp2, (LPARAM)str2);
	int ret = strcmp(str1, str2);
	delete [] str1;
	delete [] str2;
	return ret;
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListBox::Create( DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::Create(WC_LISTBOX
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListBox::Create( DWORD dwStyle
					 , LPCTSTR lpszWindowName
					 , int x, int y, int w, int h
					 , HWND hWndParent, int nID
					 , HINSTANCE hInstance
					 , void* pParam )
{
	return CreateWindow(WC_LISTBOX
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	rRect			= RECT\̂̎Q
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CWindow::CreateEx(dwExStyle
		, WC_LISTBOX
		, lpszWindowName
		, dwStyle
		, rRect
		, hWndParent
		, nID
		, hInstance
		, pParam );
}
/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwExStyle		= gEBhEX^C
 * @param [in]	dwStyle			= EBhEX^C
 * @param [in]	lpszWindowName	= EBhE̖O
 * @param [in]	x,y,w,h			= EBhË
 * @param [in]	hWndParent		= ẽEBhEnh
 * @param [in]	nID				= j[ID
 * @param [in]	hInstance		= CX^Xnh
 * @param [in]	pParam			= p[^
 * @return	EBhEnh
*//***********************************************************************/
HWND CListBox::CreateEx( DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, int nID
					, HINSTANCE hInstance
					, void* pParam )
{
	return CreateWindowEx(dwExStyle
		, WC_LISTBOX
		, lpszWindowName
		, dwStyle
		, x, y, w, h
		, hWndParent
		, (HMENU)(UINT_PTR)nID
		, hInstance
		, pParam );
}

//**********************************************************************
//
// EBhEvV[W
//
//**********************************************************************
LRESULT CListBox::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uMsg)
	{
	// ENbN
	case WM_RBUTTONUP:
		{
			int id = ::GetDlgCtrlID(hWnd);
			NMHDR nmh = { hWnd, id, NM_RCLICK };
			::PostMessage(::GetParent(hWnd), WM_NOTIFY, id, (LPARAM)&nmh);
		}
		return 0;

	// \[g
	case LB_SORTITEMS:
		{
			PFNLBCOMPARE func = (PFNLBCOMPARE)lParam;
			LPARAM		 data = (LPARAM)wParam;
			if( func == nullptr )
			{
				data = (LPARAM)hWnd;
				func = DefaultCompare;
			}
			int cnt = (int)::SendMessage(hWnd, LB_GETCOUNT, 0, 0);
			for( int i=0; i < cnt-1; ++i )
			{
				for( int j=i; j < cnt; ++j )
				{
					int ret = func((LPARAM)i, (LPARAM)j, data);
					if( ret > 0 )
					{
						// ёւ
						int len1 = (int)::SendMessage(hWnd, LB_GETTEXTLEN, i, 0);
						int len2 = (int)::SendMessage(hWnd, LB_GETTEXTLEN, j, 0);
						if( len1 != LB_ERR && len2 != LB_ERR )
						{
							LPTSTR str1 = new TCHAR [len1+1];
							LPTSTR str2 = new TCHAR [len2+1];
							::SendMessage(hWnd, LB_GETTEXT		, i	, (LPARAM)str1);
							::SendMessage(hWnd, LB_GETTEXT		, j	, (LPARAM)str2);
							::SendMessage(hWnd, LB_DELETESTRING	, i	, 0);
							::SendMessage(hWnd, LB_INSERTSTRING	, i	, (LPARAM)str2);
							::SendMessage(hWnd, LB_DELETESTRING	, j	, 0);
							::SendMessage(hWnd, LB_INSERTSTRING	, j	, (LPARAM)str1);
							delete [] str1;
							delete [] str2;
						}
					}
				}
			}
		}
		break;
	// KEYDOWN
	case WM_KEYDOWN:
		{
			WORD nChar = (WORD)wParam;
			int id = ::GetDlgCtrlID(hWnd);
			// TODO:Ƃ肠Aflags = 0
			LV_KEYDOWN lvk = { hWnd, id, LVN_KEYDOWN, nChar, 0 };
			::PostMessage(::GetParent(hWnd), WM_NOTIFY, id, (LPARAM)&lvk);
		}
		break;
	}
	return PreWndProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//*
 * @name	bp[֐
 * @{
*//***********************************************************************/
LRESULT CListBox::AddFile(WPARAM wParam, LPARAM lParam)				{ return ListBox_AddFile(m_hWnd, wParam, lParam); }
int		CListBox::AddString(LPCTSTR pString)						{ return ListBox_AddString(m_hWnd, pString); }
BOOL	CListBox::DeleteString(int nIndex)							{ return ListBox_DeleteString(m_hWnd, nIndex); }
LRESULT	CListBox::Dir(int DDL, LPCTSTR path)						{ return ListBox_Dir(m_hWnd, DDL, path); }
int		CListBox::FindString(int nIndex, LPCTSTR pString)			{ return ListBox_FindString(m_hWnd, nIndex, pString); }
int		CListBox::FindStringExact(int nIndex, LPCTSTR pString)		{ return ListBox_FindStringExact(m_hWnd, nIndex, pString); }
int		CListBox::GetAnchorIndex(void)								const	{ return ListBox_GetAnchorIndex(m_hWnd); }
int		CListBox::GetCount(void)									const	{ return ListBox_GetCount(m_hWnd); }
int		CListBox::GetCreateIndex(void)								const	{ return ListBox_GetCreateIndex(m_hWnd); }
int		CListBox::GetCurSel(void)									const	{ return ListBox_GetCurSel(m_hWnd); }
int		CListBox::GetHorizontalExtent(void)							const	{ return ListBox_GetHorizontalExtent(m_hWnd); }
LRESULT	CListBox::GetItemData(int nIndex)							const	{ return ListBox_GetItemData(m_hWnd, nIndex); }
int		CListBox::GetItemHeight(int nIndex)							const	{ return ListBox_GetItemHeight(m_hWnd, nIndex); }
int		CListBox::GetItemRect(int nIndex, LPRECT lprc)				const	{ return ListBox_GetItemRect(m_hWnd, nIndex, lprc); }
LCID	CListBox::GetLocale(void)									const	{ return ListBox_GetLocale(m_hWnd); }
BOOL	CListBox::GetSel(int nIndex)								const	{ return ListBox_GetSel(m_hWnd, nIndex); }
int		CListBox::GetSelCount(void)									const	{ return ListBox_GetSelCount(m_hWnd); }
int		CListBox::GetSelItems(int nMaxItems, LPINT lpIndex)			const	{ return ListBox_GetSelItems(m_hWnd, nMaxItems, lpIndex); }
int		CListBox::GetText(int nIndex, LPTSTR lpBuf)					const	{ return ListBox_GetText(m_hWnd, nIndex, lpBuf); }
int		CListBox::GetTextLen(int nIndex)							const	{ return ListBox_GetTextLen(m_hWnd, nIndex); }
int		CListBox::GetTopIndex(void)									const	{ return ListBox_GetTopIndex(m_hWnd); }
LRESULT	CListBox::InitStorage(int nItems, UINT nBytes)				{ return ListBox_InitStorage(m_hWnd, nItems, nBytes); }
int		CListBox::InsertString(int nIndex, LPCTSTR pString)			{ return ListBox_InsertString(m_hWnd, nIndex, pString); }
LRESULT	CListBox::ItemFromPoint(POINT pt)							{ return ListBox_ItemFromPoint(m_hWnd, pt); }
BOOL	CListBox::ItemFromPoint(POINT pt, int& nIndex)				{ return ListBox_ItemFromPoint(m_hWnd, pt, nIndex); }
BOOL	CListBox::ResetContent(void)								{ return ListBox_ResetContent(m_hWnd); }
int		CListBox::SelectString(int nIndex, LPCTSTR pString)			{ return ListBox_SelectString(m_hWnd, nIndex, pString); }
LRESULT	CListBox::SelItemRange(BOOL bSel, short First, short Last)	{ return ListBox_SelItemRange(m_hWnd, bSel, First, Last); }
LRESULT	CListBox::SelItemRangeEx(int First, int Last)				{ return ListBox_SelItemRangeEx(m_hWnd, First, Last); }
void	CListBox::SetAnchorIndex(int nIndex)						{ return ListBox_SetAnchorIndex(m_hWnd, nIndex); }
void	CListBox::SetColumnWidth(int pixelWidth)					{ ListBox_SetColumnWidth(m_hWnd, pixelWidth); }
LRESULT	CListBox::SetCount(int nCount)								{ return ListBox_SetCount(m_hWnd, nCount); }
BOOL	CListBox::SetCurSel(int nIndex)								{ return ListBox_SetCurSel(m_hWnd, nIndex); }
int		CListBox::SetCreateIndex(int nIndex, BOOL bScroll)			{ return ListBox_SetCreateIndex(m_hWnd, nIndex, bScroll); }
BOOL	CListBox::SetHorizonTalextent(int pixelWidth)				{ return ListBox_SetHorizonTalextent(m_hWnd, pixelWidth); }
BOOL	CListBox::SetItemData(int nIndex, LPARAM Data)				{ return ListBox_SetItemData(m_hWnd, nIndex, Data); }
BOOL	CListBox::SetItemHeight(int nIndex, int pixelHeight)		{ return ListBox_SetItemHeight(m_hWnd, nIndex, pixelHeight); }
LCID	CListBox::SetLocale(WORD Country, WORD Lang)				{ return ListBox_SetLocale(m_hWnd, Country, Lang); }
LCID	CListBox::SetLocale(LCID Locale)							{ return ListBox_SetLocale(m_hWnd, Locale); }
BOOL	CListBox::SetSel(BOOL bSel, int nIndex)						{ return ListBox_SetSel(m_hWnd, bSel, nIndex); }
LRESULT CListBox::SetTabStops(WPARAM wParam, LPARAM lParam)			{ return ListBox_SetTabStops(m_hWnd, wParam, lParam); }
BOOL	CListBox::SetTopIndex(int nIndex)							{ return ListBox_SetTopIndex(m_hWnd, nIndex); }
/**********************************************************************//*
 * @}
*//***********************************************************************/

}	// end of namespace wx
}	// end of namespace iris
