//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnumWindows.h
 * @brief		EnumWindows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXEnumWindows_H_
#define INCG_IRIS_WXEnumWindows_H_

//======================================================================
// include
#include "WXFindWindow.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// EnumWindows NX
class CEnumWindows : public IIrisObject
{
protected:
	template<typename _FUNC>
	struct PARAM
	{
		WNDENUMPROC		pfnEnum;
		LPARAM			lParam;
		const _FUNC*	pfnFunc;
	};
public:

	/**
	 * @brief	EBhEnh̗
	*/
	template<typename _FUNC>
	static BOOL	EnumWindows(WNDENUMPROC lpEnumFunc, LPARAM lParam, const _FUNC& func)
	{
		PARAM<_FUNC> p = { lpEnumFunc, lParam, &func };
		return ::EnumWindows(_EnumWindowsProc<_FUNC>, (LPARAM)&p);
	}

	/**
	 * @brief	EBhEnȟ
	*/
	template<typename _FUNC>
	static HWND	FindEnumWindows(const _FUNC& func)
	{
		HWND hWnd = nullptr;
		PARAM<_FUNC> p = { nullptr, (LPARAM)&hWnd, &func };
		::EnumWindows(_FindWindowsProc<_FUNC>, (LPARAM)&p);
		return hWnd;
	}

public:
	// RXgN^
	CEnumWindows(void)	{}
	// fXgN^
	virtual ~CEnumWindows(void)	{}


private:
	// 񋓊֐
	template<typename _FUNC>
	static BOOL CALLBACK _EnumWindowsProc(HWND hWnd, LPARAM lParam)
	{
		PARAM<_FUNC>* param = reinterpret_cast<PARAM<_FUNC>*>(lParam);
		if( param->pfnFunc == nullptr || *(param->pfnFunc)(hWnd) )
		{
			if( param->pfnEnum != nullptr )
			{
				return param->pfnEnum(hWnd, param->lParam);
			}
		}
		return TRUE;
	}
	// 
	template<typename _FUNC>
	static BOOL CALLBACK _FindWindowsProc(HWND hWnd, LPARAM lParam)
	{
		PARAM<_FUNC>* param = reinterpret_cast<PARAM<_FUNC>*>(lParam);
		if( param == nullptr ) return FALSE;
		HWND* phWnd = reinterpret_cast<HWND*>(param->lParam);
		if( phWnd == nullptr ) return TRUE;
		if( param->pfnFunc == nullptr || (*param->pfnFunc)(hWnd) )
		{
			*phWnd = hWnd;
			return FALSE;
		}
		return TRUE;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
