//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindWindow.h
 * @brief		EBhENX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXFindWindow_H_
#define INCG_IRIS_WXFindWindow_H_

//======================================================================
// include
#include "../../../../../iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// FindWindow NX
class CFindWindow : public IIrisObject
{
public:
	/**
	 * @brief	EBhE
	 * @param [in]	hWndParent		= ΏېeEBhE
	 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
	 * @param [in]	lpszClassName	= NX
	 * @param [in]	lpszWindowName	= EBhE
	 * @param [in]	func			= ǉ̌Iy[V
	*/
	template<typename _FUNC>
	static HWND	FindWindowA(HWND hWndParent, HWND hChild, LPCSTR  lpszClassName, LPCSTR  lpszWindowName, const _FUNC& func)
	{
		HWND hWnd = ::FindWindowExA(hWndParent, hChild, lpszClassName, lpszWindowName);
		while( hWnd != nullptr )
		{
			if( func(hWnd) ) return hWnd;
			HWND hTemp = FindWindowA(hWnd, nullptr, lpszClassName, lpszWindowName, func);
			if( hTemp != nullptr ) return hTemp;
			hWnd = ::FindWindowExA(hWndParent, hWnd, lpszClassName, lpszWindowName);
		}
		return nullptr;
	}
	/**
	 * @brief	EBhE
	 * @param [in]	hWndParent		= ΏېeEBhE
	 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
	 * @param [in]	lpszClassName	= NX
	 * @param [in]	lpszWindowName	= EBhE
	 * @param [in]	func			= ǉ̌Iy[V
	*/
	template<typename _FUNC>
	static HWND	FindWindowW(HWND hWndParent, HWND hChild, LPCWSTR lpszClassName, LPCWSTR lpszWindowName, const _FUNC& func)
	{
		HWND hWnd = ::FindWindowExW(hWndParent, hChild, lpszClassName, lpszWindowName);
		while( hWnd != nullptr )
		{
			if( func(hWnd) ) return hWnd;
			HWND hTemp = FindWindowW(hWnd, nullptr, lpszClassName, lpszWindowName, func);
			if( hTemp != nullptr ) return hTemp;
			hWnd = ::FindWindowExW(hWndParent, hWnd, lpszClassName, lpszWindowName);
		}
		return nullptr;
	}

	/**
	 * @brief	EBhE
	 * @note	́ABȃNXAEBhẼnhT̂Ɏg܂B
	 * @param [in]	hWndParent		= ΏېeEBhE
	 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
	 * @param [in]	func			= ǉ̌Iy[V
	*/
	template<typename _FUNC>
	static HWND	FindWindowA(HWND hWndParent, HWND hChild, const _FUNC& func)
	{
		HWND hWnd = ::FindWindowExA(hWndParent, hChild, nullptr, nullptr);
		while( hWnd != nullptr )
		{
			if( func(hWnd) ) return hWnd;
			HWND hTemp = FindWindowA(hWnd, nullptr, func);
			if( hTemp != nullptr ) return hTemp;
			hWnd = ::FindWindowExA(hWndParent, hWnd, nullptr, nullptr);
		}
		return nullptr;
	}
	/**
	 * @brief	EBhE
	 * @note	́ABȃNXAEBhẼnhT̂Ɏg܂B
	 * @param [in]	hWndParent		= ΏېeEBhE
	 * @param [in]	hChild			= JnqEBhẼnh(NULL ̏ꍇ́A擪猟)
	 * @param [in]	func			= ǉ̌Iy[V
	*/
	template<typename _FUNC>
	static HWND	FindWindowW(HWND hWndParent, HWND hChild, const _FUNC& func)
	{
		HWND hWnd = ::FindWindowExW(hWndParent, hChild, nullptr, nullptr);
		while( hWnd != nullptr )
		{
			if( func(hWnd) ) return hWnd;
			HWND hTemp = FindWindowW(hWnd, nullptr, func);
			if( hTemp != nullptr ) return hTemp;
			hWnd = ::FindWindowExW(hWndParent, hWnd, nullptr, nullptr);
		}
		return nullptr;
	}

public:
	/**
	 * @internal
	 * @brief	rIy[^(OR)
	*/
	typedef struct tagOR
	{
		inline BOOL operator ()(BOOL lhs, BOOL rhs) const
		{
			return lhs || rhs;
		}
	} OR;	//!< rIy[^(OR)

	/**
	 * @internal
	 * @brief	rIy[^(AND)
	*/
	typedef struct tagAND
	{
		inline BOOL operator ()(BOOL lhs, BOOL rhs) const
		{
			return lhs && rhs;
		}
	} AND;	//!< rIy[^(AND)
public:
	/**
	 * @private
	 * @internal
	 * @brief	_~[Aspect
	*/
	struct NullAspect
	{
		inline BOOL operator ()(HWND /*hWnd*/) const { return 0; }
	};

	/**
	 * @brief	pIy[VIuWFNg
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Op=AND, typename _Next=NullAspect>
	struct Aspect
	{
		const _Next* pNext;	//!< ̃Iy[V
		Aspect(void) : pNext(nullptr) {}
		Aspect(const _Next* next) : pNext(next) {}

		inline BOOL operator ()(HWND hWnd) const
		{
			_Op op;
			BOOL ret = check(hWnd);
			if( pNext == nullptr ) return ret;
			return op(ret, (*pNext)(hWnd));
		}
		virtual BOOL check(HWND hWnd) const
		{
			IRIS_UNUSED_VAR(hWnd);
			return 0;
		}
	};

public:
	// prIuWFNg

	/**
	 * @brief	vZXID veXg Iy[VIuWFNg
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Op=AND, typename _Next=NullAspect>
	struct ProcessIdOp : public Aspect<_Op, _Next>
	{
		DWORD m_Id;
		ProcessIdOp(DWORD id) : m_Id(id) {}
		ProcessIdOp(DWORD id, const _Next& next) : m_Id(id), Aspect(&next) {}

		virtual BOOL check(HWND hWnd) const
		{
			DWORD dwProcessID = 0;
			::GetWindowThreadProcessId(hWnd, &dwProcessID);
			return dwProcessID == m_Id ? TRUE : FALSE;
		}
	};

	/**
	 * @brief	Rg[ID veXg Iy[VIuWFNg
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Op=AND, typename _Next=NullAspect>
	struct ControlIdOp : public Aspect<_Op, _Next>
	{
		int m_Id;
		ControlIdOp(int id) : m_Id(id) {}
		ControlIdOp(int id, const _Next& next) : m_Id(id), Aspect(&next) {}

		virtual BOOL check(HWND hWnd) const
		{
			int ctlID = ::GetDlgCtrlID(hWnd);
			return ctlID == m_Id ? TRUE : FALSE;
		}
	};

	/**
	 * @brief	VisibleeXg Iy[VIuWFNg
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Op=AND, typename _Next=NullAspect>
	struct VisibleOp : public Aspect<_Op, _Next>
	{
		VisibleOp(void) {}
		VisibleOp(const _Next& next) : Aspect(&next) {}

		virtual BOOL check(HWND hWnd) const
		{
			return ::IsWindowVisible(hWnd);
		}
	};

	/**
	 * @brief	LvVr Iy[VIuWFNg
	 * @tparam _Func= ̔rIy[V
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Func, typename _Op=AND, typename _Next=NullAspect>
	struct WindowNameOp : public Aspect<_Op, _Next>
	{
		const _Func& func;
		LPCTSTR lpWindowName;
		WindowNameOp(const _Func& f, LPCTSTR lpName) : func(f), lpWindowName(lpName) {}
		WindowNameOp(const _Func& f, LPCTSTR lpName, const _Next& next) : func(f), lpWindowName(lpName), Aspect(&next) {}

		virtual BOOL check(HWND hWnd) const
		{
			if( ::GetWindowTextLength(hWnd) <= 0 ) return 0;

			TCHAR text[512];
			::GetWindowText(hWnd, text, 512);
			return func(text, lpWindowName);
		}
	};

	/**
	 * @brief	NXr Iy[VIuWFNg
	 * @tparam _Func= ̔rIy[V
	 * @tparam _Op	= g̃Iy[VʂƎ̃Iy[Vʂ̉ZIy[V
	 * @tparam _Next= ̌pIy[VIuWFNg
	*/
	template<typename _Func, typename _Op=AND, typename _Next=NullAspect>
	struct ClassNameOp : public Aspect<_Op, _Next>
	{
		const _Func& func;
		LPCTSTR lpClassName;
		ClassNameOp(const _Func& f, LPCTSTR lpName) : func(f), lpClassName(lpName) {}
		ClassNameOp(const _Func& f, LPCTSTR lpName, const _Next& next) : func(f), lpClassName(lpName), Aspect(&next) {}

		virtual BOOL check(HWND hWnd) const
		{
			TCHAR text[512];
			::GetClassName(hWnd, text, 512);
			return func(text, lpClassName);
		}
	};
};

}	// end of namespace wx
}	// end of namespace iris

#endif
