//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCrtReport.cpp
 * @brief		WXCrtReport t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXCrtReport_CPP_

//======================================================================
// include
#include "WXCrtReport.h"

namespace iris {
namespace wx
{

/**********************************************************************//**
 *
 * [hݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	mode	= ݒ肷郂[h
 * @param [in]	flags	= ݒ肷^Cṽ}XN
*//***********************************************************************/
void CCrtReport::SetMode(int mode, u32 flags)
{
	for( int i=_CRT_WARN; i <= _CRT_ERRCNT; ++i )
	{
		if( flags & (1<<i) )
		{
			_CrtSetReportMode(i, mode);
		}
	}
}

/**********************************************************************//**
 *
 * t@Co̓[hɐݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	mode	= ݒ肷郂[h
 * @param [in]	flags	= ݒ肷^Cṽ}XN
*//***********************************************************************/
void CCrtReport::SetRedirectMode(_HFILE file, u32 flags)
{
	for( int i=_CRT_WARN; i <= _CRT_ERRCNT; ++i )
	{
		if( flags & (1<<i) )
		{
			_CrtSetReportMode(i, _CRTDBG_MODE_FILE);
			_CrtSetReportFile(i, file);
		}
	}
}

/**********************************************************************//**
 *
 * tbN
 *
 -----------------------------------------------------------------------
 * @param [in]	pfnFunc	= tbNnh
 * @retval	-1 : s
 * @return	Ăяo pfnNewHook ̎QƃJEg
*//***********************************************************************/
template<>
int CCrtReport::Hook<_CRT_REPORT_HOOK>(_CRT_REPORT_HOOK pfnFunc)
{
	return _CrtSetReportHook2(_CRT_RPTHOOK_INSTALL, pfnFunc);
}
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC8)
template<>
int CCrtReport::Hook<_CRT_REPORT_HOOKW>(_CRT_REPORT_HOOKW pfnFunc)
{
	return _CrtSetReportHookW2(_CRT_RPTHOOK_INSTALL, pfnFunc);
}
#endif

/**********************************************************************//**
 *
 * tbN
 *
 -----------------------------------------------------------------------
 * @param [in]	pfnFunc	= tbNnh
 * @retval	-1 : s
 * @return	Ăяo pfnNewHook ̎QƃJEg
*//***********************************************************************/
template<>
int CCrtReport::Unhook<_CRT_REPORT_HOOK>(_CRT_REPORT_HOOK pfnFunc)
{
	return _CrtSetReportHook2(_CRT_RPTHOOK_REMOVE, pfnFunc);
}
template<>
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC8)
int CCrtReport::Unhook<_CRT_REPORT_HOOKW>(_CRT_REPORT_HOOKW pfnFunc)
{
	return _CrtSetReportHookW2(_CRT_RPTHOOK_REMOVE, pfnFunc);
}
#endif

/**********************************************************************//**
 *
 * tbN
 *
 -----------------------------------------------------------------------
 * @param [in]	pfnFunc	= tbNnh
 * @return	ȑÕnh
*//***********************************************************************/
_CRT_REPORT_HOOK CCrtReport::HookOnce(_CRT_REPORT_HOOK pfnFunc)
{
	return _CrtSetReportHook(pfnFunc);
}


}	// end of namespace wx
}	// end of namespace iris
