//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebug.h
 * @brief		fobOp֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDebug_H_
#define INCG_IRIS_WXDebug_H_

//======================================================================
// include
#include "iris_debug.h"

//======================================================================
// define

#ifdef _IRIS_DEBUG

/// exp̎sƁA߂l̃`FbN
#define CHECK_HRESULT(exp)	{ HRESULT hResult = (exp); if( FAILED(hResult) ) { dprintf(TEXT("*** FILED: ") TEXT(__FILE__) TEXT("(%d) %s: <%x>.\n"), __LINE__, #exp, hResult); } }

#else

#define CHECK_HRESULT(exp)	exp

#endif

#if defined(__cplusplus)

//======================================================================
// class
#ifdef _DEBUG

#if IRIS_MSC_AT_LEAST(_MSC_VER_VC6)
namespace iris {
namespace wx {
namespace dbg {

template<typename T>
STATICINLINE int UninitializedVariableWarning(const T* v, const char* file, int line)
{
	int find_size = 0;
#if IRIS_MSC_AT_LEAST(_MSC_VER_VC7)
	const char mcc = 0xCD;
#else
	const char mcc = 0xCC;
#endif
	const char* p = (const char*)v;
	for( size_t i=0, size=sizeof(T); i < size; ++i, ++p )
	{
		if( *p == mcc )
		{
			++find_size;
			dprintfA("Uninitialized Variable Warning : %s:%d. \n", file, line);
		}
	}
	return find_size;
}

}
}
}

#define UNINITIALIZED_WARNING(type_ptr_)		::iris::wx::dbg::UninitializedVariableWarning(type_ptr_, __FILE__, __LINE__)


#endif

#endif

#endif

#ifndef UNINITIALIZED_WARNING
#  define UNINITIALIZED_WARNING(type_ptr_)		(void)(type_ptr_)
#endif



#endif
