//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugConsole.h
 * @brief		fobOpR\[o͊֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXDebugConsole_H_
#define INCG_IRIS_WXDebugConsole_H_

//======================================================================
// include
#include "../base/WXConsole.h"

#if	defined(IRIS_WIN32_WCE)
#error not support.
#endif

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// declare
class CDebugConsole;

//======================================================================
// typedef
/// CDebugConsoleCxg֐|C^
typedef bool (*PFN_DebugConsoleInputEvent)(LPCTSTR buf, DWORD dwSize);

//======================================================================
// function

#ifdef _IRIS_DEBUG
	// fobOpR\[NX擾
	CDebugConsole*	GetDebugConsole(void);

	bool	DebugConsoleOpen(bool std, bool page_sys);
	void	DebugConsoleClose(void);
	void	outA(LPCSTR  format, ...);
	void	outW(LPCWSTR format, ...);
	void	out (LPCTSTR format, ...);

#else
	// fobOpR\[NX擾
	inline CDebugConsole*	GetDebugConsole(void)	{ return nullptr; }

	inline void DebugConsoleOpen(...)		{}	// empty
	inline void DebugConsoleClose()			{}	// empty
	inline void outA(...)					{}	// empty
	inline void outW(...)					{}	// empty
	inline void out(...)					{}	// empty
#endif

//======================================================================
// class
//! R\[NXifobOpgj
class CDebugConsole : public CConsole
{
private:
	fnd::CRefCounter			m_Ref;		//!< QƃJE^
	PFN_DebugConsoleInputEvent	m_Event;	//!< Cxg֐|C^
	bool						m_bPageSys;	//!< y[WVXe̗L
public:
	// RXgN^
	CDebugConsole(void);
	// fXgN^
	~CDebugConsole(void);
public:
	// J
	virtual bool	Open(bool std=true);
	virtual bool	Open(bool std, bool page_sys);
	// 
	virtual void	Close(void);
	// wvo
	virtual	void	PutsHelp(void);
public:
	// ͑҂
	void	WaitInput(void);
	// ftHgCxg
	bool	DefaultEvent(LPCTSTR buf, DWORD dwSize);
	// Cxg֐ݒ
	void	SetEventFunc(PFN_DebugConsoleInputEvent func)	{ m_Event = func; }
public:
	// R\[Cxgnh
	static	BOOL WINAPI CtrlEventHandler(DWORD CtrlType);
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
