//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDumpExceptionFilter.cpp
 * @brief		WXDumpExceptionFilter t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXDumpExceptionFilter_CPP_

//======================================================================
// include
#include "WXDumpExceptionFilter.h"
#include "WXStackWalker.h"

namespace iris {
namespace wx {
namespace dbg
{

namespace 
{
	static DWORD	GetCurrentStack()
	{
		_asm mov eax, esp;
	}
	static void		Dump(const void* pAddr, const void* pMaker, DWORD dwSize)
	{
		static DWORD i,n;
		static const BYTE* p = nullptr;
		static const BYTE* m = nullptr;
		p = static_cast<const BYTE*>(pAddr);
		m = static_cast<const BYTE*>(pMaker);

		for( n=0; n < dwSize; n+=16 )
		{
			printf("     %08X :", reinterpret_cast<DWORD>(p));
			for( i=0; i < 16; ++i, ++p )
			{
				if( !(i&0x3) )
				{
					printf(" ");
				}

				if( IsBadReadPtr(p, sizeof(BYTE)) )
				{
					printf("== ");
				}
				else
				{
					if( p == m )
					{
						printf("%02X*", *p);
					}
					else
					{
						printf("%02X ", *p);
					}
				}
			}
			printf("\n");
		}

	}
}

/**********************************************************************//**
 *
 * Onh
 *
 ----------------------------------------------------------------------
 * @param [in]	ExceptionInfo	= O
 * @return	tB^[
*//***********************************************************************/
LONG CDumpExceptionFilter::ExceptionFilter(_EXCEPTION_POINTERS *ExceptionInfo)
{
	{
		printf("Exception     : Code    = 0x%08X(%s)\n", ExceptionInfo->ExceptionRecord->ExceptionCode
			, FormatExceptionMessageA(ExceptionInfo->ExceptionRecord->ExceptionCode));
		printf("              : Flags   = 0x%08X\n", ExceptionInfo->ExceptionRecord->ExceptionFlags);
		printf("              : Address = 0x%08X\n", ExceptionInfo->ExceptionRecord->ExceptionAddress);
		printf("              : \n");

		printf("Registers     : EAX=0x%08X EBX=0x%08X ECX=0x%08X EDX=0x%08X\n"
			, ExceptionInfo->ContextRecord->Eax
			, ExceptionInfo->ContextRecord->Ebx
			, ExceptionInfo->ContextRecord->Ecx
			, ExceptionInfo->ContextRecord->Edx
			);
		printf("              : EDI=0x%08X ESI=0x%08X EBP=0x%08X ESP=0x%08X\n"
			, ExceptionInfo->ContextRecord->Edi
			, ExceptionInfo->ContextRecord->Esi
			, ExceptionInfo->ContextRecord->Ebp
			, ExceptionInfo->ContextRecord->Esp
			);
		printf("              : EIP=0x%08X EFL=0x%08X                CSP=0x%08X\n"
			, ExceptionInfo->ContextRecord->Eip
			, GetCurrentStack()
			, ExceptionInfo->ContextRecord->EFlags
			);
		printf("              : CS=0x%04X DS=0x%04X ES=0x%04X FS=0x%04X GS=0x%04X SS=0x%04X\n"
			, ExceptionInfo->ContextRecord->SegCs
			, ExceptionInfo->ContextRecord->SegDs
			, ExceptionInfo->ContextRecord->SegEs
			, ExceptionInfo->ContextRecord->SegFs
			, ExceptionInfo->ContextRecord->SegGs
			, ExceptionInfo->ContextRecord->SegSs
			);
		printf("              : \n");
	}
	// eLXg̃_v
	{
		BYTE* addr = reinterpret_cast<BYTE*>((ExceptionInfo->ContextRecord->Eip - 384) & 0xFFFFFFF0);
		printf( "Text Image   : (EIP=0x%08X)\n", ExceptionInfo->ContextRecord->Eip );

		Dump(addr, (void*)ExceptionInfo->ContextRecord->Eip, 512);
	}
	// X^bÑ_v
	{
		BYTE* addr = reinterpret_cast<BYTE*>((ExceptionInfo->ContextRecord->Esp - 128) & 0xFFFFFFF0);
		printf( "Stack Image  : (ESP=0x%08X)\n", ExceptionInfo->ContextRecord->Esp );

		Dump(addr, (void*)ExceptionInfo->ContextRecord->Esp, 1024);
	}

	// X^bNg[X
	{
		CSymbol sym;
		if( sym.Initialize(GetCurrentProcess(), nullptr, TRUE) )
		{
			CStackWalker walker;
			HANDLE hThread = ::GetCurrentThread();
			if( walker.Begin(sym, hThread, ExceptionInfo->ContextRecord) )
			{

				while(1)
				{
					if( !walker.Walk(nullptr, CDbgHelpModule::GetSymFunctionTableAccessProc(), CDbgHelpModule::GetSymGetModuleBaseProc(), nullptr) )
					{
						break;
					}

					char sym_name[MAX_SYM_NAME] = {0};
					printf(" %04X:%08X : ", walker.GetPC().Segment, walker.GetPC().Offset);
					if( walker.GetSymbolName(sym_name, MAX_SYM_NAME) )
					{
						printf(sym_name);
					}
					printf("( %08X, %08X, %08X, %08X )\n"
						, walker.GetStackFrame().Params[0]
						, walker.GetStackFrame().Params[1]
						, walker.GetStackFrame().Params[2]
						, walker.GetStackFrame().Params[3]
						);
				}
			}
		}
	}

	return EXCEPTION_EXECUTE_HANDLER;
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris
