//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXObjLeakCheck.h
 * @brief		IuWFNgnh[N`FbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXObjLeakCheck_H_
#define INCG_IRIS_WXObjLeakCheck_H_

//======================================================================
// include
#include "../../../../../fnd/container/FndSingleton.h"

#ifdef _IRIS_DEBUG

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

#ifdef IRIS_OBJLEAKCHECK_ENABLE
#  undef IRIS_OBJLEAKCHECK_ENABLE
#endif
#define IRIS_OBJLEAKCHECK_ENABLE(x)	static volatile ::iris::wx::dbg::CObjLeakCheck s_ObjLeakCheck(x)

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// class
/// IuWFNg[N`FbJ[@NX
class CObjLeakCheck : public fnd::CSingleton<CObjLeakCheck>
{
public:
	typedef enum
	{
		HOOKTARGET_HANDLE	= 0x00000001,	//!< HANDLE
		HOOKTARGET_FINDFILE	= 0x00000002,	//!< FindFile
		HOOKTARGET_REG		= 0x00000004,	//!< Registry
		HOOKTARGET_GDI		= 0x00000010,	//!< GDI Handle
		HOOKTARGET_METAFILE	= 0x00000020,	//!< Meta File
		HOOKTARGET_DC		= 0x00000080,	//!< Device Context
		HOOKTARGET_HEAP		= 0x00000100,	//!< HEAP
		HOOKTARGET_ALL		= 0xffffffff,
	} HOOKTARGET;
public:
	// RXgN^
	CObjLeakCheck(void);
	explicit CObjLeakCheck(int enableTarget);
	// fXgN^
	~CObjLeakCheck(void);

};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#else

#ifdef IRIS_OBJLEAKCHECK_ENABLE
#  undef IRIS_OBJLEAKCHECK_ENABLE
#endif
#define IRIS_OBJLEAKCHECK_ENABLE(...)	void CObjLeakCheck_(void)

#endif


#endif
