//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProcHook.h
 * @brief		֐tbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_WXProcHook_H_
#define INCG_IRIS_WXProcHook_H_

//======================================================================
// include
#include "../../../../../iris_object.h"
#include "../../os/WXModule.h"

#if	defined(IRIS_WIN32_WCE)
#error	not support.
#endif

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// class
/// ֐tbNNX
class CProcHook : public IIrisObject
{
	PROC	m_pfnOrigin;	//!< {̊֐|C^
	PROC	m_pfnPrev;		//!< ȑO̊֐|C^
	PROC	m_pfnCurrent;	//!< ݂̊֐|C^
	PROC*	m_ppAddress;	//!< ֐|C^i[AhX
public:
	// RXgN^
	CProcHook(void);
	// fXgN^
	~CProcHook(void);
public:
	// ^[Qbg̃I[v
	template<typename CHARTYPE_>
	bool	Open(const CHARTYPE_* pszModuleName, PROC pfnTarget, HMODULE hModule);
	template<typename CHARTYPE_>
	bool	Open(const CHARTYPE_* pszModuleName, const CHARTYPE_* pszFuncName, HMODULE hModule)
	{
		CModule mdl;
		if( !mdl.Open(pszModuleName) ) return false;
		PROC pfnTarget = mdl.GetProcAddress(pszFuncName);
		return Open(pszModuleName, pfnTarget, hModule);
	}
	bool	Open(PROC pfnTarget, HMODULE hModule);

	// I[vς݂ǂ
	bool	IsOpen(void);

	// 
	void	Close(void);

public:
	// ֐̒u
	bool	Replace(PROC pfnNew);
	// ȑO̊֐ɖ߂
	bool	Revert(void);
	// ̊֐ɖ߂
	bool	Reset(void);
	// IWi̊֐ǂ
	bool	IsOrigin(void) const	{ return m_pfnCurrent == m_pfnOrigin; }

public:
	/// ȑO̊֐擾
	PROC	GetPrevProc(void)	{ return m_pfnPrev; }
	/// ݒ肵֐擾
	PROC	GetNewProc(void)	{ return m_pfnCurrent; }
	/// IWi̊֐擾
	PROC	GetOriginProc(void)	{ return m_pfnOrigin; }
	/// IWi̊֐擾
	template<typename F>
	F		GetOriginProc(F)	{ return (F)m_pfnOrigin; }
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
