//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSymbol.cpp
 * @brief		WXSymbol t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2012 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXSymbol_CPP_

//======================================================================
// include
#include "WXSymbol.h"
#include "WXDebugHelp.h"
#include "../../../../../iris_xchar.hpp"

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CSymbol::CSymbol(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hProcess	= ֘AtvZX
*//***********************************************************************/
CSymbol::CSymbol(HANDLE hProcess)
: CProcess(hProcess)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CSymbol::~CSymbol(void)
{
	if( m_hObject != nullptr )
		Cleanup();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	hProcess		= ֘AtvZX
 * @param [in]	UserSearchPath	= pX
 * @param [in]	bInvadeProcess	= vZXp̃[hς݃W[邩ǂ
 * @return	
*//***********************************************************************/
BOOL CSymbol::Initialize(HANDLE hProcess, PSTR UserSearchPath, BOOL bInvadeProcess)
{
	if( !Attach(hProcess) ) return FALSE;
	return CDbgHelpModule::SymInitialize(m_hObject, UserSearchPath, bInvadeProcess);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	UserSearchPath	= pX
 * @param [in]	bInvadeProcess	= vZXp̃[hς݃W[邩ǂ
 * @return	
*//***********************************************************************/
BOOL CSymbol::Initialize(PSTR UserSearchPath, BOOL bInvadeProcess)
{
	return CDbgHelpModule::SymInitialize(m_hObject, UserSearchPath, bInvadeProcess);
}

/**********************************************************************//**
 *
 * N[Abv
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CSymbol::Cleanup(void)
{
	if( !IsValid() ) return TRUE;
	return CDbgHelpModule::SymCleanup(Detach());
}

/**********************************************************************//**
 *
 * V{e[u[h
 *
 ----------------------------------------------------------------------
 * @param [in]	hFile		= s\ȃC[Wێt@C̃nh(NULL )
 * @param [in]	ImageName	= s\C[W̖O
 * @param [in]	ModuleName	= W[̃V[gJbg(NULL )
 * @param [in]	BaseOfDll	= W[̃[hAhX
 * @param [in]	SizeOfDll	= W[̃TCY
 * @return	
*//***********************************************************************/
XDWORD CSymbol::LoadModule(HANDLE hFile, PSTR ImageName, PSTR ModuleName, XDWORD BaseOfDll, DWORD SizeOfDll)
{
	return CDbgHelpModule::SymLoadModule(m_hObject, hFile, ImageName, ModuleName, BaseOfDll, SizeOfDll);
}

/**********************************************************************//**
 *
 * V{e[uA[h
 *
 ----------------------------------------------------------------------
 * @param [in]	BaseOfDll	= W[̃[hAhX
 * @return	
*//***********************************************************************/
BOOL CSymbol::UnloadModule(DWORD BaseOfDll)
{
	return CDbgHelpModule::SymUnloadModule(m_hObject, BaseOfDll);
}

/**********************************************************************//**
 *
 * W[̗
 *
 ----------------------------------------------------------------------
 * @param [in]	pfnCallback	= W[󂯎R[obN֐
 * @param [in]	pUserData	= [U[`̒l
 * @return	
*//***********************************************************************/
BOOL CSymbol::EnumModules(PSYM_ENUMMODULES_CALLBACK pfnCallback, PVOID pUserData)
{
	return CDbgHelpModule::SymEnumerateModules(m_hObject, pfnCallback, pUserData);
}

/**********************************************************************//**
 *
 * V{̗
 *
 ----------------------------------------------------------------------
 * @param [in]	BaseOfDll	= V{񋓂W[̃x[XAhX
 * @param [in]	pfnCallback	= V{󂯎R[obN֐
 * @param [in]	pUserData	= [U[`̒l
 * @return	
*//***********************************************************************/
BOOL CSymbol::EnumSymbols(XULONG BaseOfDll, PSYM_ENUMSYMBOLS_CALLBACK pfnCallback, PVOID pUserData)
{
IRIS_PRAGMA_WARNING_DISABLE(IRIS_MSC, 4996)
	return CDbgHelpModule::SymEnumerateSymbols(m_hObject, BaseOfDll, pfnCallback, pUserData);
IRIS_PRAGMA_WARNING_DEFAULT(IRIS_MSC, 4996)
};

/**********************************************************************//**
 *
 * ֐e[ũGgAhX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	AddrBase	= x[XAhX
 * @return	֐e[ũGgAhX
*//***********************************************************************/
LPVOID CSymbol::FunctionTableAccess(DWORD AddrBase)
{
	return CDbgHelpModule::SymFunctionTableAccess(m_hObject, AddrBase);
}

/**********************************************************************//**
 *
 * w肳ꂽAhXɑΉ\[Xsi\[XR[h̍sj
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pLine			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineFromAddr(XDWORD dwAddr, PDWORD pdwDisplacement, PIMAGEHLP_LINE  pLine) const
{
	return CDbgHelpModule::SymGetLineFromAddr(m_hObject, dwAddr, pdwDisplacement, pLine);
}

/**********************************************************************//**
 *
 * w肳ꂽW[ƃt@CΉ\[Xsi\[XR[h̍sj
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	ModuleName		= W[
 * @param [in]	FileName		= t@C
 * @param [in]	dwLineNumber	= sԍ
 * @param [in]	lpDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pLine			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineFromName(LPSTR ModuleName, LPSTR FileName, DWORD dwLineNumber, PLONG lpDisplacement, PIMAGEHLP_LINE pLine) const
{
	return CDbgHelpModule::SymGetLineFromName(m_hObject, ModuleName, FileName, dwLineNumber, lpDisplacement, pLine);
}

/**********************************************************************//**
 *
 * ̃\[Xs擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pLine	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLineNext(PIMAGEHLP_LINE pLine) const
{
	return CDbgHelpModule::SymGetLineNext(m_hObject, pLine);
}

/**********************************************************************//**
 *
 * Õ\[Xs擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pLine	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetLinePrev(PIMAGEHLP_LINE pLine) const
{
	return CDbgHelpModule::SymGetLinePrev(m_hObject, pLine);
}

/**********************************************************************//**
 *
 * V{̎擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpszSymbolName	= o̓obt@
 * @param [in]	length			= o̓obt@
 * @return	
*//***********************************************************************/
template<>
bool CSymbol::GetSymNameFromAddr<CHAR>(XDWORD dwAddr, LPSTR lpszSymbolName, u32 length) const
{
	if( lpszSymbolName == nullptr ) return false;
#define USE_IMAGEHLP_SYMBOL

#if	defined(USE_IMAGEHLP_SYMBOL)
	typedef IMAGEHLP_SYMBOL	SYMINFO;
#else
	typedef SYMINFO			SYMINFO;
#endif
	SYMINFO* pSymbol = nullptr;
	u8 buffer[sizeof(SYMINFO) + MAX_SYM_NAME * sizeof(TCHAR)] = {0};
	pSymbol = pointer_cast<SYMINFO*>(buffer);
	pSymbol->SizeOfStruct = sizeof(SYMINFO);
#if	defined(USE_IMAGEHLP_SYMBOL)
	pSymbol->MaxNameLength	= MAX_SYM_NAME;
#else
	pSymbol->MaxNameLen		= MAX_SYM_NAME;
#endif

	XDWORD disp=0;
	if( GetSymFromAddr(dwAddr, &disp, (PIMAGEHLP_SYMBOL)pSymbol) )
	{
		lpszSymbolName[0] = 0;
		return false;
	}
	xcstoxcs_s(lpszSymbolName, length, pSymbol->Name);
	return true;
}
template<>
bool CSymbol::GetSymNameFromAddr<WCHAR>(XDWORD dwAddr, LPWSTR lpszSymbolName, u32 length) const
{
	if( lpszSymbolName == nullptr ) return false;
#define USE_IMAGEHLP_SYMBOL

#if	defined(USE_IMAGEHLP_SYMBOL)
	typedef IMAGEHLP_SYMBOL	SYMINFO;
#else
	typedef SYMINFO			SYMINFO;
#endif
	SYMINFO* pSymbol = nullptr;
	u8 buffer[sizeof(SYMINFO) + MAX_SYM_NAME * sizeof(TCHAR)] = {0};
	pSymbol = pointer_cast<SYMINFO*>(buffer);
	pSymbol->SizeOfStruct = sizeof(SYMINFO);
#if	defined(USE_IMAGEHLP_SYMBOL)
	pSymbol->MaxNameLength	= MAX_SYM_NAME;
#else
	pSymbol->MaxNameLen		= MAX_SYM_NAME;
#endif

	XDWORD disp=0;
	if( GetSymFromAddr(dwAddr, &disp, (PIMAGEHLP_SYMBOL)pSymbol) )
	{
		lpszSymbolName[0] = 0;
		return false;
	}
	xcstoxcs_s(lpszSymbolName, length, pSymbol->Name);
	return true;
}

/**********************************************************************//**
 *
 * w肳ꂽAhXɒuĂV{
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pSymbol			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymFromAddr(XDWORD dwAddr, PXDWORD pdwDisplacement, PIMAGEHLP_SYMBOL pSymbol) const
{
	return CDbgHelpModule::SymGetSymFromAddr(m_hObject, dwAddr, pdwDisplacement, pSymbol);
}

/**********************************************************************//**
 *
 * w肳ꂽOɑΉV{
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr			= AhX
 * @param [in]	pdwDisplacement	= V{̐擪̕ψʁA܂0
 * @param [out]	pSymbol			= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymFromName(LPSTR Name, PIMAGEHLP_SYMBOL pSymbol) const
{
	return CDbgHelpModule::SymGetSymFromName(m_hObject, Name, pSymbol);
}

/**********************************************************************//**
 *
 * ̃V{擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pSymbol	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymNext(PIMAGEHLP_SYMBOL pSymbol) const
{
	return CDbgHelpModule::SymGetSymNext(m_hObject, pSymbol);
}

/**********************************************************************//**
 *
 * ÕV{擾
 *
 -----------------------------------------------------------------------
 * @param [out]	pSymbol	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSymPrev(PIMAGEHLP_SYMBOL pSymbol) const
{
	return CDbgHelpModule::SymGetSymPrev(m_hObject, pSymbol);
}

/**********************************************************************//**
 *
 * 肳ꂽAhXێ郂W[̃x[XAhX
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr		= AhX
 * @return	W[̃x[XAhX
*//***********************************************************************/
XDWORD CSymbol::GetModuleBase(XDWORD dwAddr) const
{
	return CDbgHelpModule::SymGetModuleBase(m_hObject, dwAddr);
}

/**********************************************************************//**
 *
 * w肳ꂽW[̃W[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	dwAddr		= AhX
 * @param [out]	ModuleInfo	= o͏
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetModuleInfo(XDWORD dwAddr, PIMAGEHLP_MODULE ModuleInfo) const
{
	return CDbgHelpModule::SymGetModuleInfo(m_hObject, dwAddr, ModuleInfo);
}

/**********************************************************************//**
 *
 * w肳ꂽvZXp̌pX擾
 *
 -----------------------------------------------------------------------
 * @param [out]	SearchPath			= o̓obt@
 * @param [in]	SearchPathLength	= o̓obt@TCY
 * @return	
*//***********************************************************************/
BOOL CSymbol::GetSearchPath(PSTR SearchPath, DWORD SearchPathLength) const
{
	return CDbgHelpModule::SymGetSearchPath(m_hObject, SearchPath, SearchPathLength);
}

/**********************************************************************//**
 *
 * w肳ꂽvZXp̌pXݒ
 *
 -----------------------------------------------------------------------
 * @param [out]	SearchPath	= ݒpX
 * @return	
*//***********************************************************************/
BOOL CSymbol::SetSearchPath(PSTR SearchPath)
{
	return CDbgHelpModule::SymSetSearchPath(m_hObject, SearchPath);
}

/**********************************************************************//**
 *
 * V{nhgR[obN֐o^
 *
 -----------------------------------------------------------------------
 * @param [out]	pfnCallback		= R[obN֐
 * @param [in]	pUserData		= [U[f[^
 * @return	
*//***********************************************************************/
BOOL CSymbol::RegisterCallback(PSYMBOL_REGISTERED_CALLBACK pfnCallback, PVOID pUserData)
{
#if defined(_IMAGEHLP64)
	return CDbgHelpModule::SymRegisterCallback(m_hObject, pfnCallback, (ULONG64)pUserData);
#else
	return CDbgHelpModule::SymRegisterCallback(m_hObject, pfnCallback, pUserData);
#endif
}

/**********************************************************************//**
 *
 * Alpha Rs[^ŃX^bNEH[LOiA̍ƁjvV[Wp邽߂̃R[obN֐o^
 *
 -----------------------------------------------------------------------
 * @param [out]	pfnCallback		= R[obN֐
 * @param [in]	pUserData		= [U[f[^
 * @return	
*//***********************************************************************/
BOOL CSymbol::RegisterFunctionEntryCallback(PSYMBOL_FUNCENTRY_CALLBACK pfnCallback, PVOID pUserData)
{
#if defined(_IMAGEHLP64)
	return CDbgHelpModule::SymRegisterFunctionEntryCallback(m_hObject, pfnCallback, (ULONG64)pUserData);
#else
	return CDbgHelpModule::SymRegisterFunctionEntryCallback(m_hObject, pfnCallback, pUserData);
#endif
}

/**********************************************************************//**
 *
 * IvV擾
 *
 -----------------------------------------------------------------------
 * @return	IvV
*//***********************************************************************/
DWORD CSymbol::GetOptions(void)
{
	return CDbgHelpModule::SymGetOptions();
}

/**********************************************************************//**
 *
 * IvVݒ
 *
 -----------------------------------------------------------------------
 * @param [in]	newOptions	= VIvV
 * @return	IvV
*//***********************************************************************/
DWORD CSymbol::SetOptions(DWORD newOptions)
{
	return CDbgHelpModule::SymSetOptions(newOptions);
}

}	// end of namespace wx
}	// end of namespace iris

