//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHtmlHelp.cpp
 * @brief		HtmlHelpg
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXHtmlHelp_CPP_

//======================================================================
// include
#include "WXHtmlHelp.h"
#include "../../wx_inchead.h"
#include "iris_xchar.hpp"
#include <tchar.h>

#include "../../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * popup\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @param [in]	pi		= \ʒu
 * @param [in]	fore	= F
 * @param [in]	back	= wiF
 * @param [in]	text	= 
 * @return	
*//***********************************************************************/
BOOL ShowPopupHtmlHelp (HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPTSTR text)
{
#ifdef UNICODE
	return ShowPopupHtmlHelpW(hWnd, pi, fore, back, text);
#else
	return ShowPopupHtmlHelpA(hWnd, pi, fore, back, text);
#endif
}
/// iris::wx::ShowPopupHtmlHelp Q
BOOL ShowPopupHtmlHelpA(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPSTR  text)
{
#ifdef _IRIS_WX_HTMLHELP_WORKSHOP
	if( text == nullptr ) return 0;
	HH_POPUP hp;
    memset(&hp, 0, sizeof(HH_POPUP));
    hp.cbStruct = sizeof(HH_POPUP);
    hp.pt.x = pi.x;
    hp.pt.y = pi.y;
    hp.clrForeground = fore;
    hp.clrBackground = back;
    hp.rcMargins.left = -1;
    hp.rcMargins.right = -1;
    hp.rcMargins.top = -1;
    hp.rcMargins.bottom = -1;
	hp.pszText = text;

	HWND hw = HtmlHelpA(hWnd, nullptr, HH_DISPLAY_TEXT_POPUP, (DWORD)(INT_PTR)&hp);
	if( hw == nullptr ) return 0;
	return 1;
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(pi);
	IRIS_UNUSED_VARIABLE(fore);
	IRIS_UNUSED_VARIABLE(back);
	IRIS_UNUSED_VARIABLE(text);
	return 0;
#endif
}
/// iris::wx::ShowPopupHtmlHelp Q
BOOL ShowPopupHtmlHelpW(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPWSTR text)
{
#ifdef _IRIS_WX_HTMLHELP_WORKSHOP
	if( text == nullptr ) return 0;
	HH_POPUP hp;
    memset(&hp, 0, sizeof(HH_POPUP));
    hp.cbStruct = sizeof(HH_POPUP);
    hp.pt.x = pi.x;
    hp.pt.y = pi.y;
    hp.clrForeground = fore;
    hp.clrBackground = back;
    hp.rcMargins.left = -1;
    hp.rcMargins.right = -1;
    hp.rcMargins.top = -1;
    hp.rcMargins.bottom = -1;
	size_t size = wcslen(text) + 1;
	LPSTR str = new CHAR [size];
	wcstombs_s(&size, str, size, text, size);
	hp.pszText = str;

	HWND hw = HtmlHelpW(hWnd, nullptr, HH_DISPLAY_TEXT_POPUP, (DWORD)(INT_PTR)&hp);
	delete [] str;
	if( hw == nullptr ) return 0;
	return 1;
#else
	IRIS_UNUSED_VARIABLE(hWnd);
	IRIS_UNUSED_VARIABLE(pi);
	IRIS_UNUSED_VARIABLE(fore);
	IRIS_UNUSED_VARIABLE(back);
	IRIS_UNUSED_VARIABLE(text);
	return 0;
#endif
}

/**********************************************************************//**
 *
 * Toc\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @param [in]	path	= wvt@C̃pX(.chm)
 * @return	
*//***********************************************************************/
BOOL ShowTocHtmlHelp (HWND hWnd, LPTSTR path)
{
#ifdef UNICODE
	return ShowTocHtmlHelpW(hWnd, path);
#else
	return ShowTocHtmlHelpA(hWnd, path);
#endif
}
/// iris::wx::ShowTocHtmlHelp Q
BOOL ShowTocHtmlHelpA(HWND hWnd, LPSTR  path)
{
	if( HtmlHelpA(hWnd, path, HH_DISPLAY_TOC, 0) == nullptr ) return 0;
	return 1;
}
/// iris::wx::ShowTocHtmlHelp Q
BOOL ShowTocHtmlHelpW(HWND hWnd, LPWSTR path)
{
	if( HtmlHelpW(hWnd, path, HH_DISPLAY_TOC, 0) == nullptr ) return 0;
	return 1;
}

/**********************************************************************//**
 *
 * Index\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @param [in]	path	= wvt@C̃pX(.chm)
 * @param [in]	index	= wvt@CCfbNXpX
 * @return	
*//***********************************************************************/
BOOL ShowIndexHtmlHelp (HWND hWnd, LPTSTR path, LPTSTR index)
{
#ifdef UNICODE
	return ShowIndexHtmlHelpW(hWnd, path, index);
#else
	return ShowIndexHtmlHelpA(hWnd, path, index);
#endif
}
/// iris::wx::ShowIndexHtmlHelp Q
BOOL ShowIndexHtmlHelpA(HWND hWnd, LPSTR  path, LPSTR  index)
{
	CHAR  name[MAX_PATH<<1];
	strcpy_s(name, sizeof(name), path);
	strcat_s(name, sizeof(name), "::");
	strcat_s(name, sizeof(name), index);
	if( HtmlHelpA(hWnd, name, HH_DISPLAY_INDEX, 0) == nullptr ) return 0;
	return 1;
}
/// iris::wx::ShowIndexHtmlHelp Q
BOOL ShowIndexHtmlHelpW(HWND hWnd, LPWSTR path, LPWSTR index)
{
	WCHAR name[MAX_PATH<<1];
	wcscpy_s(name, elementof(name), path);
	wcscat_s(name, elementof(name), L"::");
	wcscat_s(name, elementof(name), index);
	if( HtmlHelpW(hWnd, name, HH_DISPLAY_INDEX, 0) == nullptr ) return 0;
	return 1;
}

//======================================================================
// class
// CTHtmlHelp
/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	path	= .chmt@C̃pX
*//***********************************************************************/
template<typename CHARTYPE_>
CTHtmlHelp<CHARTYPE_>::CTHtmlHelp(_Mylpcstr path)
: m_dwCookie(0)
{
	xcscpy_s(m_Path, elementof(m_Path), path);
}
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTHtmlHelp<CHARTYPE_>::CTHtmlHelp(void)
: m_dwCookie(0)
{
	memset(m_Path, 0, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
template<typename CHARTYPE_>
CTHtmlHelp<CHARTYPE_>::~CTHtmlHelp(void)
{
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTHtmlHelp<CHARTYPE_>::Initialize(void)
{
	// wvVXȅ
    HtmlHelp(nullptr, nullptr, HH_INITIALIZE, (DWORD_PTR)(INT_PTR)&m_dwCookie);
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
template<typename CHARTYPE_>
void CTHtmlHelp<CHARTYPE_>::Tarminate(void)
{
	// wvVXẻ
    HtmlHelp(nullptr, nullptr, HH_UNINITIALIZE, (DWORD)(INT_PTR)&m_dwCookie);
}

/**********************************************************************//**
 *
 * popup\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @param [in]	pi		= \ʒu
 * @param [in]	fore	= F
 * @param [in]	back	= wiF
 * @param [in]	text	= 
 * @return	
*//***********************************************************************/
template<>
BOOL CTHtmlHelp<CHAR>::ShowPopup(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPSTR text)
{
	return ShowPopupHtmlHelpA(hWnd, pi, fore, back, text);
}
template<>
BOOL CTHtmlHelp<WCHAR>::ShowPopup(HWND hWnd, POINT pi, COLORREF fore, COLORREF back, LPWSTR text)
{
	return ShowPopupHtmlHelpW(hWnd, pi, fore, back, text);
}

/**********************************************************************//**
 *
 * Toc\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @return	
*//***********************************************************************/
template<>
BOOL CTHtmlHelp<CHAR>::ShowToc(HWND hWnd)
{
	return ShowTocHtmlHelpA(hWnd, m_Path);
}
template<>
BOOL CTHtmlHelp<WCHAR>::ShowToc(HWND hWnd)
{
	return ShowTocHtmlHelpW(hWnd, m_Path);
}

/**********************************************************************//**
 *
 * Index\
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= enh
 * @param [in]	index	= wvt@CCfbNXpX
 * @return	
*//***********************************************************************/
template<>
BOOL CTHtmlHelp<CHAR>::ShowIndex(HWND hWnd, LPSTR index)
{
	return ShowIndexHtmlHelpA(hWnd, m_Path, index);
}
template<>
BOOL CTHtmlHelp<WCHAR>::ShowIndex(HWND hWnd, LPWSTR index)
{
	return ShowIndexHtmlHelpW(hWnd, m_Path, index);
}

/**********************************************************************//**
 *
 * pXݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	path	= wvt@C̃pX(.chm)
*//***********************************************************************/
template<typename CHARTYPE_>
void CTHtmlHelp<CHARTYPE_>::SetPath(_Mylpcstr path)
{
	xcscpy_s(m_Path, elementof(m_Path), path);
}

template class CTHtmlHelp<CHAR>;
template class CTHtmlHelp<WCHAR>;

}	// end of namespace wx
}	// end of namespace iris

#ifndef _IRIS_WX_SUPPORT_HTMLHELP_WORKSHOP

HWND HtmlHelpA(HWND, LPCSTR , UINT, DWORD_PTR)	{ return 0; }
HWND HtmlHelpW(HWND, LPCWSTR, UINT, DWORD_PTR)	{ return 0; }

#endif
