//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXFindHeapList.cpp
 * @brief		HeapList NX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXFindHeapList_CPP_

//======================================================================
// include
#include "WXFindHeapList.h"
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CFindHeapList::CFindHeapList(void)
{
	SecureZeroMemory(&m_List, sizeof(m_List));
	m_List.dwSize = sizeof(m_List);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CFindHeapList::~CFindHeapList(void)
{
}

/**********************************************************************//**
 *
 * vZXID猟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwProcessId	= vZXID
 * @return	q[vID
*//***********************************************************************/
ULONG_PTR CFindHeapList::FindHeapId(DWORD dwProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	if( (toolhelp.GetFlags() & TH32CS_SNAPHEAPLIST) == 0 )
	{
		if( !toolhelp.Open(toolhelp.GetFlags() | TH32CS_SNAPHEAPLIST) ) return 0;
	}
	if( toolhelp.Heap32ListFirst(&m_List) )
	{
		while(1)
		{
			if( m_List.th32ProcessID == dwProcessId )
			{
				return m_List.th32HeapID;
			}
			if( !toolhelp.Heap32ListNext(&m_List) ) break;
		}
	}
	return 0;
}

/**********************************************************************//**
 *
 * vZXID玟
 *
 -----------------------------------------------------------------------
 * @param [in]	dwOwnerProcessId	= vZXID
 * @return	XbhID
*//***********************************************************************/
ULONG_PTR CFindHeapList::FindHeapIdNext(DWORD dwProcessId)
{
	CToolHelp toolhelp = CToolHelp::CreateImplement();
	while(1)
	{
		if( !toolhelp.Heap32ListNext(&m_List) ) break;
		if( m_List.th32ProcessID == dwProcessId )
		{
			return m_List.th32HeapID;
		}
	}
	return 0;
}

}	// end of namespace wx
}	// end of namespace iris

#if	(defined(_IRIS_SUPPORT_GOOGLETEST) || defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))

//======================================================================
// include
#include "unit/gt/gt_inchead.h"
#include "iris_using.h"

TEST(CFindHeapListTest, Function)
{
	CFindHeapList find;
	ASSERT_NE( 0, find.FindHeapId(::GetCurrentProcessId()) );
}

#endif
